/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.dotDesktopFiles;

import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.dotDesktopFiles.DotDesktopAccessor;
import com.jetbrains.toolbox.dotDesktopFiles.UtilKt;
import java.io.Closeable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nDotDesktopAccessorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotDesktopAccessorImpl.kt\ncom/jetbrains/toolbox/dotDesktopFiles/DotDesktopAccessorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,72:1\n1761#2,3:73\n80#3:76\n165#3:77\n81#3:78\n82#3:83\n52#4,4:79\n60#4,10:84\n56#4,18:94\n*S KotlinDebug\n*F\n+ 1 DotDesktopAccessorImpl.kt\ncom/jetbrains/toolbox/dotDesktopFiles/DotDesktopAccessorImpl\n*L\n38#1:73,3\n54#1:76\n54#1:77\n54#1:78\n54#1:83\n54#1:79,4\n54#1:84,10\n54#1:94,18\n*E\n"})
public final class DotDesktopAccessorImpl
implements DotDesktopAccessor {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Function1<Path, Unit> updateMimeTypesDb;

    public DotDesktopAccessorImpl(@NotNull FileSystem fileSystem, @NotNull Function1<? super Path, Unit> updateMimeTypesDb) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter(updateMimeTypesDb, (String)"updateMimeTypesDb");
        this.fileSystem = fileSystem;
        this.updateMimeTypesDb = updateMimeTypesDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Map<String, String> ensureDotDesktopFile(@NotNull Path dotDesktopFilePath, @NotNull Map<String, String> updatedDotDesktopEntries, @NotNull Map<String, String> customizableEntries) {
        BufferedSink bufferedSink;
        Throwable thrown$iv$iv;
        FileSystem $this$ensureDotDesktopFile_u24lambda_u243;
        Map<String, String> existingDotDesktopEntries;
        Map customizableEntries2;
        Map updatedDotDesktopEntries2;
        block25: {
            void $this$iv;
            StringBuilder stringBuilder;
            Object it;
            Map alreadyCustomizedEntries;
            boolean needRewrite;
            block28: {
                block27: {
                    Intrinsics.checkNotNullParameter((Object)dotDesktopFilePath, (String)"dotDesktopFilePath");
                    Intrinsics.checkNotNullParameter(updatedDotDesktopEntries, (String)"updatedDotDesktopEntries");
                    Intrinsics.checkNotNullParameter(customizableEntries, (String)"customizableEntries");
                    needRewrite = !this.fileSystem.exists(dotDesktopFilePath);
                    alreadyCustomizedEntries = new LinkedHashMap();
                    updatedDotDesktopEntries2 = MapsKt.toMutableMap(updatedDotDesktopEntries);
                    customizableEntries2 = MapsKt.toMutableMap(customizableEntries);
                    existingDotDesktopEntries = null;
                    if (!this.fileSystem.exists(dotDesktopFilePath)) break block27;
                    existingDotDesktopEntries = UtilKt.parseDotDesktopFile(this.fileSystem, dotDesktopFilePath);
                    for (Map.Entry<String, String> entry : existingDotDesktopEntries.entrySet()) {
                        String existingKey = entry.getKey();
                        String existingValue = entry.getValue();
                        String updatedValue = (String)updatedDotDesktopEntries2.get(existingKey);
                        if (updatedValue != null) {
                            boolean needToWriteUpdate = !Intrinsics.areEqual((Object)existingValue, (Object)updatedValue);
                            needRewrite = needRewrite || needToWriteUpdate;
                            continue;
                        }
                        customizableEntries2.remove(existingKey);
                        Map needToWriteUpdate = alreadyCustomizedEntries;
                        Pair pair = TuplesKt.to((Object)existingKey, (Object)existingValue);
                        needToWriteUpdate.put(pair.getFirst(), pair.getSecond());
                    }
                    if (!needRewrite) {
                        boolean bl;
                        block24: {
                            Iterable $this$any$iv = updatedDotDesktopEntries2.keySet();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    it = (String)element$iv;
                                    boolean bl2 = false;
                                    if (!(!existingDotDesktopEntries.keySet().contains(it))) continue;
                                    bl = true;
                                    break block24;
                                }
                                bl = false;
                            }
                        }
                        needRewrite = bl;
                    }
                    break block28;
                }
                existingDotDesktopEntries = MapsKt.emptyMap();
            }
            if (!needRewrite) {
                if (!(!customizableEntries2.isEmpty())) return existingDotDesktopEntries;
            }
            StringBuilder $this$ensureDotDesktopFile_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$ensureDotDesktopFile_u24lambda_u241.append("[Desktop Entry]").append('\n');
            for (Map.Entry bl2 : MapsKt.plus((Map)MapsKt.plus((Map)updatedDotDesktopEntries2, (Map)alreadyCustomizedEntries), (Map)customizableEntries2).entrySet()) {
                String key2 = (String)bl2.getKey();
                String value2 = (String)bl2.getValue();
                $this$ensureDotDesktopFile_u24lambda_u241.append(key2 + "=" + value2).append('\n');
            }
            String text2 = stringBuilder.toString();
            $this$ensureDotDesktopFile_u24lambda_u243 = this.fileSystem;
            boolean bl3 = false;
            Path path2 = dotDesktopFilePath.parent();
            Intrinsics.checkNotNull((Object)path2);
            $this$ensureDotDesktopFile_u24lambda_u243.createDirectories(path2);
            it = $this$ensureDotDesktopFile_u24lambda_u243;
            Path file$iv = dotDesktopFilePath;
            boolean mustCreate$iv = false;
            boolean bl4 = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                boolean bl5 = false;
                BufferedSink $this$ensureDotDesktopFile_u24lambda_u243_u24lambda_u242 = it$iv;
                boolean bl6 = false;
                bufferedSink = $this$ensureDotDesktopFile_u24lambda_u243_u24lambda_u242.writeUtf8(text2);
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    bufferedSink = null;
                    break block25;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block26: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv2;
                                break block26;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        BufferedSink result$iv$iv = bufferedSink;
        Throwable throwable = thrown$iv$iv;
        if (throwable != null) {
            throw throwable;
        }
        FileSystemExtKt.setReadable($this$ensureDotDesktopFile_u24lambda_u243, dotDesktopFilePath, true, false);
        FileSystemExtKt.setWritable($this$ensureDotDesktopFile_u24lambda_u243, dotDesktopFilePath, true, true);
        FileSystemExtKt.setExecutable($this$ensureDotDesktopFile_u24lambda_u243, dotDesktopFilePath, true, true);
        if (updatedDotDesktopEntries2.get("MimeType") == null || Intrinsics.areEqual((Object)existingDotDesktopEntries.get("MimeType"), updatedDotDesktopEntries2.get("MimeType"))) {
            if (customizableEntries2.get("MimeType") == null) return existingDotDesktopEntries;
        }
        Path path3 = dotDesktopFilePath.parent();
        Intrinsics.checkNotNull((Object)path3);
        this.updateMimeTypesDb.invoke((Object)path3);
        return existingDotDesktopEntries;
    }
}

