/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.docker.cli;

import com.jetbrains.toolbox.docker.ContainerInspectRecord;
import com.jetbrains.toolbox.docker.ContainerLsFilter;
import com.jetbrains.toolbox.docker.ContainerLsRecord;
import com.jetbrains.toolbox.docker.DockerEngine;
import com.jetbrains.toolbox.docker.ImageInspectRecord;
import com.jetbrains.toolbox.docker.cli.DockerCli;
import com.jetbrains.toolbox.docker.cli.DockerCliKt;
import com.jetbrains.toolbox.docker.cli.ProcessOutput;
import com.jetbrains.toolbox.docker.io.TarArchivesKt;
import com.jetbrains.toolbox.docker.util.ProcessStarterKt;
import com.jetbrains.toolbox.interop.ProcessOutputHandler;
import com.jetbrains.toolbox.interop.ProcessRunner;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Function;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nDockerCli.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerCli.kt\ncom/jetbrains/toolbox/docker/cli/DockerCli\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1374#2:168\n1460#2,5:169\n774#2:174\n865#2,2:175\n1563#2:177\n1634#2,3:178\n1374#2:181\n1460#2,5:182\n*S KotlinDebug\n*F\n+ 1 DockerCli.kt\ncom/jetbrains/toolbox/docker/cli/DockerCli\n*L\n43#1:168\n43#1:169,5\n52#1:174\n52#1:175,2\n53#1:177\n53#1:178,3\n119#1:181\n119#1:182,5\n*E\n"})
public final class DockerCli
implements DockerEngine {
    @NotNull
    private final ProcessRunner processes;
    @NotNull
    private final CoroutineScope coroutineScope;

    public DockerCli(@NotNull ProcessRunner processes, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)processes, (String)"processes");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.processes = processes;
        this.coroutineScope = coroutineScope;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ContainerLsRecord> listContainers(boolean all2, @NotNull List<? extends ContainerLsFilter> filters) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List list2;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        Iterable $this$flatMap$iv = filters;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ContainerLsFilter p0 = (ContainerLsFilter)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = DockerCliKt.access$toCliArguments(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List filterArguments = (List)destination$iv$iv;
        List $this$listContainers_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean $i$a$-buildList-DockerCli$listContainers$arguments$22 = false;
        Object[] $i$f$flatMapTo22 = new String[]{"ps", "--format", "json", "--no-trunc"};
        $this$listContainers_u24lambda_u240.addAll(CollectionsKt.listOf((Object[])$i$f$flatMapTo22));
        if (all2) {
            $this$listContainers_u24lambda_u240.add("--all");
        }
        $this$listContainers_u24lambda_u240.addAll(filterArguments);
        List arguments = CollectionsKt.build((List)list2);
        String stdout = this.runDocker(arguments).component1();
        Iterable $i$a$-buildList-DockerCli$listContainers$arguments$22 = StringsKt.lines((CharSequence)stdout);
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            Logger.INSTANCE.trace(() -> DockerCli.listContainers$lambda$3$lambda$2(it));
            collection.add(DockerCliKt.decodeAsDockerPsRecord(((Object)StringsKt.trim((CharSequence)it)).toString()));
        }
        return (List)destination$iv$iv2;
    }

    @Override
    @NotNull
    public ContainerInspectRecord inspectContainer(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object[] objectArray = new String[]{"inspect", "--type=container", id};
        String stdout = this.runDocker(CollectionsKt.listOf((Object[])objectArray)).component1();
        ContainerInspectRecord containerInspectRecord = (ContainerInspectRecord)CollectionsKt.firstOrNull(DockerCliKt.decodeDockerInspectOutput(stdout));
        if (containerInspectRecord == null) {
            throw new IllegalStateException(("Can't find inspection for " + id).toString());
        }
        return containerInspectRecord;
    }

    @Override
    @NotNull
    public ImageInspectRecord inspectImage(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object[] objectArray = new String[]{"inspect", "--type=image", id};
        String stdout = this.runDocker(CollectionsKt.listOf((Object[])objectArray)).component1();
        ImageInspectRecord imageInspectRecord = (ImageInspectRecord)CollectionsKt.firstOrNull(DockerCliKt.decodeDockerInspectImageOutput(stdout));
        if (imageInspectRecord == null) {
            throw new IllegalStateException(("Can't find inspection for " + id).toString());
        }
        return imageInspectRecord;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object copyFromContainer(@NotNull String containerId, @NotNull String sourcePath, @NotNull Continuation<? super TarArchiveInputStream> $completion) {
        if (!($completion instanceof copyFromContainer.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DockerCli this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.copyFromContainer(null, null, (Continuation<? super TarArchiveInputStream>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = new String[]{"cp", containerId + ":" + sourcePath, "-"};
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)containerId);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)sourcePath);
                $continuation.label = 1;
                v0 = this.docker(CollectionsKt.listOf((Object[])var5_7), (Continuation<? super Process>)$continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                sourcePath = (String)$continuation.L$1;
                containerId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                process = (Process)v0;
                return new TarArchiveInputStream(process.getInputStream());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object copyToContainer(@NotNull TarArchiveInputStream tarInputStream, @NotNull String containerId, @NotNull String targetPath, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof copyToContainer.1)) ** GOTO lbl-1000
        var9_5 = $completion;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ DockerCli this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.copyToContainer(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var6_8 = new String[]{"cp", "-", containerId + ":" + targetPath};
                arguments = CollectionsKt.listOf((Object[])var6_8);
                $continuation.L$0 = tarInputStream;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)containerId);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)targetPath);
                $continuation.L$3 = arguments;
                $continuation.label = 1;
                v0 = this.docker(arguments, (Continuation<? super Process>)$continuation);
                if (v0 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl30
            }
            case 1: {
                arguments = (List)$continuation.L$3;
                targetPath = (String)$continuation.L$2;
                containerId = (String)$continuation.L$1;
                tarInputStream = (TarArchiveInputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                process = (Process)v0;
                commandLine = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"docker"), (Iterable)arguments), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(process, commandLine, null){
                    int label;
                    final /* synthetic */ Process $process;
                    final /* synthetic */ String $commandLine;
                    {
                        this.$process = $process;
                        this.$commandLine = $commandLine;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$forEach$iv;
                                ResultKt.throwOnFailure((Object)$result);
                                BufferedReader bufferedReader = this.$process.errorReader();
                                Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"errorReader(...)");
                                Sequence sequence2 = TextStreamsKt.lineSequence((BufferedReader)bufferedReader);
                                String string = this.$commandLine;
                                boolean $i$f$forEach = false;
                                for (E element$iv : $this$forEach$iv) {
                                    String it = (String)element$iv;
                                    boolean bl = false;
                                    Logger.INSTANCE.trace("[" + string + "] [stderr] " + it);
                                }
                                int exitCode = this.$process.waitFor();
                                if (exitCode != 0) {
                                    Logger.INSTANCE.trace("[" + this.$commandLine + "] exited with code " + exitCode);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)tarInputStream);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)containerId);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)targetPath);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)arguments);
                $continuation.L$4 = process;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)commandLine);
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(process, tarInputStream, null){
                    Object L$0;
                    Object L$1;
                    int I$0;
                    int label;
                    final /* synthetic */ Process $process;
                    final /* synthetic */ TarArchiveInputStream $tarInputStream;
                    {
                        this.$process = $process;
                        this.$tarInputStream = $tarInputStream;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var2_3 = this.$process.getOutputStream();
                                var3_4 = this.$tarInputStream;
                                var4_5 = this.$process;
                                var5_6 = null;
                                it = (OutputStream)var2_3;
                                $i$a$-use-DockerCli$copyToContainer$3$1 = 0;
                                v0 = var4_5.getOutputStream();
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getOutputStream(...)");
                                this.L$0 = var2_3;
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)it);
                                this.I$0 = $i$a$-use-DockerCli$copyToContainer$3$1;
                                this.label = 1;
                                v1 = TarArchivesKt.copyTarStreamTo(var3_4, v0, (Continuation<? super Unit>)this);
                                ** if (v1 != var8_2) goto lbl22
lbl21:
                                // 1 sources

                                return var8_2;
lbl22:
                                // 1 sources

                                ** GOTO lbl32
                            }
                            case 1: {
                                $i$a$-use-DockerCli$copyToContainer$3$1 = this.I$0;
                                it = (OutputStream)this.L$1;
                                var5_6 = null;
                                var2_3 = (Closeable)this.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl32:
                                    // 2 sources

                                    var6_7 = Unit.INSTANCE;
                                    ** GOTO lbl42
                                }
                                catch (Throwable var7_10) {
                                    var5_6 = var7_10;
                                    throw var7_10;
                                }
                            }
                            catch (Throwable var7_11) {
                                throw var7_11;
                            }
                            {
                                finally {
                                    CloseableKt.closeFinally((Closeable)var2_3, (Throwable)var5_6);
                                }
lbl42:
                                // 1 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl54
            }
            case 2: {
                commandLine = (String)$continuation.L$5;
                process = (Process)$continuation.L$4;
                arguments = (List)$continuation.L$3;
                targetPath = (String)$continuation.L$2;
                containerId = (String)$continuation.L$1;
                tarInputStream = (TarArchiveInputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl54:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)tarInputStream);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)containerId);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)targetPath);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)arguments);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)process);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)commandLine);
                $continuation.label = 3;
                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(process, null){
                    int label;
                    final /* synthetic */ Process $process;
                    {
                        this.$process = $process;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                return Boxing.boxInt((int)this.$process.waitFor());
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl74
            }
            case 3: {
                commandLine = (String)$continuation.L$5;
                process = (Process)$continuation.L$4;
                arguments = (List)$continuation.L$3;
                targetPath = (String)$continuation.L$2;
                containerId = (String)$continuation.L$1;
                tarInputStream = (TarArchiveInputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl74:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object startContainer(@NotNull String containerId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new String[]{"start", containerId};
        Object object = this.docker(CollectionsKt.listOf((Object[])objectArray), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object exec(@NotNull String containerId, @NotNull List<String> command2, @Nullable String workingDirectory, @NotNull Map<String, String> environment, boolean interactive, @NotNull Continuation<? super Process> $completion) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object[] objectArray;
        List list2;
        List $this$exec_u24lambda_u245 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (workingDirectory != null) {
            objectArray = new String[]{"-w", workingDirectory};
            $this$exec_u24lambda_u245.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        objectArray = environment.entrySet();
        List list3 = $this$exec_u24lambda_u245;
        boolean $i$f$flatMap = false;
        void var14_13 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            String key2 = (String)entry.getKey();
            String value2 = (String)entry.getValue();
            Object[] objectArray2 = new String[]{"-e", key2 + "=" + value2};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        list3.addAll((List)destination$iv$iv);
        if (interactive) {
            $this$exec_u24lambda_u245.add("-i");
        }
        List options = CollectionsKt.build((List)list2);
        return this.docker(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"exec"), (Iterable)options), (Object)containerId), (Iterable)command2), $completion);
    }

    private final ProcessOutput runDocker(List<String> arguments) {
        StringBuilder stdout = new StringBuilder();
        StringBuilder stderr = new StringBuilder();
        Function1 function1 = (Function1)new Function1<String, Unit>((Object)stdout){

            public final void invoke(String p0) {
                ((StringBuilder)this.receiver).append(p0);
            }
        };
        ProcessOutputHandler.ReadLineByLine readLineByLine = new ProcessOutputHandler.ReadLineByLine(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void read(String line) {
                this.function.invoke((Object)line);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof ProcessOutputHandler.ReadLineByLine ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        };
        function1 = (Function1)new Function1<String, Unit>((Object)stderr){

            public final void invoke(String p0) {
                ((StringBuilder)this.receiver).append(p0);
            }
        };
        this.docker(arguments, readLineByLine, new /* invalid duplicate definition of identical inner class */);
        String string = stdout.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = stderr.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return new ProcessOutput(string, string2);
    }

    private final void docker(List<String> arguments, ProcessOutputHandler handleOut, ProcessOutputHandler handleErr) {
        Logger.INSTANCE.trace(() -> DockerCli.docker$lambda$7(arguments));
        ProcessRunner.executeProcessAndWait-B8UsjHI$default(this.processes, new File("docker"), arguments, null, handleOut, handleErr, null, 0L, 96, null);
    }

    private final Object docker(List<String> arguments, Continuation<? super Process> $completion) {
        Logger.INSTANCE.trace(() -> DockerCli.docker$lambda$8(arguments));
        return ProcessStarterKt.startProcess$default(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"docker"), (Iterable)arguments), null, null, $completion, 6, null);
    }

    private static final String listContainers$lambda$3$lambda$2(String $it) {
        return "Trying to decode information about Docker container from the line: " + $it;
    }

    private static final String docker$lambda$7(List $arguments) {
        return "Executing `docker " + CollectionsKt.joinToString$default((Iterable)$arguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "`";
    }

    private static final String docker$lambda$8(List $arguments) {
        return "Executing `docker " + CollectionsKt.joinToString$default((Iterable)$arguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "`";
    }
}

