/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.devcontainers.gateway;

import com.jetbrains.toolbox.api.remoteDev.connection.AgentConnection;
import com.jetbrains.toolbox.api.remoteDev.connection.AgentConnectionHandle;
import com.jetbrains.toolbox.api.remoteDev.connection.ForwardedConnection;
import com.jetbrains.toolbox.api.remoteDev.connection.ForwardedConnectionHandle;
import com.jetbrains.toolbox.api.remoteDev.connection.HostTunnelConnector;
import com.jetbrains.toolbox.docker.Binding;
import com.jetbrains.toolbox.docker.ContainerInspectRecord;
import com.jetbrains.toolbox.docker.DockerEngine;
import com.jetbrains.toolbox.docker.ExposedPort;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerPortBindingConnector
implements HostTunnelConnector {
    @NotNull
    private final DockerEngine dockerEngine;
    @NotNull
    private final String containerId;
    @NotNull
    private final CoroutineScope coroutineScope;

    public DockerPortBindingConnector(@NotNull DockerEngine dockerEngine, @NotNull String containerId, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)dockerEngine, (String)"dockerEngine");
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.dockerEngine = dockerEngine;
        this.containerId = containerId;
        this.coroutineScope = coroutineScope;
    }

    public boolean isProtocolSupported(@NotNull HostTunnelConnector.Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        return true;
    }

    @NotNull
    public ForwardedConnectionHandle forwardIdePort(@NotNull HostTunnelConnector.Protocol protocol, @NotNull InetAddress remoteAddress2, int remotePort, @NotNull InetAddress localAddress) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)remoteAddress2, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        return new DockerPortBindingHandle(this.dockerEngine, this.containerId, remotePort);
    }

    @NotNull
    public final AgentConnectionHandle forwardAgentPort(int remotePort) {
        return new DockerAgentPortBindingHandle(this.dockerEngine, this.coroutineScope, this.containerId, remotePort);
    }

    @NotNull
    public String toString() {
        return "DockerPortBindingConnector(dockerEngine=" + this.dockerEngine + ", containerId=" + this.containerId + ", coroutineScope=" + this.coroutineScope + ")";
    }

    public int hashCode() {
        int result2 = this.dockerEngine.hashCode();
        result2 = result2 * 31 + this.containerId.hashCode();
        result2 = result2 * 31 + this.coroutineScope.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DockerPortBindingConnector)) {
            return false;
        }
        DockerPortBindingConnector dockerPortBindingConnector = (DockerPortBindingConnector)other;
        if (!Intrinsics.areEqual((Object)this.dockerEngine, (Object)dockerPortBindingConnector.dockerEngine)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.containerId, (Object)dockerPortBindingConnector.containerId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.coroutineScope, (Object)dockerPortBindingConnector.coroutineScope);
    }

    public static final class DockerAgentPortBindingHandle
    implements AgentConnectionHandle {
        @NotNull
        private final DockerEngine dockerEngine;
        @NotNull
        private final CoroutineScope coroutineScope;
        @NotNull
        private final String containerId;
        private final int remotePort;

        public DockerAgentPortBindingHandle(@NotNull DockerEngine dockerEngine, @NotNull CoroutineScope coroutineScope, @NotNull String containerId, int remotePort) {
            Intrinsics.checkNotNullParameter((Object)dockerEngine, (String)"dockerEngine");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
            this.dockerEngine = dockerEngine;
            this.coroutineScope = coroutineScope;
            this.containerId = containerId;
            this.remotePort = remotePort;
        }

        @Nullable
        public Object getAgentConnection(@NotNull Continuation<? super AgentConnection> $completion) {
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AgentConnection>, Object>(this, null){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                int I$1;
                int I$2;
                long J$0;
                int label;
                final /* synthetic */ DockerAgentPortBindingHandle this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    block15: {
                        var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                inspectContainer = DockerAgentPortBindingHandle.access$getDockerEngine$p(this.this$0).inspectContainer(DockerAgentPortBindingHandle.access$getContainerId$p(this.this$0));
                                var5_4 = inspectContainer.getNetworkSettings().getPorts().entrySet();
                                var6_5 = this.this$0;
                                $i$f$firstOrNull = 0;
                                var8_8 = $this$firstOrNull$iv.iterator();
                                while (var8_8.hasNext()) {
                                    element$iv = var8_8.next();
                                    it = (Map.Entry)element$iv;
                                    $i$a$-firstOrNull-DockerPortBindingConnector$DockerAgentPortBindingHandle$getAgentConnection$2$portBinding$1 = false;
                                    if (!(((ExposedPort)it.getKey()).getPort() == DockerAgentPortBindingHandle.access$getRemotePort$p((DockerAgentPortBindingHandle)var6_5))) continue;
                                    v0 = element$iv;
                                    ** GOTO lbl18
                                }
                                v0 = null;
lbl18:
                                // 2 sources

                                v1 = v0;
                                if (v1 == null) {
                                    $this$firstOrNull$iv = "Binding of the port " + DockerAgentPortBindingHandle.access$getRemotePort$p(this.this$0) + " not found, while dynamic port forwarding is not supported for Docker containers";
                                    throw new IllegalStateException($this$firstOrNull$iv.toString());
                                }
                                portBinding = v1;
                                v2 = (Binding)CollectionsKt.firstOrNull((List)((List)portBinding.getValue()));
                                if (v2 == null) {
                                    var6_5 = "Exposed container port " + ((ExposedPort)portBinding.getKey()).getPort() + " is not bound to any host port";
                                    throw new IllegalStateException(var6_5.toString());
                                }
                                binding = v2;
                                $i$f$firstOrNull = 6;
                                initialDelay$iv = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
                                $i$f$retryWithBackoff-dWUq8MI = 0;
                                attempt$iv = 0;
lbl33:
                                // 2 sources

                                while (attempt$iv < attempts$iv) {
                                    try {
                                        it = attempt$iv;
                                        $i$a$-retryWithBackoff-dWUq8MI-DockerPortBindingConnector$DockerAgentPortBindingHandle$getAgentConnection$2$socket$1 = false;
                                        currSocket = new Socket();
                                        try {
                                            currSocket.connect(new InetSocketAddress(InetAddress.getLoopbackAddress(), binding.getPort()));
                                            var15_21 = currSocket;
                                        }
                                        catch (IOException <unused var>) {
                                            currSocket.close();
                                            var15_21 = null;
                                        }
                                        result$iv = var15_21;
                                        if (result$iv != null) {
                                            v3 = result$iv;
                                            break block15;
                                        }
                                    }
                                    catch (Exception var12_18) {
                                        // empty catch block
                                    }
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)inspectContainer);
                                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)portBinding);
                                    this.L$2 = binding;
                                    this.I$0 = attempts$iv;
                                    this.J$0 = initialDelay$iv;
                                    this.I$1 = $i$f$retryWithBackoff-dWUq8MI;
                                    this.I$2 = attempt$iv;
                                    this.label = 1;
                                    v4 = DelayKt.delay-VtjQ1oo((long)Duration.times-UwyO8pc((long)initialDelay$iv, (double)Math.pow(2.0, attempt$iv)), (Continuation)((Continuation)this));
                                    if (v4 == var17_2) {
                                        return var17_2;
                                    }
                                    ** GOTO lbl78
                                }
                                break;
                            }
                            case 1: {
                                attempt$iv = this.I$2;
                                $i$f$retryWithBackoff-dWUq8MI = this.I$1;
                                initialDelay$iv = this.J$0;
                                attempts$iv = this.I$0;
                                binding = (Binding)this.L$2;
                                portBinding = (Map.Entry)this.L$1;
                                inspectContainer = (ContainerInspectRecord)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
lbl78:
                                // 2 sources

                                ++attempt$iv;
                                ** GOTO lbl33
                            }
                        }
                        v3 = null;
                    }
                    if (v3 == null) {
                        var7_7 = "Could not connect socket to bound port";
                        throw new IllegalStateException(var7_7.toString());
                    }
                    socket = v3;
                    v5 = socket.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getInputStream(...)");
                    v6 = socket.getOutputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getOutputStream(...)");
                    return new AgentConnection(v5, v6);
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super AgentConnection> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        @Nullable
        public Object close(@NotNull Continuation<? super Unit> $completion) {
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ DockerEngine access$getDockerEngine$p(DockerAgentPortBindingHandle $this) {
            return $this.dockerEngine;
        }

        public static final /* synthetic */ String access$getContainerId$p(DockerAgentPortBindingHandle $this) {
            return $this.containerId;
        }

        public static final /* synthetic */ int access$getRemotePort$p(DockerAgentPortBindingHandle $this) {
            return $this.remotePort;
        }
    }

    public static final class DockerPortBindingHandle
    implements ForwardedConnectionHandle {
        @NotNull
        private final DockerEngine dockerEngine;
        @NotNull
        private final String containerId;
        private final int remotePort;

        public DockerPortBindingHandle(@NotNull DockerEngine dockerEngine, @NotNull String containerId, int remotePort) {
            Intrinsics.checkNotNullParameter((Object)dockerEngine, (String)"dockerEngine");
            Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
            this.dockerEngine = dockerEngine;
            this.containerId = containerId;
            this.remotePort = remotePort;
        }

        @Nullable
        public Object getForwardedConnection(@NotNull Continuation<? super ForwardedConnection> $completion) {
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ForwardedConnection>, Object>(this, null){
                int label;
                final /* synthetic */ DockerPortBindingHandle this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            inspectContainer = DockerPortBindingHandle.access$getDockerEngine$p(this.this$0).inspectContainer(DockerPortBindingHandle.access$getContainerId$p(this.this$0));
                            var5_3 = inspectContainer.getNetworkSettings().getPorts().entrySet();
                            var6_4 = this.this$0;
                            $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                it = (Map.Entry)element$iv;
                                $i$a$-firstOrNull-DockerPortBindingConnector$DockerPortBindingHandle$getForwardedConnection$2$portBinding$1 = false;
                                if (!(((ExposedPort)it.getKey()).getPort() == DockerPortBindingHandle.access$getRemotePort$p(var6_4))) continue;
                                v0 = element$iv;
                                ** GOTO lbl17
                            }
                            v0 = null;
lbl17:
                            // 2 sources

                            v1 = v0;
                            if (v1 == null) {
                                throw new IllegalStateException(("Binding of the port " + DockerPortBindingHandle.access$getRemotePort$p(this.this$0) + " not found, while dynamic port forwarding is not supported for Docker containers").toString());
                            }
                            portBinding = v1;
                            v2 = (Binding)CollectionsKt.firstOrNull((List)((List)portBinding.getValue()));
                            if (v2 == null) {
                                throw new IllegalStateException(("Exposed container port " + ((ExposedPort)portBinding.getKey()).getPort() + " is not bound to any host port").toString());
                            }
                            binding = v2;
                            return new ForwardedConnection(binding.getPort(), DockerPortBindingHandle.access$getRemotePort$p(this.this$0));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super ForwardedConnection> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        public void close() {
        }

        public static final /* synthetic */ DockerEngine access$getDockerEngine$p(DockerPortBindingHandle $this) {
            return $this.dockerEngine;
        }

        public static final /* synthetic */ String access$getContainerId$p(DockerPortBindingHandle $this) {
            return $this.containerId;
        }

        public static final /* synthetic */ int access$getRemotePort$p(DockerPortBindingHandle $this) {
            return $this.remotePort;
        }
    }
}

