/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.devcontainers.agent.deployer;

import com.jetbrains.toolbox.agent.ConnectionDetails;
import com.jetbrains.toolbox.agent.ListenOn;
import com.jetbrains.toolbox.api.core.Arch;
import com.jetbrains.toolbox.api.core.OS;
import com.jetbrains.toolbox.api.remoteDev.deploy.AgentDistributionProvider;
import com.jetbrains.toolbox.api.remoteDev.deploy.DeploymentSettings;
import com.jetbrains.toolbox.api.remoteDev.deploy.DistributionInfo;
import com.jetbrains.toolbox.common.io.InputStreamRepeatableFlow;
import com.jetbrains.toolbox.devcontainers.agent.deployer.DockerToolboxAgentDeployer;
import com.jetbrains.toolbox.devcontainers.agent.deployer.RunningAgentData;
import com.jetbrains.toolbox.devcontainers.docker.CopyToContainerKt;
import com.jetbrains.toolbox.docker.ContainerInspectRecord;
import com.jetbrains.toolbox.docker.ContainersKt;
import com.jetbrains.toolbox.docker.DockerEngine;
import com.jetbrains.toolbox.docker.ImageInspectRecord;
import com.jetbrains.toolbox.gateway.deploy.DeployUtil;
import com.jetbrains.toolbox.network.DownloadManager;
import java.net.URI;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nDockerToolboxAgentDeployer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerToolboxAgentDeployer.kt\ncom/jetbrains/toolbox/devcontainers/agent/deployer/DockerToolboxAgentDeployer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,189:1\n1#2:190\n222#3:191\n*S KotlinDebug\n*F\n+ 1 DockerToolboxAgentDeployer.kt\ncom/jetbrains/toolbox/devcontainers/agent/deployer/DockerToolboxAgentDeployer\n*L\n129#1:191\n*E\n"})
public final class DockerToolboxAgentDeployer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DockerEngine dockerEngine;
    @NotNull
    private final AgentDistributionProvider agentDistributionProvider;
    @NotNull
    private final DownloadManager downloadManager;
    @NotNull
    private final FileSystem fileSystem;

    public DockerToolboxAgentDeployer(@NotNull DockerEngine dockerEngine, @NotNull AgentDistributionProvider agentDistributionProvider, @NotNull DownloadManager downloadManager, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)dockerEngine, (String)"dockerEngine");
        Intrinsics.checkNotNullParameter((Object)agentDistributionProvider, (String)"agentDistributionProvider");
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.dockerEngine = dockerEngine;
        this.agentDistributionProvider = agentDistributionProvider;
        this.downloadManager = downloadManager;
        this.fileSystem = fileSystem;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object startAgent(@NotNull String containerId, @NotNull DeploymentSettings deploymentSettings, boolean forcefulDeploy, @NotNull Continuation<? super RunningAgentData> $completion) {
        block41: {
            if (!($completion instanceof startAgent.1)) ** GOTO lbl-1000
            var37_5 = $completion;
            if ((var37_5.label & -2147483648) != 0) {
                var37_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    Object L$9;
                    Object L$10;
                    Object L$11;
                    Object L$12;
                    Object L$13;
                    Object L$14;
                    Object L$15;
                    Object L$16;
                    Object L$17;
                    Object L$18;
                    Object L$19;
                    Object L$20;
                    boolean Z$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ DockerToolboxAgentDeployer this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.startAgent(null, null, false, (Continuation<? super RunningAgentData>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var38_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = containerId;
                    $continuation.L$1 = deploymentSettings;
                    $continuation.Z$0 = forcefulDeploy;
                    $continuation.label = 1;
                    v0 = this.agentDistributionProvider.getAgentDistribution(OS.Linux, Arch.X64, false, (Continuation)$continuation);
                    if (v0 == var38_7) {
                        return var38_7;
                    }
                    ** GOTO lbl26
                }
                case 1: {
                    forcefulDeploy = $continuation.Z$0;
                    deploymentSettings = (DeploymentSettings)$continuation.L$1;
                    containerId = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    agentDistribution = (DistributionInfo)v0;
                    $continuation.L$0 = containerId;
                    $continuation.L$1 = deploymentSettings;
                    $continuation.L$2 = agentDistribution;
                    $continuation.Z$0 = forcefulDeploy;
                    $continuation.label = 2;
                    v1 = this.agentDistributionProvider.getAgentBuild(OS.Linux, Arch.X64, (Continuation)$continuation);
                    if (v1 == var38_7) {
                        return var38_7;
                    }
                    ** GOTO lbl43
                }
                case 2: {
                    forcefulDeploy = $continuation.Z$0;
                    agentDistribution = (DistributionInfo)$continuation.L$2;
                    deploymentSettings = (DeploymentSettings)$continuation.L$1;
                    containerId = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl43:
                    // 2 sources

                    agentBuild = (String)v1;
                    container = this.dockerEngine.inspectContainer(containerId);
                    imageId = container.getImage();
                    image = this.dockerEngine.inspectImage(imageId);
                    Logger.INSTANCE.info("Docker container OS: " + image.getOs() + ", architecture: " + image.getArchitecture());
                    os = com.jetbrains.toolbox.devcontainers.agent.deployer.DockerToolboxAgentDeployer$Companion.access$asSupportedOs(DockerToolboxAgentDeployer.Companion, image.getOs());
                    architecture = com.jetbrains.toolbox.devcontainers.agent.deployer.DockerToolboxAgentDeployer$Companion.access$normalizeArchitecture(DockerToolboxAgentDeployer.Companion, image.getArchitecture());
                    systemAndArch = os + "_" + architecture;
                    Logger.INSTANCE.info("Using " + (String)systemAndArch + " to download JBR for " + containerId);
                    $continuation.L$0 = containerId;
                    $continuation.L$1 = deploymentSettings;
                    $continuation.L$2 = agentDistribution;
                    $continuation.L$3 = agentBuild;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)container);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)imageId);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)image);
                    $continuation.L$7 = os;
                    $continuation.L$8 = architecture;
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)systemAndArch);
                    $continuation.Z$0 = forcefulDeploy;
                    $continuation.label = 3;
                    v2 = this.agentDistributionProvider.getJreDistribution(OS.Linux, Arch.X64, (Continuation)$continuation);
                    if (v2 == var38_7) {
                        return var38_7;
                    }
                    ** GOTO lbl82
                }
                case 3: {
                    forcefulDeploy = $continuation.Z$0;
                    systemAndArch = (String)$continuation.L$9;
                    architecture = (String)$continuation.L$8;
                    os = (SupportedOs)$continuation.L$7;
                    image = (ImageInspectRecord)$continuation.L$6;
                    imageId = (String)$continuation.L$5;
                    container = (ContainerInspectRecord)$continuation.L$4;
                    agentBuild = (String)$continuation.L$3;
                    agentDistribution = (DistributionInfo)$continuation.L$2;
                    deploymentSettings = (DeploymentSettings)$continuation.L$1;
                    containerId = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl82:
                    // 2 sources

                    if ((var14_24 = (DistributionInfo)v2) == null) ** GOTO lbl88
                    dist = var14_24;
                    $i$a$-let-DockerToolboxAgentDeployer$startAgent$2 = false;
                    var15_31 = TuplesKt.to((Object)dist.getUri(), (Object)dist.getSha256());
                    if (var15_31 != null) ** GOTO lbl89
lbl88:
                    // 2 sources

                    throw new IllegalStateException(("Combination of " + os + " and " + architecture + " is not supported").toString());
lbl89:
                    // 1 sources

                    var13_33 = var15_31;
                    url = (URI)var13_33.component1();
                    sha256 = (String)var13_33.component2();
                    Logger.INSTANCE.info("JBR download url: " + url);
                    $continuation.L$0 = containerId;
                    $continuation.L$1 = deploymentSettings;
                    $continuation.L$2 = agentDistribution;
                    $continuation.L$3 = agentBuild;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)container);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)imageId);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)image);
                    $continuation.L$7 = os;
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)architecture);
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)systemAndArch);
                    $continuation.L$10 = url;
                    $continuation.L$11 = sha256;
                    $continuation.Z$0 = forcefulDeploy;
                    $continuation.label = 4;
                    v3 = this.dockerEngine.startContainer(containerId, (Continuation<? super Unit>)$continuation);
                    if (v3 == var38_7) {
                        return var38_7;
                    }
                    ** GOTO lbl127
                }
                case 4: {
                    forcefulDeploy = $continuation.Z$0;
                    sha256 = (String)$continuation.L$11;
                    url = (URI)$continuation.L$10;
                    systemAndArch = (String)$continuation.L$9;
                    architecture = (String)$continuation.L$8;
                    os = (SupportedOs)$continuation.L$7;
                    image = (ImageInspectRecord)$continuation.L$6;
                    imageId = (String)$continuation.L$5;
                    container = (ContainerInspectRecord)$continuation.L$4;
                    agentBuild = (String)$continuation.L$3;
                    agentDistribution = (DistributionInfo)$continuation.L$2;
                    deploymentSettings = (DeploymentSettings)$continuation.L$1;
                    containerId = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl127:
                    // 2 sources

                    $continuation.L$0 = containerId;
                    $continuation.L$1 = deploymentSettings;
                    $continuation.L$2 = agentDistribution;
                    $continuation.L$3 = agentBuild;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)container);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)imageId);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)image);
                    $continuation.L$7 = os;
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)architecture);
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)systemAndArch);
                    $continuation.L$10 = url;
                    $continuation.L$11 = sha256;
                    $continuation.Z$0 = forcefulDeploy;
                    $continuation.label = 5;
                    v4 = ContainersKt.homeDirectory(this.dockerEngine, containerId, (Continuation<? super String>)$continuation);
                    if (v4 == var38_7) {
                        return var38_7;
                    }
                    ** GOTO lbl161
                }
                case 5: {
                    forcefulDeploy = $continuation.Z$0;
                    sha256 = (String)$continuation.L$11;
                    url = (URI)$continuation.L$10;
                    systemAndArch = (String)$continuation.L$9;
                    architecture = (String)$continuation.L$8;
                    os = (SupportedOs)$continuation.L$7;
                    image = (ImageInspectRecord)$continuation.L$6;
                    imageId = (String)$continuation.L$5;
                    container = (ContainerInspectRecord)$continuation.L$4;
                    agentBuild = (String)$continuation.L$3;
                    agentDistribution = (DistributionInfo)$continuation.L$2;
                    deploymentSettings = (DeploymentSettings)$continuation.L$1;
                    containerId = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl161:
                    // 2 sources

                    if ((v5 = (homeDirectory = (String)v4)) == null) {
                        v5 = "<unable to determine>";
                    }
                    Logger.INSTANCE.info("Home directory for the user in " + containerId + ": " + v5);
                    overriddenCacheDir = deploymentSettings.getTbcliLocationOverride();
                    $i$a$-let-DockerToolboxAgentDeployer$startAgent$cacheDir$1 = false;
                    if (overriddenCacheDir != null) {
                        Logger.INSTANCE.info("Toolbox Agent cache directory overridden to " + overriddenCacheDir);
                    }
                    if ((v6 = overriddenCacheDir) == null) {
                        v6 = com.jetbrains.toolbox.devcontainers.agent.deployer.DockerToolboxAgentDeployer$Companion.access$getCacheDir(DockerToolboxAgentDeployer.Companion, homeDirectory, os);
                    }
                    cacheDir = v6;
                    Logger.INSTANCE.info("Ensure cache directory " + cacheDir + " exists in the container");
                    $continuation.L$0 = containerId;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)deploymentSettings);
                    $continuation.L$2 = agentDistribution;
                    $continuation.L$3 = agentBuild;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)container);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)imageId);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)image);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)os);
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)architecture);
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)systemAndArch);
                    $continuation.L$10 = url;
                    $continuation.L$11 = sha256;
                    $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)homeDirectory);
                    $continuation.L$13 = cacheDir;
                    $continuation.Z$0 = forcefulDeploy;
                    $continuation.label = 6;
                    v7 = this.ensureDirectoryExistsInContainer(containerId, cacheDir, (Continuation<? super Unit>)$continuation);
                    if (v7 == var38_7) {
                        return var38_7;
                    }
                    ** GOTO lbl211
                }
                case 6: {
                    forcefulDeploy = $continuation.Z$0;
                    cacheDir = (String)$continuation.L$13;
                    homeDirectory = (String)$continuation.L$12;
                    sha256 = (String)$continuation.L$11;
                    url = (URI)$continuation.L$10;
                    systemAndArch = (String)$continuation.L$9;
                    architecture = (String)$continuation.L$8;
                    os = (SupportedOs)$continuation.L$7;
                    image = (ImageInspectRecord)$continuation.L$6;
                    imageId = (String)$continuation.L$5;
                    container = (ContainerInspectRecord)$continuation.L$4;
                    agentBuild = (String)$continuation.L$3;
                    agentDistribution = (DistributionInfo)$continuation.L$2;
                    deploymentSettings = (DeploymentSettings)$continuation.L$1;
                    containerId = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
lbl211:
                    // 2 sources

                    v8 = url.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"toString(...)");
                    $continuation.L$0 = containerId;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)deploymentSettings);
                    $continuation.L$2 = agentDistribution;
                    $continuation.L$3 = agentBuild;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)container);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)imageId);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)image);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)os);
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)architecture);
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)systemAndArch);
                    $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)url);
                    $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)sha256);
                    $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)homeDirectory);
                    $continuation.L$13 = cacheDir;
                    $continuation.Z$0 = forcefulDeploy;
                    $continuation.label = 7;
                    v9 = this.downloadAndExtractJbrToContainer(containerId, v8, sha256, cacheDir, (Continuation<? super String>)$continuation);
                    if (v9 == var38_7) {
                        return var38_7;
                    }
                    ** GOTO lbl251
                }
                case 7: {
                    forcefulDeploy = $continuation.Z$0;
                    cacheDir = (String)$continuation.L$13;
                    homeDirectory = (String)$continuation.L$12;
                    sha256 = (String)$continuation.L$11;
                    url = (URI)$continuation.L$10;
                    systemAndArch = (String)$continuation.L$9;
                    architecture = (String)$continuation.L$8;
                    os = (SupportedOs)$continuation.L$7;
                    image = (ImageInspectRecord)$continuation.L$6;
                    imageId = (String)$continuation.L$5;
                    container = (ContainerInspectRecord)$continuation.L$4;
                    agentBuild = (String)$continuation.L$3;
                    agentDistribution = (DistributionInfo)$continuation.L$2;
                    deploymentSettings = (DeploymentSettings)$continuation.L$1;
                    containerId = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v9 = $result;
lbl251:
                    // 2 sources

                    jbrPathInContainer = (String)v9;
                    if (agentDistribution == null) {
                        throw new IllegalStateException(("Toolbox agent " + agentBuild + " is unavailable").toString());
                    }
                    cliHash = agentDistribution.getSha256();
                    Logger.INSTANCE.info("Toolbox Agent: version = " + agentBuild + ", sha256 = (" + cliHash + ")");
                    if (!Intrinsics.areEqual((Object)agentDistribution.getUri().getScheme(), (Object)"file")) break;
                    $continuation.L$0 = containerId;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)deploymentSettings);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)agentDistribution);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)agentBuild);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)container);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)imageId);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)image);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)os);
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)architecture);
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)systemAndArch);
                    $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)url);
                    $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)sha256);
                    $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)homeDirectory);
                    $continuation.L$13 = cacheDir;
                    $continuation.L$14 = jbrPathInContainer;
                    $continuation.L$15 = cliHash;
                    $continuation.Z$0 = forcefulDeploy;
                    $continuation.label = 8;
                    v10 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(agentDistribution, this, containerId, cacheDir, agentBuild, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ DistributionInfo $agentDistribution;
                        final /* synthetic */ DockerToolboxAgentDeployer this$0;
                        final /* synthetic */ String $containerId;
                        final /* synthetic */ String $cacheDir;
                        final /* synthetic */ String $agentBuild;
                        {
                            this.$agentDistribution = $agentDistribution;
                            this.this$0 = $receiver;
                            this.$containerId = $containerId;
                            this.$cacheDir = $cacheDir;
                            this.$agentBuild = $agentBuild;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    void $this$coroutineScope;
                                    ResultKt.throwOnFailure((Object)$result);
                                    java.nio.file.Path path2 = Paths.get(this.$agentDistribution.getUri());
                                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                                    this.label = 1;
                                    Object object2 = CopyToContainerKt.copyRegularFileToContainer(path2, DockerToolboxAgentDeployer.access$getDockerEngine$p(this.this$0), this.$containerId, this.$cacheDir, "tbcli-" + this.$agentBuild + ".tar.gz", (CoroutineScope)$this$coroutineScope, (Continuation<? super String>)((Continuation)this));
                                    if (object2 != object) return object2;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return object2;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value2;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v10 == var38_7) {
                        return var38_7;
                    }
                    break block41;
                }
                case 8: {
                    forcefulDeploy = $continuation.Z$0;
                    cliHash = (String)$continuation.L$15;
                    jbrPathInContainer = (String)$continuation.L$14;
                    cacheDir = (String)$continuation.L$13;
                    homeDirectory = (String)$continuation.L$12;
                    sha256 = (String)$continuation.L$11;
                    url = (URI)$continuation.L$10;
                    systemAndArch = (String)$continuation.L$9;
                    architecture = (String)$continuation.L$8;
                    os = (SupportedOs)$continuation.L$7;
                    image = (ImageInspectRecord)$continuation.L$6;
                    imageId = (String)$continuation.L$5;
                    container = (ContainerInspectRecord)$continuation.L$4;
                    agentBuild = (String)$continuation.L$3;
                    agentDistribution = (DistributionInfo)$continuation.L$2;
                    deploymentSettings = (DeploymentSettings)$continuation.L$1;
                    containerId = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v10 = $result;
                    break block41;
                }
            }
            agentDistribution.getUri().toString();
            var22_40 = "We need to download the Toolbox Client anyway";
            throw new NotImplementedError("An operation is not implemented: " + var22_40);
        }
        var19_36 = TuplesKt.to((Object)((String)v10), (Object)cliHash);
        cliPath = (String)var19_36.component1();
        cliHash = (String)var19_36.component2();
        javaPath = jbrPathInContainer + "/bin/java";
        $this$startAgent_u24lambda_u242 = var24_44 = CollectionsKt.createListBuilder();
        $i$a$-buildList-DockerToolboxAgentDeployer$startAgent$toolboxAgentCommand$1 = false;
        $this$startAgent_u24lambda_u242.add(javaPath);
        $this$startAgent_u24lambda_u242.add("-Dfile.encoding=UTF-8");
        var27_50 = new String[]{"-jar", cliPath};
        $this$startAgent_u24lambda_u242.addAll(CollectionsKt.listOf((Object[])var27_50));
        $this$startAgent_u24lambda_u242.add("agent-proxy");
        if (forcefulDeploy) {
            $this$startAgent_u24lambda_u242.add("--force-deploy");
        }
        toolboxAgentCommand = CollectionsKt.build((List)var24_44);
        $continuation.L$0 = containerId;
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)deploymentSettings);
        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)agentDistribution);
        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)agentBuild);
        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)container);
        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)imageId);
        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)image);
        $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)os);
        $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)architecture);
        $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)systemAndArch);
        $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)url);
        $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)sha256);
        $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)homeDirectory);
        $continuation.L$13 = cacheDir;
        $continuation.L$14 = SpillingKt.nullOutSpilledVariable((Object)jbrPathInContainer);
        $continuation.L$15 = cliPath;
        $continuation.L$16 = cliHash;
        $continuation.L$17 = javaPath;
        $continuation.L$18 = toolboxAgentCommand;
        $continuation.Z$0 = forcefulDeploy;
        $continuation.label = 9;
        v11 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), (Continuation)$continuation);
        if (v11 == var38_7) {
            return var38_7;
        }
        ** GOTO lbl374
        {
            case 9: {
                forcefulDeploy = $continuation.Z$0;
                toolboxAgentCommand = (List)$continuation.L$18;
                javaPath = (String)$continuation.L$17;
                cliHash = (String)$continuation.L$16;
                cliPath = (String)$continuation.L$15;
                jbrPathInContainer = (String)$continuation.L$14;
                cacheDir = (String)$continuation.L$13;
                homeDirectory = (String)$continuation.L$12;
                sha256 = (String)$continuation.L$11;
                url = (URI)$continuation.L$10;
                systemAndArch = (String)$continuation.L$9;
                architecture = (String)$continuation.L$8;
                os = (SupportedOs)$continuation.L$7;
                image = (ImageInspectRecord)$continuation.L$6;
                imageId = (String)$continuation.L$5;
                container = (ContainerInspectRecord)$continuation.L$4;
                agentBuild = (String)$continuation.L$3;
                agentDistribution = (DistributionInfo)$continuation.L$2;
                deploymentSettings = (DeploymentSettings)$continuation.L$1;
                containerId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v11 = $result;
lbl374:
                // 2 sources

                $this$startAgent_u24lambda_u242 = new Pair[]{TuplesKt.to((Object)"TB_JAVA_PATH", (Object)javaPath), TuplesKt.to((Object)"TB_CLI_PATH", (Object)cliPath), TuplesKt.to((Object)"TB_CLI_HASH", (Object)cliHash)};
                $continuation.L$0 = containerId;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)deploymentSettings);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)agentDistribution);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)agentBuild);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)container);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)imageId);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)image);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)os);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)architecture);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)systemAndArch);
                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)url);
                $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)sha256);
                $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)homeDirectory);
                $continuation.L$13 = SpillingKt.nullOutSpilledVariable((Object)cacheDir);
                $continuation.L$14 = SpillingKt.nullOutSpilledVariable((Object)jbrPathInContainer);
                $continuation.L$15 = SpillingKt.nullOutSpilledVariable((Object)cliPath);
                $continuation.L$16 = cliHash;
                $continuation.L$17 = SpillingKt.nullOutSpilledVariable((Object)javaPath);
                $continuation.L$18 = SpillingKt.nullOutSpilledVariable((Object)toolboxAgentCommand);
                $continuation.Z$0 = forcefulDeploy;
                $continuation.label = 10;
                v12 = this.dockerEngine.exec(containerId, toolboxAgentCommand, cacheDir, MapsKt.mapOf((Pair[])$this$startAgent_u24lambda_u242), true, (Continuation<? super Process>)$continuation);
                if (v12 == var38_7) {
                    return var38_7;
                }
                ** GOTO lbl423
            }
            case 10: {
                forcefulDeploy = $continuation.Z$0;
                toolboxAgentCommand = (List)$continuation.L$18;
                javaPath = (String)$continuation.L$17;
                cliHash = (String)$continuation.L$16;
                cliPath = (String)$continuation.L$15;
                jbrPathInContainer = (String)$continuation.L$14;
                cacheDir = (String)$continuation.L$13;
                homeDirectory = (String)$continuation.L$12;
                sha256 = (String)$continuation.L$11;
                url = (URI)$continuation.L$10;
                systemAndArch = (String)$continuation.L$9;
                architecture = (String)$continuation.L$8;
                os = (SupportedOs)$continuation.L$7;
                image = (ImageInspectRecord)$continuation.L$6;
                imageId = (String)$continuation.L$5;
                container = (ContainerInspectRecord)$continuation.L$4;
                agentBuild = (String)$continuation.L$3;
                agentDistribution = (DistributionInfo)$continuation.L$2;
                deploymentSettings = (DeploymentSettings)$continuation.L$1;
                containerId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v12 = $result;
lbl423:
                // 2 sources

                process = (Process)v12;
                v13 = containerId + " deploy reader";
                v14 = process.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"getInputStream(...)");
                stdoutFlow = new InputStreamRepeatableFlow(v13, v14);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)containerId);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)deploymentSettings);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)agentDistribution);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)agentBuild);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)container);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)imageId);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)image);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)os);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)architecture);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)systemAndArch);
                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)url);
                $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)sha256);
                $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)homeDirectory);
                $continuation.L$13 = SpillingKt.nullOutSpilledVariable((Object)cacheDir);
                $continuation.L$14 = SpillingKt.nullOutSpilledVariable((Object)jbrPathInContainer);
                $continuation.L$15 = SpillingKt.nullOutSpilledVariable((Object)cliPath);
                $continuation.L$16 = cliHash;
                $continuation.L$17 = SpillingKt.nullOutSpilledVariable((Object)javaPath);
                $continuation.L$18 = SpillingKt.nullOutSpilledVariable((Object)toolboxAgentCommand);
                $continuation.L$19 = SpillingKt.nullOutSpilledVariable((Object)process);
                $continuation.L$20 = SpillingKt.nullOutSpilledVariable((Object)stdoutFlow);
                $continuation.Z$0 = forcefulDeploy;
                $continuation.label = 11;
                v15 = FlowKt.firstOrNull(stdoutFlow.getFlow(), (Function2)((Function2)new Function2<String, Continuation<? super Boolean>, Object>(null){
                    int label;
                    /* synthetic */ Object L$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        String string = (String)this.L$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void it;
                                ResultKt.throwOnFailure((Object)$result);
                                return Boxing.boxBoolean((boolean)StringsKt.startsWith$default((String)it, (String)"~RESULT: ", (boolean)false, (int)2, null));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value2;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(String p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v15 == var38_7) {
                    return var38_7;
                }
                ** GOTO lbl480
            }
            case 11: {
                forcefulDeploy = $continuation.Z$0;
                stdoutFlow = (InputStreamRepeatableFlow)$continuation.L$20;
                process = (Process)$continuation.L$19;
                toolboxAgentCommand = (List)$continuation.L$18;
                javaPath = (String)$continuation.L$17;
                cliHash = (String)$continuation.L$16;
                cliPath = (String)$continuation.L$15;
                jbrPathInContainer = (String)$continuation.L$14;
                cacheDir = (String)$continuation.L$13;
                homeDirectory = (String)$continuation.L$12;
                sha256 = (String)$continuation.L$11;
                url = (URI)$continuation.L$10;
                systemAndArch = (String)$continuation.L$9;
                architecture = (String)$continuation.L$8;
                os = (SupportedOs)$continuation.L$7;
                image = (ImageInspectRecord)$continuation.L$6;
                imageId = (String)$continuation.L$5;
                container = (ContainerInspectRecord)$continuation.L$4;
                agentBuild = (String)$continuation.L$3;
                agentDistribution = (DistributionInfo)$continuation.L$2;
                deploymentSettings = (DeploymentSettings)$continuation.L$1;
                containerId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v15 = $result;
lbl480:
                // 2 sources

                if ((var27_50 = (Object[])v15) == null) ** GOTO lbl493
                it = var27_50;
                $i$a$-let-DockerToolboxAgentDeployer$startAgent$deployResult$2 = false;
                jsonString = StringsKt.removePrefix((String)it, (CharSequence)"~RESULT: ");
                var33_56 = (Json)Json.Default;
                string$iv = jsonString;
                $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                var28_59 = (ConnectionDetails)this_$iv.decodeFromString((DeserializationStrategy)ConnectionDetails.Companion.serializer(), string$iv);
                if (var28_59 != null) ** GOTO lbl494
lbl493:
                // 2 sources

                throw new IllegalStateException("Failed to get connection details from Docker container".toString());
lbl494:
                // 1 sources

                deployResult = var28_59;
                var29_60 = deployResult.getListenOn();
                v16 = var29_60 instanceof ListenOn.Tcp != false ? (ListenOn.Tcp)var29_60 : null;
                if (v16 == null) {
                    throw new IllegalStateException("Toolbox Agent doesn't listen on TCP port".toString());
                }
                tcpListenOn = v16;
                return new RunningAgentData(cliHash, deployResult.getAuthToken(), tcpListenOn.getPort());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object downloadAndExtractJbrToContainer(String containerId, String url, String sha256, String targetPath, Continuation<? super String> $completion) {
        if (!($completion instanceof downloadAndExtractJbrToContainer.1)) ** GOTO lbl-1000
        var10_6 = $completion;
        if ((var10_6.label & -2147483648) != 0) {
            var10_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ DockerToolboxAgentDeployer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DockerToolboxAgentDeployer.access$downloadAndExtractJbrToContainer(this.this$0, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = sha256.substring(0, 10);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"substring(...)");
                fileName = v0 + "-" + StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null);
                pathToDownload = Path.resolve$default((Path)this.downloadManager.getDownloadDirectory(), (String)fileName, (boolean)false, (int)2, null);
                Logger.INSTANCE.info("Request to download " + url + " (" + sha256 + ") to " + pathToDownload);
                $continuation.L$0 = containerId;
                $continuation.L$1 = url;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)sha256);
                $continuation.L$3 = targetPath;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                $continuation.L$5 = pathToDownload;
                $continuation.label = 1;
                v1 = DeployUtil.INSTANCE.downloadFile(this.fileSystem, this.downloadManager, url, sha256, pathToDownload, (Continuation<? super Unit>)$continuation);
                if (v1 == var11_8) {
                    return var11_8;
                }
                ** GOTO lbl37
            }
            case 1: {
                pathToDownload = (Path)$continuation.L$5;
                fileName = (String)$continuation.L$4;
                targetPath = (String)$continuation.L$3;
                sha256 = (String)$continuation.L$2;
                url = (String)$continuation.L$1;
                containerId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl37:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)containerId);
                $continuation.L$1 = url;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)sha256);
                $continuation.L$3 = targetPath;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)pathToDownload);
                $continuation.label = 2;
                v2 = CopyToContainerKt.extractTarArchiveToContainer(pathToDownload.toNioPath(), this.dockerEngine, containerId, targetPath, (Continuation<? super Unit>)$continuation);
                if (v2 == var11_8) {
                    return var11_8;
                }
                ** GOTO lbl57
            }
            case 2: {
                pathToDownload = (Path)$continuation.L$5;
                fileName = (String)$continuation.L$4;
                targetPath = (String)$continuation.L$3;
                sha256 = (String)$continuation.L$2;
                url = (String)$continuation.L$1;
                containerId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl57:
                // 2 sources

                rootEntryName = StringsKt.removeSuffix((String)StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null), (CharSequence)".tar.gz");
                return targetPath + "/" + rootEntryName;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object ensureDirectoryExistsInContainer(String containerId, String path2, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(this, containerId, path2, null){
            int label;
            final /* synthetic */ DockerToolboxAgentDeployer this$0;
            final /* synthetic */ String $containerId;
            final /* synthetic */ String $path;
            {
                this.this$0 = $receiver;
                this.$containerId = $containerId;
                this.$path = $path;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object[] objectArray = new String[]{"mkdir", "-p", this.$path};
                        this.label = 1;
                        Object object2 = DockerEngine.exec$default(DockerToolboxAgentDeployer.access$getDockerEngine$p(this.this$0), this.$containerId, CollectionsKt.listOf((Object[])objectArray), null, null, false, (Continuation)this, 28, null);
                        if (object2 != object) return Boxing.boxInt((int)((Process)object2).waitFor());
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Boxing.boxInt((int)((Process)object2).waitFor());
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ DockerEngine access$getDockerEngine$p(DockerToolboxAgentDeployer $this) {
        return $this.dockerEngine;
    }

    public static final /* synthetic */ Object access$downloadAndExtractJbrToContainer(DockerToolboxAgentDeployer $this, String containerId, String url, String sha256, String targetPath, Continuation $completion) {
        return $this.downloadAndExtractJbrToContainer(containerId, url, sha256, targetPath, (Continuation<? super String>)$completion);
    }

    public static final class Companion {
        private Companion() {
        }

        private final SupportedOs asSupportedOs(String $this$asSupportedOs) {
            SupportedOs supportedOs;
            String string = $this$asSupportedOs.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String string2 = string;
            if (Intrinsics.areEqual((Object)string2, (Object)"linux")) {
                supportedOs = SupportedOs.Linux;
            } else if (Intrinsics.areEqual((Object)string2, (Object)"darwin")) {
                supportedOs = SupportedOs.Darwin;
            } else {
                throw new IllegalStateException(("Unsupported OS: " + $this$asSupportedOs).toString());
            }
            return supportedOs;
        }

        private final String normalizeArchitecture(String architecture) {
            Locale locale = Locale.getDefault();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)locale);
            String string = architecture.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String lowercasedArch = string;
            return Intrinsics.areEqual((Object)lowercasedArch, (Object)"arm64") ? "aarch64" : lowercasedArch;
        }

        private final String getCacheDir(String home, SupportedOs os) {
            if (home == null) {
                return "/tmp";
            }
            return switch (WhenMappings.$EnumSwitchMapping$0[os.ordinal()]) {
                case 1 -> home + "/Library/Caches/JetBrains/Toolbox-CLI-dist";
                case 2 -> home + "/.cache/JetBrains/Toolbox-CLI-dist";
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public static final /* synthetic */ SupportedOs access$asSupportedOs(Companion $this, String $receiver) {
            return $this.asSupportedOs($receiver);
        }

        public static final /* synthetic */ String access$normalizeArchitecture(Companion $this, String architecture) {
            return $this.normalizeArchitecture(architecture);
        }

        public static final /* synthetic */ String access$getCacheDir(Companion $this, String home, SupportedOs os) {
            return $this.getCacheDir(home, os);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SupportedOs.values().length];
                try {
                    nArray[SupportedOs.Linux.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SupportedOs.Darwin.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    private static final class SupportedOs
    extends Enum<SupportedOs> {
        public static final /* enum */ SupportedOs Linux = new SupportedOs();
        public static final /* enum */ SupportedOs Darwin = new SupportedOs();
        private static final /* synthetic */ SupportedOs[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SupportedOs[] values() {
            return (SupportedOs[])$VALUES.clone();
        }

        static {
            $VALUES = supportedOsArray = new SupportedOs[]{SupportedOs.Linux, SupportedOs.Darwin};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

