/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.devcontainers;

import com.jetbrains.toolbox.docker.ContainerInspectRecord;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface InspectContainerResult {

    public static final class Failed
    implements InspectContainerResult {
        @NotNull
        private final String reason;

        public Failed(@NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            this.reason = reason;
        }

        @NotNull
        public String toString() {
            return "Failed(reason=" + this.reason + ")";
        }

        public int hashCode() {
            return this.reason.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Failed)) {
                return false;
            }
            Failed failed = (Failed)other;
            return Intrinsics.areEqual((Object)this.reason, (Object)failed.reason);
        }
    }

    public static final class Initial
    implements InspectContainerResult {
        @NotNull
        public static final Initial INSTANCE = new Initial();

        private Initial() {
        }

        @NotNull
        public String toString() {
            return "Initial";
        }

        public int hashCode() {
            return -2069891257;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Initial)) {
                return false;
            }
            Initial cfr_ignored_0 = (Initial)other;
            return true;
        }
    }

    public static final class Success
    implements InspectContainerResult {
        @NotNull
        private final ContainerInspectRecord content;

        public Success(@NotNull ContainerInspectRecord content2) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            this.content = content2;
        }

        @NotNull
        public final ContainerInspectRecord getContent() {
            return this.content;
        }

        @NotNull
        public String toString() {
            return "Success(content=" + this.content + ")";
        }

        public int hashCode() {
            return this.content.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Success)) {
                return false;
            }
            Success success = (Success)other;
            return Intrinsics.areEqual((Object)this.content, (Object)success.content);
        }
    }
}

