/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.devcontainers;

import com.jetbrains.toolbox.devcontainers.ConfigParseResult;
import com.jetbrains.toolbox.devcontainers.Devcontainer;
import com.jetbrains.toolbox.devcontainers.InspectContainerResult;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DevcontainerImpl
implements Devcontainer {
    @NotNull
    private final String id;
    @NotNull
    private final String presentableName;
    @NotNull
    private final StateFlow<InspectContainerResult> inspectInfo;
    @NotNull
    private final StateFlow<ConfigParseResult> config;

    public DevcontainerImpl(@NotNull String id, @NotNull String presentableName, @NotNull StateFlow<? extends InspectContainerResult> inspectInfo, @NotNull StateFlow<? extends ConfigParseResult> config) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)presentableName, (String)"presentableName");
        Intrinsics.checkNotNullParameter(inspectInfo, (String)"inspectInfo");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.id = id;
        this.presentableName = presentableName;
        this.inspectInfo = inspectInfo;
        this.config = config;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.presentableName;
    }

    @Override
    @NotNull
    public StateFlow<InspectContainerResult> getInspectInfo() {
        return this.inspectInfo;
    }

    @Override
    @NotNull
    public StateFlow<ConfigParseResult> getConfig() {
        return this.config;
    }

    @NotNull
    public String toString() {
        return "DevcontainerImpl(id=" + this.id + ", presentableName=" + this.presentableName + ", inspectInfo=" + this.inspectInfo + ", config=" + this.config + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + this.presentableName.hashCode();
        result2 = result2 * 31 + this.inspectInfo.hashCode();
        result2 = result2 * 31 + this.config.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DevcontainerImpl)) {
            return false;
        }
        DevcontainerImpl devcontainerImpl = (DevcontainerImpl)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)devcontainerImpl.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.presentableName, (Object)devcontainerImpl.presentableName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inspectInfo, devcontainerImpl.inspectInfo)) {
            return false;
        }
        return Intrinsics.areEqual(this.config, devcontainerImpl.config);
    }
}

