/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.devcontainers;

import com.jetbrains.toolbox.devcontainers.DevcontainerConfig;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface ConfigParseResult {

    public static final class Initial
    implements ConfigParseResult {
        @NotNull
        public static final Initial INSTANCE = new Initial();

        private Initial() {
        }

        @NotNull
        public String toString() {
            return "Initial";
        }

        public int hashCode() {
            return 521484829;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Initial)) {
                return false;
            }
            Initial cfr_ignored_0 = (Initial)other;
            return true;
        }
    }

    public static final class InspectionFailed
    implements ConfigParseResult {
        @NotNull
        public static final InspectionFailed INSTANCE = new InspectionFailed();

        private InspectionFailed() {
        }

        @NotNull
        public String toString() {
            return "InspectionFailed";
        }

        public int hashCode() {
            return 822536216;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InspectionFailed)) {
                return false;
            }
            InspectionFailed cfr_ignored_0 = (InspectionFailed)other;
            return true;
        }
    }

    public static final class InvalidConfiguration
    implements ConfigParseResult {
        @NotNull
        private final String message;

        public InvalidConfiguration(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.message = message2;
        }

        @NotNull
        public String toString() {
            return "InvalidConfiguration(message=" + this.message + ")";
        }

        public int hashCode() {
            return this.message.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InvalidConfiguration)) {
                return false;
            }
            InvalidConfiguration invalidConfiguration = (InvalidConfiguration)other;
            return Intrinsics.areEqual((Object)this.message, (Object)invalidConfiguration.message);
        }
    }

    public static final class ParsingError
    implements ConfigParseResult {
        @NotNull
        private final String message;

        public ParsingError(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.message = message2;
        }

        @NotNull
        public String toString() {
            return "ParsingError(message=" + this.message + ")";
        }

        public int hashCode() {
            return this.message.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsingError)) {
                return false;
            }
            ParsingError parsingError = (ParsingError)other;
            return Intrinsics.areEqual((Object)this.message, (Object)parsingError.message);
        }
    }

    public static final class Success
    implements ConfigParseResult {
        @NotNull
        private final DevcontainerConfig content;

        public Success(@NotNull DevcontainerConfig content2) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            this.content = content2;
        }

        @NotNull
        public final DevcontainerConfig getContent() {
            return this.content;
        }

        @NotNull
        public String toString() {
            return "Success(content=" + this.content + ")";
        }

        public int hashCode() {
            return this.content.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Success)) {
                return false;
            }
            Success success = (Success)other;
            return Intrinsics.areEqual((Object)this.content, (Object)success.content);
        }
    }
}

