/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.desktop.os;

import com.jetbrains.JBR;
import com.jetbrains.WindowDecorations;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.desktop.os.LinuxUtil;
import com.jetbrains.toolbox.desktop.os.MacUtil;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class OsSpecificUtilsKt {
    public static final boolean isCustomDecorationsSupported() {
        return !OS.INSTANCE.isLinux() && JBR.isWindowDecorationsSupported();
    }

    public static final void allowActivation(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (OS.INSTANCE.isMac()) {
            MacUtil.INSTANCE.activateApp();
        }
        if (OS.INSTANCE.isLinux()) {
            LinuxUtil.INSTANCE.activateApp(window);
        }
    }

    public static final void setRoundedCorners(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (!JBR.isRoundedCornersManagerSupported()) {
            return;
        }
        String params2 = OS.INSTANCE.isWindows() ? "full" : (OS.INSTANCE.isMac() ? Float.valueOf(10.0f) : "");
        JBR.getRoundedCornersManager().setRoundedCorners(window, (Object)params2);
    }

    public static final void setCustomDecorations(@NotNull Window window, @NotNull WindowDecorations.CustomTitleBar titleBar) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)titleBar, (String)"titleBar");
        WindowDecorations decorations = JBR.getWindowDecorations();
        Window window2 = window;
        if (window2 instanceof Dialog) {
            decorations.setCustomTitleBar((Dialog)window, titleBar);
        } else if (window2 instanceof Frame) {
            decorations.setCustomTitleBar((Frame)window, titleBar);
        }
    }
}

