/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.desktop.os;

import com.jetbrains.toolbox.interop.NativeInteropLinux;
import com.sun.jna.Pointer;
import java.awt.Window;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;
import sun.awt.AWTAccessor;

public final class LinuxUtil {
    @NotNull
    public static final LinuxUtil INSTANCE = new LinuxUtil();

    private LinuxUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activateApp(@NotNull Window awtWindow) {
        Intrinsics.checkNotNullParameter((Object)awtWindow, (String)"awtWindow");
        try {
            long x11ComponentPeerClass22;
            AWTAccessor.ComponentAccessor componentAccessor = AWTAccessor.getComponentAccessor();
            if (componentAccessor == null) {
                Logger.INSTANCE.error("Could not get component accessor");
                return;
            }
            Object peer = componentAccessor.getPeer(awtWindow);
            if (peer == null) {
                Logger.INSTANCE.error("Could not get component peer");
                return;
            }
            try {
                Class<?> x11ComponentPeerClass22 = Class.forName("sun.awt.X11ComponentPeer");
                if (!x11ComponentPeerClass22.isInstance(peer)) {
                    Logger.INSTANCE.error("Component peer is not an instance of X11ComponentPeer");
                    return;
                }
                Object object = x11ComponentPeerClass22.getDeclaredMethod("getWindow", new Class[0]).invoke(peer, new Object[0]);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                x11ComponentPeerClass22 = (Long)object;
            }
            catch (Exception e) {
                Logger.INSTANCE.error((Throwable)e, "Failed to access X11 window ID using reflection");
                return;
            }
            long xWindow = x11ComponentPeerClass22;
            NativeInteropLinux linuxInterop = NativeInteropLinux.INSTANCE;
            Pointer display = linuxInterop.getDisplay();
            try {
                linuxInterop.setWindowProperties(display, xWindow);
                linuxInterop.bringWindowToFront(display, xWindow);
            }
            finally {
                linuxInterop.closeDisplay(display);
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e);
        }
    }
}

