/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.desktop;

import com.jetbrains.JBRFileDialog;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.interop.NativeInteropWin32;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.WinDef;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.UIManager;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class NativeFolderSelector {
    @NotNull
    private final Window parentWindow;
    private final long windowHandle;

    public NativeFolderSelector(@NotNull Window parentWindow, long windowHandle) {
        Intrinsics.checkNotNullParameter((Object)parentWindow, (String)"parentWindow");
        this.parentWindow = parentWindow;
        this.windowHandle = windowHandle;
    }

    @NotNull
    public final String chooseDirectory(@NotNull String initialSelection) {
        Intrinsics.checkNotNullParameter((Object)initialSelection, (String)"initialSelection");
        switch (WhenMappings.$EnumSwitchMapping$0[OS.INSTANCE.getType().ordinal()]) {
            case 1: {
                JFileChooser jFileChooser;
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Throwable ex) {
                    Logger.INSTANCE.debug(ex);
                }
                JFileChooser $this$chooseDirectory_u24lambda_u240 = jFileChooser = new JFileChooser();
                boolean bl = false;
                $this$chooseDirectory_u24lambda_u240.setFileSelectionMode(1);
                $this$chooseDirectory_u24lambda_u240.setCurrentDirectory(new File(initialSelection));
                JFileChooser fileChooser = jFileChooser;
                if (fileChooser.showOpenDialog(this.parentWindow) != 0) break;
                String string = fileChooser.getSelectedFile().getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                return string;
            }
            case 2: {
                WinDef.HWND hwnd = new WinDef.HWND(Pointer.createConstant((long)this.windowHandle));
                String string = NativeInteropWin32.INSTANCE.selectFolder(hwnd, new WString(initialSelection)).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            case 3: {
                FileDialog fileDialog;
                Object object = this.parentWindow;
                if (object instanceof JFrame) {
                    fileDialog = new FileDialog((Frame)this.parentWindow);
                } else if (object instanceof JDialog) {
                    fileDialog = new FileDialog((Dialog)this.parentWindow);
                } else {
                    throw new IllegalStateException(("unknown window type " + Reflection.getOrCreateKotlinClass(this.parentWindow.getClass()).getQualifiedName()).toString());
                }
                FileDialog fileDialog2 = fileDialog;
                object = fileDialog2;
                Window $this$chooseDirectory_u24lambda_u242 = object;
                boolean bl = false;
                ((FileDialog)$this$chooseDirectory_u24lambda_u242).setFile(initialSelection);
                JBRFileDialog jBRFileDialog = JBRFileDialog.get((FileDialog)$this$chooseDirectory_u24lambda_u242);
                if (jBRFileDialog != null) {
                    JBRFileDialog it = jBRFileDialog;
                    boolean bl2 = false;
                    it.setHints(it.getHints() | 2);
                }
                ((Dialog)$this$chooseDirectory_u24lambda_u242).setVisible(true);
                object = fileDialog2.getFile();
                if (object == null) break;
                Object it = object;
                boolean bl3 = false;
                File selectedFile = new File(fileDialog2.getDirectory(), fileDialog2.getFile());
                if (!selectedFile.isDirectory()) {
                    String string = selectedFile.getParentFile().getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                    return string;
                }
                String string = selectedFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                return string;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return initialSelection;
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Windows.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Mac.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

