/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.security;

import com.jetbrains.toolbox.common.extensions.ByteArrayExtensionsKt;
import com.jetbrains.toolbox.common.security.CloningMessageDigest;
import java.io.Closeable;
import java.security.MessageDigest;
import java.util.Base64;
import kotlin.ExceptionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nsha.kt\nKotlin\n*S Kotlin\n*F\n+ 1 sha.kt\ncom/jetbrains/toolbox/common/security/ShaKt\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 FileSystem.kt\nokio/FileSystem\n*L\n1#1,40:1\n66#2:41\n52#2,4:43\n60#2,10:48\n56#2,3:58\n71#2,3:61\n67#3:42\n68#3:47\n*S KotlinDebug\n*F\n+ 1 sha.kt\ncom/jetbrains/toolbox/common/security/ShaKt\n*L\n22#1:41\n22#1:43,4\n22#1:48,10\n22#1:58,3\n22#1:61,3\n22#1:42\n22#1:47\n*E\n"})
public final class ShaKt {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final CloningMessageDigest SHA256$delegate;
    @NotNull
    private static final CloningMessageDigest SHA512$delegate;

    @NotNull
    public static final MessageDigest getSHA256() {
        return SHA256$delegate.getValue(null, $$delegatedProperties[0]);
    }

    @NotNull
    public static final MessageDigest getSHA512() {
        return SHA512$delegate.getValue(null, $$delegatedProperties[1]);
    }

    @NotNull
    public static final byte[] sha256(@NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        byte[] byArray = ShaKt.getSHA256().digest(data2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    @NotNull
    public static final byte[] sha256(@NotNull FileSystem $this$sha256, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ShaKt.computeDigest(ShaKt.getSHA256(), $this$sha256, file);
    }

    @NotNull
    public static final byte[] sha512(@NotNull FileSystem $this$sha512, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)$this$sha512, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ShaKt.computeDigest(ShaKt.getSHA512(), $this$sha512, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static final byte[] computeDigest(@NotNull MessageDigest $this$computeDigest, @NotNull FileSystem fileSystem, @NotNull Path file) {
        Unit unit;
        Throwable thrown$iv$iv;
        MessageDigest digest;
        block16: {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)$this$computeDigest, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            byte[] buffer = new byte[0x100000];
            digest = $this$computeDigest;
            FileSystem fileSystem2 = fileSystem;
            Path file$iv = file;
            boolean bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                int bytesRead;
                BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSource $this$computeDigest_u24lambda_u240 = it$iv;
                boolean bl3 = false;
                while ((bytesRead = $this$computeDigest_u24lambda_u240.read(buffer)) > 0) {
                    digest.update(buffer, 0, bytesRead);
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    unit = null;
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block17: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv2;
                                break block17;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        Unit result$iv$iv = unit;
        Throwable throwable = thrown$iv$iv;
        if (throwable != null) {
            throw throwable;
        }
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    @NotNull
    public static final String sha256base64(@NotNull String $this$sha256base64) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256base64, (String)"<this>");
        String string = $this$sha256base64;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] hash = ShaKt.sha256(byArray);
        String string2 = Base64.getUrlEncoder().encodeToString(hash);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }

    @NotNull
    public static final String fingerprint(@NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        return ByteArrayExtensionsKt.toHex(bytes2, " ", true);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(ShaKt.class, "SHA256", "getSHA256()Ljava/security/MessageDigest;", 1))), Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(ShaKt.class, "SHA512", "getSHA512()Ljava/security/MessageDigest;", 1)))};
        $$delegatedProperties = kPropertyArray;
        SHA256$delegate = new CloningMessageDigest("SHA-256");
        SHA512$delegate = new CloningMessageDigest("SHA-512");
    }
}

