/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.logging;

import com.jetbrains.toolbox.common.extensions.StringExtensionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.Level;
import org.tinylog.Logger;
import org.tinylog.format.MessageFormatter;
import org.tinylog.provider.ProviderRegistry;

@SourceDebugExtension(value={"SMAP\nStructuredLogging.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructuredLogging.kt\ncom/jetbrains/toolbox/common/logging/StructuredLogging\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class StructuredLogging {
    @NotNull
    public static final StructuredLogging INSTANCE = new StructuredLogging();

    private StructuredLogging() {
    }

    public final boolean tryLogFromStructuredLoggingOutput(@NotNull String line, @NotNull String environmentId) {
        IllegalStateException illegalStateException;
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)environmentId, (String)"environmentId");
        String trim = ((Object)StringsKt.trim((CharSequence)line)).toString();
        if (!StringsKt.startsWith$default((String)trim, (String)"{", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)trim, (String)"}", (boolean)false, (int)2, null)) {
            return false;
        }
        try {
            jsonElement = Json.Default.parseToJsonElement(line);
        }
        catch (SerializationException e) {
            String string = "Unable to parse line as JSON structured logging: " + line;
            Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.Any");
            Logger.warn((Object)string);
            return false;
        }
        JsonElement jsonElement2 = jsonElement;
        JsonObject jsonObject = jsonElement2 instanceof JsonObject ? (JsonObject)jsonElement2 : null;
        if (jsonObject == null) {
            return false;
        }
        JsonObject element = jsonObject;
        Object object = (JsonElement)element.get((Object)"level");
        if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = JsonElementKt.getContentOrNull((JsonPrimitive)object)) == null) {
            return false;
        }
        Object level = object;
        Object object2 = (JsonElement)element.get((Object)"message");
        if (object2 == null || (object2 = JsonElementKt.getJsonPrimitive((JsonElement)object2)) == null || (object2 = JsonElementKt.getContentOrNull((JsonPrimitive)object2)) == null) {
            return false;
        }
        Object message2 = object2;
        Object object3 = (JsonElement)element.get((Object)"class");
        if (object3 == null || (object3 = JsonElementKt.getJsonPrimitive((JsonElement)object3)) == null || (object3 = JsonElementKt.getContentOrNull((JsonPrimitive)object3)) == null) {
            return false;
        }
        Object className = object3;
        Object object4 = (JsonElement)element.get((Object)"tag");
        String tag = object4 != null && (object4 = JsonElementKt.getJsonPrimitive((JsonElement)object4)) != null && (object4 = JsonElementKt.getContentOrNull((JsonPrimitive)object4)) != null ? StringExtensionsKt.getNullIfBlank((String)object4) : null;
        Object object5 = (JsonElement)element.get((Object)"exception");
        String exception = object5 != null && (object5 = JsonElementKt.getJsonPrimitive((JsonElement)object5)) != null && (object5 = JsonElementKt.getContentOrNull((JsonPrimitive)object5)) != null ? StringExtensionsKt.getNullIfBlank((String)object5) : null;
        Level tinyLogLevel = switch (level) {
            case "TRACE" -> Level.TRACE;
            case "DEBUG" -> Level.DEBUG;
            case "INFO" -> Level.INFO;
            case "WARN" -> Level.WARN;
            case "ERROR" -> Level.ERROR;
            default -> {
                String v8 = "Unable to convert remote log level: " + (String)level;
                Intrinsics.checkNotNull((Object)v8, (String)"null cannot be cast to non-null type kotlin.Any");
                Logger.warn((Object)v8);
                yield Level.ERROR;
            }
        };
        String string = exception;
        if (string != null) {
            String it = string;
            boolean bl = false;
            illegalStateException = new IllegalStateException(it);
        } else {
            illegalStateException = null;
        }
        IllegalStateException exceptionObject = illegalStateException;
        String fullMessage = this.getLogMessagePrefix(environmentId, (String)className) + (String)message2;
        ProviderRegistry.getLoggingProvider().log(this.getClass().getName(), tag, tinyLogLevel, (Throwable)exceptionObject, (MessageFormatter)DummyMessageFormatter.INSTANCE, (Object)fullMessage, new Object[0]);
        return true;
    }

    @NotNull
    public final String getLogMessagePrefix(@NotNull String environmentId, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)environmentId, (String)"environmentId");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return environmentId + " " + StringsKt.substringAfterLast$default((String)className, (String)".", null, (int)2, null) + " REMOTE-LOG: ";
    }

    public static final class DummyMessageFormatter
    implements MessageFormatter {
        @NotNull
        public static final DummyMessageFormatter INSTANCE = new DummyMessageFormatter();

        private DummyMessageFormatter() {
        }

        @NotNull
        public String format(@NotNull String message2, @Nullable Object[] arguments) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            return message2;
        }
    }
}

