/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.io;

import com.jetbrains.toolbox.common.formatting.HumanMemorySizeKt;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.common.io.File_infoKt;
import com.jetbrains.toolbox.common.platform.OS;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class File_infoKt {
    @NotNull
    private static final Lazy fileMetadata$delegate = LazyKt.lazy(File_infoKt::fileMetadata_delegate$lambda$0);

    private static final KFunction<String> getFileMetadata() {
        Lazy lazy = fileMetadata$delegate;
        return (KFunction)lazy.getValue();
    }

    private static final String posixFileMetadata(java.nio.file.Path path2) {
        try {
            PosixFileAttributes posixAttributes = Files.getFileAttributeView(path2, PosixFileAttributeView.class, new LinkOption[0]).readAttributes();
            String permissions = PosixFilePermissions.toString(posixAttributes.permissions());
            String owner2 = posixAttributes.owner().getName();
            String group = posixAttributes.group().getName();
            return permissions + " o=" + owner2 + " g=" + group;
        }
        catch (Exception e) {
            Logger.INSTANCE.warn((Throwable)e, "Unable to get POSIX metadata for " + path2);
            return null;
        }
    }

    private static final String aclFileMetadata(java.nio.file.Path path2) {
        try {
            AclFileAttributeView aclFileAttributeView = Files.getFileAttributeView(path2, AclFileAttributeView.class, new LinkOption[0]);
            if (aclFileAttributeView == null) {
                return null;
            }
            AclFileAttributeView aclView = aclFileAttributeView;
            return "o=" + aclView.getOwner();
        }
        catch (Exception e) {
            Logger.INSTANCE.warn((Throwable)e, "Unable to get ACL metadata for " + path2);
            return null;
        }
    }

    @NotNull
    public static final String info(@NotNull FileSystem $this$info, @NotNull Path path2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$info, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        FileMetadata fileMetadata2 = $this$info.metadataOrNull(path2);
        if (fileMetadata2 == null) {
            return path2 + ": does not exist";
        }
        FileMetadata metadata = fileMetadata2;
        if (metadata.isDirectory()) {
            string = "<dir>";
        } else {
            Long l = metadata.getSize();
            string = HumanMemorySizeKt.humanFileSize$default(l != null ? l : 0L, 0, 2, null);
        }
        String size = string;
        String additionalData = FileSystemExtKt.isSystem($this$info) ? (String)((Function1)File_infoKt.getFileMetadata()).invoke((Object)path2.toNioPath()) : null;
        Object[] objectArray = new Comparable[]{additionalData, size, path2};
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private static final KFunction fileMetadata_delegate$lambda$0() {
        return OS.INSTANCE.isWindows() ? (KFunction)fileMetadata.2.1.INSTANCE : (KFunction)fileMetadata.2.2.INSTANCE;
    }

    public static final /* synthetic */ String access$aclFileMetadata(java.nio.file.Path path2) {
        return File_infoKt.aclFileMetadata(path2);
    }

    public static final /* synthetic */ String access$posixFileMetadata(java.nio.file.Path path2) {
        return File_infoKt.posixFileMetadata(path2);
    }
}

