/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.common.io;

import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.SharedFlow;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FileSystemWatcher {
    @NotNull
    public SharedFlow<Event> getEvents();

    public void watch(Path ... var1);

    public void stopWatching(Path ... var1);

    public static final class Event {
        @NotNull
        private final EventType type;
        @NotNull
        private final Path file;

        public Event(@NotNull EventType type2, @NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.type = type2;
            this.file = file;
        }

        @NotNull
        public final EventType getType() {
            return this.type;
        }

        @NotNull
        public final Path getFile() {
            return this.file;
        }

        @NotNull
        public String toString() {
            return "Event(type=" + this.type + ", file=" + this.file + ")";
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + this.file.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Event)) {
                return false;
            }
            Event event = (Event)other;
            if (this.type != event.type) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)event.file);
        }
    }

    public static final class EventType
    extends Enum<EventType> {
        public static final /* enum */ EventType CREATE = new EventType();
        public static final /* enum */ EventType DELETE = new EventType();
        public static final /* enum */ EventType CHANGE = new EventType();
        public static final /* enum */ EventType DIRTY = new EventType();
        private static final /* synthetic */ EventType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        static {
            $VALUES = eventTypeArray = new EventType[]{EventType.CREATE, EventType.DELETE, EventType.CHANGE, EventType.DIRTY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

