/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ai.chat.ui.widgets;

import com.jetbrains.toolbox.ai.chat.entities.ChatStorageEntity;
import com.jetbrains.toolbox.ai.chat.message.ChatMessage;
import com.jetbrains.toolbox.ai.chat.message.FunctionResponseEvent;
import com.jetbrains.toolbox.ai.chat.ui.widgets.FunctionCallInfo;
import com.jetbrains.toolbox.ai.chat.ui.widgets.InteractiveRequestRendererKt;
import com.jetbrains.toolbox.ai.chat.ui.widgets.MessageRosterWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nMessageRosterWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageRosterWidget.kt\ncom/jetbrains/toolbox/ai/chat/ui/widgets/MessageRosterWidgetKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1869#2:117\n1870#2:119\n1573#2:120\n1604#2,4:121\n739#2,9:125\n1#3:118\n*S KotlinDebug\n*F\n+ 1 MessageRosterWidget.kt\ncom/jetbrains/toolbox/ai/chat/ui/widgets/MessageRosterWidgetKt\n*L\n56#1:117\n56#1:119\n106#1:120\n106#1:121,4\n110#1:125,9\n*E\n"})
public final class MessageRosterWidgetKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<MessageRosterWidget, Boolean>> toRosterWidgets(@NotNull ChatStorageEntity $this$toRosterWidgets) {
        void $this$mapIndexedTo$iv$iv;
        Object object;
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$toRosterWidgets, (String)"<this>");
        List $this$toRosterWidgets_u24lambda_u244 = list2 = CollectionsKt.createListBuilder();
        boolean $i$a$-buildList-MessageRosterWidgetKt$toRosterWidgets$widgetsList$22 = false;
        Iterable $this$forEach$iv = $this$toRosterWidgets.getMessages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessageRosterWidget.FunctionCallWidget functionWidget;
            ChatMessage message2;
            block14: {
                MessageRosterWidget.FunctionCallWidget functionCallWidget;
                block16: {
                    block15: {
                        MessageRosterWidget.FunctionCallWidget functionCallWidget2;
                        message2 = (ChatMessage)element$iv;
                        boolean bl = false;
                        object = message2;
                        if (object instanceof ChatMessage.User) {
                            $this$toRosterWidgets_u24lambda_u244.add(new MessageRosterWidget.UserWidget(((ChatMessage.User)message2).getText()));
                            continue;
                        }
                        if (object instanceof ChatMessage.System) {
                            $this$toRosterWidgets_u24lambda_u244.add(new MessageRosterWidget.SystemWidget(((ChatMessage.System)message2).getText()));
                            continue;
                        }
                        if (object instanceof ChatMessage.AssistantInProgress) {
                            $this$toRosterWidgets_u24lambda_u244.add(new MessageRosterWidget.AssistantInProgressWidget(((ChatMessage.AssistantInProgress)message2).getText(), ((ChatMessage.AssistantInProgress)message2).getGenerationSpeed()));
                            continue;
                        }
                        if (object instanceof ChatMessage.AssistantCompleted) {
                            $this$toRosterWidgets_u24lambda_u244.add(new MessageRosterWidget.AssistantCompletedWidget(((ChatMessage.AssistantCompleted)message2).getText()));
                            continue;
                        }
                        if (!(object instanceof ChatMessage.FunctionCall)) break block14;
                        functionCallWidget = MessageRosterWidgetKt.findLastFunctionWidget($this$toRosterWidgets_u24lambda_u244);
                        if (functionCallWidget == null) break block15;
                        MessageRosterWidget.FunctionCallWidget it = functionCallWidget2 = functionCallWidget;
                        boolean bl2 = false;
                        $this$toRosterWidgets_u24lambda_u244.remove(it);
                        functionCallWidget = functionCallWidget2;
                        if (functionCallWidget != null) break block16;
                    }
                    functionCallWidget = new MessageRosterWidget.FunctionCallWidget(MapsKt.emptyMap());
                }
                functionWidget = functionCallWidget;
                Map newCalls = MapsKt.plus(functionWidget.getCallsInfo(), (Pair)TuplesKt.to((Object)((ChatMessage.FunctionCall)message2).getFunctionId(), (Object)MessageRosterWidgetKt.toCallInfo((ChatMessage.FunctionCall)message2)));
                $this$toRosterWidgets_u24lambda_u244.add(functionWidget.copy(newCalls));
                continue;
            }
            if (object instanceof ChatMessage.FunctionResponse) {
                FunctionCallInfo callInfo;
                FunctionResponseEvent it;
                functionWidget = MessageRosterWidgetKt.findLastFunctionWidget($this$toRosterWidgets_u24lambda_u244);
                if (functionWidget != null) {
                    boolean bl = false;
                    v1 = ((MessageRosterWidget.FunctionCallWidget)((Object)it)).getCallsInfo().get(((ChatMessage.FunctionResponse)message2).getFunctionId());
                } else {
                    v1 = callInfo = null;
                }
                if (callInfo == null) {
                    Logger.INSTANCE.error(MessageRosterWidgetKt::toRosterWidgets$lambda$4$lambda$3$lambda$2);
                    continue;
                }
                it = ((ChatMessage.FunctionResponse)message2).getLastResponse();
                boolean bl = ((ChatMessage.FunctionResponse)message2).getCompleted();
                FunctionCallInfo updatedCallInfo = FunctionCallInfo.copy$default(callInfo, null, null, bl, it, 3, null);
                Map newCalls = MapsKt.plus((Map)MapsKt.minus(functionWidget.getCallsInfo(), (Object)((ChatMessage.FunctionResponse)message2).getFunctionId()), (Pair)TuplesKt.to((Object)((ChatMessage.FunctionResponse)message2).getFunctionId(), (Object)updatedCallInfo));
                int index = $this$toRosterWidgets_u24lambda_u244.indexOf(functionWidget);
                $this$toRosterWidgets_u24lambda_u244.remove(functionWidget);
                $this$toRosterWidgets_u24lambda_u244.add(index, functionWidget.copy(newCalls));
                continue;
            }
            if (!(object instanceof ChatMessage.FunctionInteractiveRequest)) continue;
            $this$toRosterWidgets_u24lambda_u244.add(new MessageRosterWidget.InteractiveRequestWidget(InteractiveRequestRendererKt.renderToCompose((ChatMessage.FunctionInteractiveRequest)message2, $this$toRosterWidgets)));
        }
        List widgetsList = CollectionsKt.build((List)list2);
        Iterable $this$mapIndexed$iv = widgetsList;
        boolean $i$f$mapIndexed = false;
        Iterable $i$a$-buildList-MessageRosterWidgetKt$toRosterWidgets$widgetsList$22 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void widget;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object = (MessageRosterWidget)item$iv$iv;
            int newCalls = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)widget, (Object)(index == CollectionsKt.getLastIndex((List)widgetsList) ? 1 : 0)));
        }
        return (List)destination$iv$iv;
    }

    private static final MessageRosterWidget.FunctionCallWidget findLastFunctionWidget(List<MessageRosterWidget> $this$findLastFunctionWidget) {
        MessageRosterWidget messageRosterWidget;
        List list2;
        List<MessageRosterWidget> $this$dropLastWhile$iv = $this$findLastFunctionWidget;
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator<MessageRosterWidget> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                MessageRosterWidget it = iterator$iv.previous();
                boolean bl = false;
                if (it instanceof MessageRosterWidget.InteractiveRequestWidget) continue;
                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        MessageRosterWidget messageRosterWidget2 = (MessageRosterWidget)CollectionsKt.lastOrNull((List)list2);
        if (messageRosterWidget2 != null) {
            MessageRosterWidget messageRosterWidget3;
            MessageRosterWidget it = messageRosterWidget3 = messageRosterWidget2;
            boolean bl = false;
            messageRosterWidget = it instanceof MessageRosterWidget.FunctionCallWidget ? messageRosterWidget3 : null;
        } else {
            messageRosterWidget = null;
        }
        MessageRosterWidget messageRosterWidget4 = messageRosterWidget;
        return messageRosterWidget4 instanceof MessageRosterWidget.FunctionCallWidget ? (MessageRosterWidget.FunctionCallWidget)messageRosterWidget4 : null;
    }

    private static final FunctionCallInfo toCallInfo(ChatMessage.FunctionCall $this$toCallInfo) {
        return new FunctionCallInfo($this$toCallInfo.getInfo().getName(), $this$toCallInfo.getInfo().getGroup(), false, FunctionResponseEvent.EmptyResponse.INSTANCE);
    }

    private static final String toRosterWidgets$lambda$4$lambda$3$lambda$2() {
        return "Function response cannot be bound to function call. Skipped";
    }
}

