/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ai.chat.model;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface LlmResponse {

    public static final class FunctionCall
    implements LlmResponse {
        @NotNull
        private final String text;
        @Nullable
        private final String name;

        public FunctionCall(@NotNull String text2, @Nullable String name2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
            this.name = name2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @NotNull
        public String toString() {
            return "FunctionCall(text=" + this.text + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + (this.name == null ? 0 : this.name.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FunctionCall)) {
                return false;
            }
            FunctionCall functionCall = (FunctionCall)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)functionCall.text)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)functionCall.name);
        }
    }

    public static final class Message
    implements LlmResponse {
        @NotNull
        private final String text;

        public Message(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public String toString() {
            return "Message(text=" + this.text + ")";
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Message)) {
                return false;
            }
            Message message2 = (Message)other;
            return Intrinsics.areEqual((Object)this.text, (Object)message2.text);
        }
    }
}

