/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ai.chat.llm;

import com.jetbrains.toolbox.ai.chat.llm.LLMPointer$;
import com.jetbrains.toolbox.ai.chat.llm.LLMProvider;
import com.jetbrains.toolbox.ai.chat.llm.LLMProvider$;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
public final class LLMPointer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final LLMProvider provider;
    @NotNull
    private final String display;
    @NotNull
    private final String profile;
    @NotNull
    private final String fqDisplay;
    @NotNull
    private static final LLMPointer GPT_4O = new LLMPointer("gpt-4o", LLMProvider.Companion.getOpenAI(), "GPT-4o", "openai-gpt-4o", null, 16, null);
    @NotNull
    private static final LLMPointer GPT_4O_MINI = new LLMPointer("gpt-4o-mini", LLMProvider.Companion.getOpenAI(), "GPT-4o Mini", "openai-gpt-4o-mini", null, 16, null);
    @NotNull
    private static final LLMPointer CLAUDE_3_5_SONNET = new LLMPointer("anthropic-claude-3.5-sonnet", LLMProvider.Companion.getAnthropic(), "Claude 3.5 Sonnet", "anthropic-claude-3.5-sonnet", null, 16, null);
    @NotNull
    private static final LLMPointer CLAUDE_3_5_HAIKU = new LLMPointer("anthropic-claude-3.5-haiku", LLMProvider.Companion.getAnthropic(), "Claude 3.5 Haiku", "anthropic-claude-3.5-haiku", null, 16, null);
    @NotNull
    private static final LLMPointer GEMINI_PRO_1_5 = new LLMPointer("gemini-pro-1-5", LLMProvider.Companion.getGoogle(), "Gemini 1.5 Pro", "google-chat-gemini-pro-1.5", null, 16, null);
    @NotNull
    private static final LLMPointer GEMINI_FLASH_1_5 = new LLMPointer("gemini-flash-1-5", LLMProvider.Companion.getGoogle(), "Gemini Flash 1.5", "google-chat-gemini-flash-1.5", null, 16, null);
    @NotNull
    private static final List<LLMPointer> AVAILABLE;

    public LLMPointer(@NotNull String id, @NotNull LLMProvider provider2, @NotNull String display, @NotNull String profile, @NotNull String fqDisplay) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)fqDisplay, (String)"fqDisplay");
        this.id = id;
        this.provider = provider2;
        this.display = display;
        this.profile = profile;
        this.fqDisplay = fqDisplay;
    }

    public /* synthetic */ LLMPointer(String string, LLMProvider lLMProvider, String string2, String string3, String object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            object = lLMProvider.getDisplay() + " " + string2;
        }
        this(string, lLMProvider, string2, string3, (String)object);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final LLMProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final String getDisplay() {
        return this.display;
    }

    @NotNull
    public final String getProfile() {
        return this.profile;
    }

    @NotNull
    public String toString() {
        return "LLMPointer(id=" + this.id + ", provider=" + this.provider + ", display=" + this.display + ", profile=" + this.profile + ", fqDisplay=" + this.fqDisplay + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + this.provider.hashCode();
        result2 = result2 * 31 + this.display.hashCode();
        result2 = result2 * 31 + this.profile.hashCode();
        result2 = result2 * 31 + this.fqDisplay.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LLMPointer)) {
            return false;
        }
        LLMPointer lLMPointer = (LLMPointer)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)lLMPointer.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.provider, (Object)lLMPointer.provider)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.display, (Object)lLMPointer.display)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.profile, (Object)lLMPointer.profile)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fqDisplay, (Object)lLMPointer.fqDisplay);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$ai_chat_common(LLMPointer self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        output2.encodeStringElement(serialDesc, 0, self.id);
        output2.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)LLMProvider$.serializer.INSTANCE, (Object)self.provider);
        output2.encodeStringElement(serialDesc, 2, self.display);
        output2.encodeStringElement(serialDesc, 3, self.profile);
        if (output2.shouldEncodeElementDefault(serialDesc, 4) ? true : !Intrinsics.areEqual((Object)self.fqDisplay, (Object)(self.provider.getDisplay() + " " + self.display))) {
            output2.encodeStringElement(serialDesc, 4, self.fqDisplay);
        }
    }

    public /* synthetic */ LLMPointer(int seen0, String id, LLMProvider provider2, String display, String profile, String fqDisplay, SerializationConstructorMarker serializationConstructorMarker) {
        if (15 != (0xF & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)15, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.id = id;
        this.provider = provider2;
        this.display = display;
        this.profile = profile;
        this.fqDisplay = (seen0 & 0x10) == 0 ? this.provider.getDisplay() + " " + this.display : fqDisplay;
    }

    static {
        Object[] objectArray = new LLMPointer[]{GPT_4O, GPT_4O_MINI, CLAUDE_3_5_SONNET, CLAUDE_3_5_HAIKU, GEMINI_PRO_1_5, GEMINI_FLASH_1_5};
        AVAILABLE = CollectionsKt.listOf((Object[])objectArray);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLMPointer getGPT_4O() {
            return GPT_4O;
        }

        @NotNull
        public final List<LLMPointer> getAVAILABLE() {
            return AVAILABLE;
        }

        @NotNull
        public final KSerializer<LLMPointer> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @SourceDebugExtension(value={"SMAP\nLLMPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMPointer.kt\ncom/jetbrains/toolbox/ai/chat/llm/LLMPointer$LegacySerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n295#2,2:93\n*S KotlinDebug\n*F\n+ 1 LLMPointer.kt\ncom/jetbrains/toolbox/ai/chat/llm/LLMPointer$LegacySerializer\n*L\n33#1:93,2\n*E\n"})
    public static final class LegacySerializer
    implements KSerializer<LLMPointer> {
        @NotNull
        public static final LegacySerializer INSTANCE = new LegacySerializer();
        @NotNull
        private static final SerialDescriptor descriptor = BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE).getDescriptor();

        private LegacySerializer() {
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return descriptor;
        }

        @NotNull
        public LLMPointer deserialize(@NotNull Decoder decoder) {
            Object v0;
            String value2;
            block2: {
                Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
                value2 = decoder.decodeString();
                Iterable $this$firstOrNull$iv = Companion.getAVAILABLE();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    LLMPointer it = (LLMPointer)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)value2)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            LLMPointer lLMPointer = v0;
            if (lLMPointer == null) {
                throw new IllegalStateException(("Unknown LLM type: " + value2).toString());
            }
            return lLMPointer;
        }

        public void serialize(@NotNull Encoder encoder, @NotNull LLMPointer value2) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            encoder.encodeString(value2.getId());
        }
    }
}

