/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ai.chat.entities;

import com.jetbrains.rhizomedb.Attributes;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.ChangeScopeKt;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import com.jetbrains.rhizomedb.EntityBuilder;
import com.jetbrains.rhizomedb.Indexing;
import com.jetbrains.rhizomedb.Mixin;
import com.jetbrains.toolbox.ai.chat.entities.ChatSessionEntity;
import com.jetbrains.toolbox.ai.chat.entities.ChatState;
import com.jetbrains.toolbox.ai.chat.message.ChatMessage;
import com.jetbrains.toolbox.ai.chat.message.FunctionInfo;
import com.jetbrains.toolbox.common.ai.TextGenerationSpeed;
import com.jetbrains.toolbox.platform.llm.endpoints.entities.LlmFunctionEntity;
import fleet.kernel.Durable;
import fleet.kernel.DurableEntityType;
import fleet.kernel.SharedChangeScope;
import fleet.kernel.SharedKt;
import fleet.kernel.StorageKey;
import java.util.List;
import java.util.ListIterator;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KClass;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nChatStorageEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatStorageEntity.kt\ncom/jetbrains/toolbox/ai/chat/entities/ChatStorageEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1#2:176\n1869#3,2:177\n739#3,9:179\n1869#3,2:188\n1869#3,2:190\n543#3,6:192\n*S KotlinDebug\n*F\n+ 1 ChatStorageEntity.kt\ncom/jetbrains/toolbox/ai/chat/entities/ChatStorageEntity\n*L\n124#1:177,2\n142#1:179,9\n158#1:188,2\n159#1:190,2\n167#1:192,6\n*E\n"})
public final class ChatStorageEntity
implements Entity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int eid;
    @NotNull
    private static final Attributes.Required<String> SessionIdAttr = Attributes.requiredValue$default(Companion, "sessionId", BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), Indexing.UNIQUE, null, 8, null);
    @NotNull
    private static final Attributes.Many<ChatMessage> MessagesAttr = Attributes.manyValues$default(Companion, "messages", ChatMessage.Companion.serializer(), null, 4, null);

    public ChatStorageEntity(int eid2) {
        this.eid = eid2;
    }

    @Override
    public int getEid() {
        return this.eid;
    }

    @Nullable
    public final ChatSessionEntity getSession() {
        return ChatSessionEntity.Companion.findById(EntityAttributeKt.getRequired((Entity)this, SessionIdAttr));
    }

    @NotNull
    public final List<ChatMessage> getMessages() {
        return CollectionsKt.sortedWith((Iterable)EntityAttributeKt.getMany((Entity)this, MessagesAttr), (arg_0, arg_1) -> ChatStorageEntity._get_messages_$lambda$1(ChatStorageEntity::_get_messages_$lambda$0, arg_0, arg_1));
    }

    public final void appendUserMessage(@NotNull ChangeScope changeScope, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)changeScope, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        ChatSessionEntity session2 = this.getSession();
        if (session2 == null) {
            ChangeScopeKt.delete(changeScope, this);
            return;
        }
        if (session2.getState() == ChatState.Processing) {
            this.assistantProgressDone(changeScope);
        }
        ChangeScopeKt.add(changeScope, (Entity)this, MessagesAttr, new ChatMessage.User(EntityAttributeKt.getMany((Entity)this, MessagesAttr).size(), text2));
        session2.startProcessing(changeScope);
        ChatSessionEntity.interaction$default(session2, changeScope, true, true, false, 8, null);
    }

    public final void stop(@NotNull ChangeScope changeScope) {
        Intrinsics.checkNotNullParameter((Object)changeScope, (String)"<unused var>");
        ChatSessionEntity session2 = this.getSession();
        if (session2 == null) {
            ChangeScopeKt.delete(changeScope, this);
            return;
        }
        this.assistantProgressDone(changeScope);
        session2.goIdle(changeScope);
        ChatSessionEntity.interaction$default(session2, changeScope, true, true, false, 8, null);
    }

    public final void appendRawMessage(@NotNull ChangeScope changeScope, @NotNull Function1<? super Integer, ? extends ChatMessage> builder) {
        Intrinsics.checkNotNullParameter((Object)changeScope, (String)"<unused var>");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        int newMessageId = EntityAttributeKt.getMany((Entity)this, MessagesAttr).size();
        ChangeScopeKt.add(changeScope, (Entity)this, MessagesAttr, builder.invoke((Object)newMessageId));
    }

    public final void updateAssistantInProgressResponse(@NotNull ChangeScope changeScope, @NotNull String newText, @NotNull TextGenerationSpeed speed) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)changeScope, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            Intrinsics.checkNotNullParameter((Object)speed, (String)"speed");
            ChatMessage tip = (ChatMessage)CollectionsKt.lastOrNull(this.getMessages());
            if (tip instanceof ChatMessage.AssistantInProgress) {
                ChangeScopeKt.remove(changeScope, (Entity)this, MessagesAttr, tip);
            }
            int newMessageId = EntityAttributeKt.getMany((Entity)this, MessagesAttr).size();
            ChangeScopeKt.add(changeScope, (Entity)this, MessagesAttr, new ChatMessage.AssistantInProgress(newMessageId, newText, speed));
            ChatSessionEntity chatSessionEntity = this.getSession();
            if (chatSessionEntity == null) break block1;
            ChatSessionEntity.interaction$default(chatSessionEntity, changeScope, false, true, false, 10, null);
        }
    }

    public final void updateAssistantInProgressFunctionCall(@NotNull ChangeScope changeScope, @NotNull String content2, @Nullable String name2) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)changeScope, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            if (name2 != null) {
                FunctionInfo functionInfo;
                LlmFunctionEntity llmFunctionEntity = LlmFunctionEntity.Companion.findForId(name2);
                if (llmFunctionEntity != null) {
                    LlmFunctionEntity it = llmFunctionEntity;
                    boolean bl = false;
                    functionInfo = new FunctionInfo(it.getInfo().getName(), it.getInfo().getTool().getName());
                } else {
                    functionInfo = new FunctionInfo(name2, null, 2, null);
                }
                FunctionInfo info = functionInfo;
                ChatMessage.FunctionCall call2 = new ChatMessage.FunctionCall(EntityAttributeKt.getMany((Entity)this, MessagesAttr).size(), name2, content2, info);
                ChangeScopeKt.add(changeScope, (Entity)this, MessagesAttr, call2);
            } else {
                ChatMessage.FunctionCall oldMessage;
                ChatMessage chatMessage;
                ChatMessage chatMessage2 = (ChatMessage)CollectionsKt.lastOrNull(this.getMessages());
                if (chatMessage2 != null) {
                    ChatMessage chatMessage3;
                    ChatMessage it = chatMessage3 = chatMessage2;
                    boolean bl = false;
                    chatMessage = it instanceof ChatMessage.FunctionCall ? chatMessage3 : null;
                } else {
                    chatMessage = null;
                }
                ChatMessage call2 = chatMessage;
                ChatMessage.FunctionCall functionCall = oldMessage = call2 instanceof ChatMessage.FunctionCall ? (ChatMessage.FunctionCall)call2 : null;
                if (oldMessage == null) {
                    Logger.INSTANCE.warn(ChatStorageEntity::updateAssistantInProgressFunctionCall$lambda$4);
                    return;
                }
                ChangeScopeKt.remove(changeScope, (Entity)this, MessagesAttr, oldMessage);
                ChatMessage.FunctionCall newMessage = ChatMessage.FunctionCall.copy$default(oldMessage, 0, null, oldMessage.getText() + content2, null, 11, null);
                ChangeScopeKt.add(changeScope, (Entity)this, MessagesAttr, newMessage);
            }
            ChatSessionEntity chatSessionEntity = this.getSession();
            if (chatSessionEntity == null) break block7;
            ChatSessionEntity.interaction$default(chatSessionEntity, changeScope, false, true, false, 10, null);
        }
    }

    public final void assistantProgressDone(@NotNull ChangeScope changeScope) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)changeScope, (String)"<unused var>");
            Iterable $this$forEach$iv = this.getMessages();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChatMessage tip = (ChatMessage)element$iv;
                boolean bl = false;
                if (!(tip instanceof ChatMessage.AssistantInProgress)) continue;
                String text2 = ((ChatMessage.AssistantInProgress)tip).getText();
                int order = ((ChatMessage.AssistantInProgress)tip).getOrder();
                ChangeScopeKt.remove(changeScope, (Entity)this, MessagesAttr, tip);
                ChangeScopeKt.add(changeScope, (Entity)this, MessagesAttr, new ChatMessage.AssistantCompleted(order, text2));
            }
            ChatSessionEntity chatSessionEntity = this.getSession();
            if (chatSessionEntity == null) break block1;
            ChatSessionEntity.interaction$default(chatSessionEntity, changeScope, false, true, false, 10, null);
        }
    }

    public final void updateLastResponseOrCreateNew(@NotNull ChangeScope changeScope, @NotNull String functionId, @NotNull Function1<? super ChatMessage.FunctionResponse, ChatMessage.FunctionResponse> updater, @NotNull Function1<? super Integer, ChatMessage.FunctionResponse> builder) {
        block5: {
            ChatMessage.FunctionResponse lastResponse;
            List list2;
            Intrinsics.checkNotNullParameter((Object)changeScope, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)functionId, (String)"functionId");
            Intrinsics.checkNotNullParameter(updater, (String)"updater");
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            List<ChatMessage> $this$dropLastWhile$iv = this.getMessages();
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator<ChatMessage> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    ChatMessage it = iterator$iv.previous();
                    boolean bl = false;
                    if (it instanceof ChatMessage.FunctionInteractiveRequest) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            Object object = CollectionsKt.lastOrNull((List)list2);
            ChatMessage it = (ChatMessage)object;
            boolean bl = false;
            Object object2 = it instanceof ChatMessage.FunctionResponse && Intrinsics.areEqual((Object)((ChatMessage.FunctionResponse)it).getFunctionId(), (Object)functionId) ? object : null;
            ChatMessage.FunctionResponse functionResponse = lastResponse = object2 instanceof ChatMessage.FunctionResponse ? (ChatMessage.FunctionResponse)object2 : null;
            if (lastResponse != null) {
                ChangeScopeKt.remove(changeScope, (Entity)this, MessagesAttr, lastResponse);
                ChangeScopeKt.add(changeScope, (Entity)this, MessagesAttr, updater.invoke((Object)lastResponse));
            } else {
                int newMessageId = EntityAttributeKt.getMany((Entity)this, MessagesAttr).size();
                ChangeScopeKt.add(changeScope, (Entity)this, MessagesAttr, builder.invoke((Object)newMessageId));
            }
            ChatSessionEntity chatSessionEntity = this.getSession();
            if (chatSessionEntity == null) break block5;
            ChatSessionEntity.interaction$default(chatSessionEntity, changeScope, false, true, false, 10, null);
        }
    }

    public final void replaceMessages(@NotNull ChangeScope changeScope, @NotNull List<? extends ChatMessage> newMessages) {
        ChatMessage it;
        Intrinsics.checkNotNullParameter((Object)changeScope, (String)"<unused var>");
        Intrinsics.checkNotNullParameter(newMessages, (String)"newMessages");
        Iterable $this$forEach$iv = this.getMessages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ChatMessage)element$iv;
            boolean bl = false;
            ChangeScopeKt.remove(changeScope, (Entity)this, MessagesAttr, it);
        }
        $this$forEach$iv = newMessages;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ChatMessage)element$iv;
            boolean bl = false;
            ChangeScopeKt.add(changeScope, (Entity)this, MessagesAttr, it);
        }
    }

    public final void updateInteractiveRequest(@NotNull ChangeScope changeScope, @NotNull String requestId, @NotNull Function1<? super ChatMessage.FunctionInteractiveRequest, ChatMessage.FunctionInteractiveRequest> updater) {
        ChatMessage.FunctionInteractiveRequest lastResponse;
        ChatMessage chatMessage;
        block2: {
            Intrinsics.checkNotNullParameter((Object)changeScope, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
            Intrinsics.checkNotNullParameter(updater, (String)"updater");
            List<ChatMessage> $this$lastOrNull$iv = this.getMessages();
            boolean $i$f$lastOrNull = false;
            ListIterator<ChatMessage> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                ChatMessage element$iv;
                ChatMessage it = element$iv = iterator$iv.previous();
                boolean bl = false;
                ChatMessage.FunctionInteractiveRequest functionInteractiveRequest = it instanceof ChatMessage.FunctionInteractiveRequest ? (ChatMessage.FunctionInteractiveRequest)it : null;
                if (!Intrinsics.areEqual((Object)(functionInteractiveRequest != null ? functionInteractiveRequest.getId() : null), (Object)requestId)) continue;
                chatMessage = element$iv;
                break block2;
            }
            chatMessage = null;
        }
        ChatMessage chatMessage2 = chatMessage;
        ChatMessage.FunctionInteractiveRequest functionInteractiveRequest = lastResponse = chatMessage2 instanceof ChatMessage.FunctionInteractiveRequest ? (ChatMessage.FunctionInteractiveRequest)chatMessage2 : null;
        if (lastResponse == null) {
            return;
        }
        ChangeScopeKt.remove(changeScope, (Entity)this, MessagesAttr, lastResponse);
        ChatMessage.FunctionInteractiveRequest updated = ChatMessage.FunctionInteractiveRequest.copy$default((ChatMessage.FunctionInteractiveRequest)updater.invoke((Object)lastResponse), EntityAttributeKt.getMany((Entity)this, MessagesAttr).size(), null, null, null, 14, null);
        ChangeScopeKt.add(changeScope, (Entity)this, MessagesAttr, updated);
    }

    private static final int _get_messages_$lambda$0(ChatMessage a, ChatMessage b) {
        return Intrinsics.compare((int)a.getOrder(), (int)b.getOrder());
    }

    private static final int _get_messages_$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final String updateAssistantInProgressFunctionCall$lambda$4() {
        return "Can't update assistant tool call, no tool call in the chat";
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class Companion
    extends DurableEntityType<ChatStorageEntity> {
        private Companion() {
            super((KClass<? extends Entity>)Reflection.getOrCreateKotlinClass(ChatStorageEntity.class), (Function1)1.INSTANCE, (Mixin<? super E>[])new Mixin[0]);
        }

        @NotNull
        public final ChatStorageEntity new(@NotNull ChangeScope changeScope, @NotNull ChatSessionEntity session2) {
            Intrinsics.checkNotNullParameter((Object)changeScope, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            return (ChatStorageEntity)SharedKt.shared(changeScope, arg_0 -> Companion.new$lambda$1(session2, arg_0));
        }

        @Nullable
        public final ChatStorageEntity findFor(@NotNull ChatSessionEntity session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            return (ChatStorageEntity)EntityAttributeKt.entity(SessionIdAttr, session2.getId());
        }

        @Nullable
        public final ChatStorageEntity findFor(@NotNull String sessionId) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            return (ChatStorageEntity)EntityAttributeKt.entity(SessionIdAttr, sessionId);
        }

        @NotNull
        public final StorageKey storageKeyForSessionId(@NotNull String sessionId) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            return new StorageKey("ai-chat-" + sessionId);
        }

        @NotNull
        public final StorageKey storageKeyForSession(@NotNull ChatSessionEntity session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            return this.storageKeyForSessionId(session2.getId());
        }

        private static final void new$lambda$1$lambda$0(ChatSessionEntity $session, EntityBuilder.Target it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.set(SessionIdAttr, $session.getId());
            it.set(Durable.INSTANCE.getStorageKeyAttr(), Companion.storageKeyForSession($session));
        }

        private static final ChatStorageEntity new$lambda$1(ChatSessionEntity $session, SharedChangeScope $this$shared) {
            Intrinsics.checkNotNullParameter((Object)$this$shared, (String)"$this$shared");
            return (ChatStorageEntity)Companion.new((ChangeScope)$this$shared, arg_0 -> Companion.new$lambda$1$lambda$0($session, arg_0));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

