/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts.oauth;

import com.jetbrains.toolbox.common.security.ShaKt;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.UUID;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class SecurityCodeProvider {
    @NotNull
    private String codeVerifier;
    @NotNull
    private String state;

    public SecurityCodeProvider(@NotNull String codeVerifier2, @NotNull String state2) {
        Intrinsics.checkNotNullParameter((Object)codeVerifier2, (String)"codeVerifier");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.codeVerifier = codeVerifier2;
        this.state = state2;
    }

    public /* synthetic */ SecurityCodeProvider(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        this(string, string2);
    }

    @NotNull
    public final String getCodeVerifier() {
        return this.codeVerifier;
    }

    @NotNull
    public final String getState() {
        return this.state;
    }

    public final void newState() {
        Logger.INSTANCE.debug("New OAuth state");
        this.state = this.generateState();
    }

    @NotNull
    public final String newCodeChallenge() {
        this.codeVerifier = this.generateCodeVerifier();
        Object object = this.codeVerifier;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] hash = ShaKt.sha256(byArray);
        String string = Base64.getUrlEncoder().encodeToString(hash);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        object = new char[1];
        object[0] = 61;
        return StringsKt.trimEnd((String)string, (char[])object);
    }

    private final String generateState() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String generateCodeVerifier() {
        byte[] bytes2 = new byte[64];
        SecureRandom random = new SecureRandom();
        random.nextBytes(bytes2);
        String string = Base64.getUrlEncoder().withoutPadding().encodeToString(bytes2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    public SecurityCodeProvider() {
        this(null, null, 3, null);
    }
}

