/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts.keychain;

import com.jetbrains.toolbox.Keychain;
import com.jetbrains.toolbox.accounts.Account;
import com.jetbrains.toolbox.accounts.AuthManager;
import com.jetbrains.toolbox.accounts.AuthToken;
import com.jetbrains.toolbox.accounts.LookupResult;
import com.jetbrains.toolbox.accounts.RefreshEvent;
import com.jetbrains.toolbox.accounts.SecureAccountToken;
import com.jetbrains.toolbox.accounts.keychain.KeychainAuthManager;
import com.jetbrains.toolbox.accounts.oauth.TokenRefresher;
import com.jetbrains.toolbox.common.JsonKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nKeychainAuthManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeychainAuthManager.kt\ncom/jetbrains/toolbox/accounts/keychain/KeychainAuthManager\n+ 2 LookupResult.kt\ncom/jetbrains/toolbox/accounts/LookupResultKt\n+ 3 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n29#2:109\n23#2,5:110\n29#2:123\n23#2,5:124\n23#2,5:131\n116#3,8:115\n125#3:130\n1#4:129\n*S KotlinDebug\n*F\n+ 1 KeychainAuthManager.kt\ncom/jetbrains/toolbox/accounts/keychain/KeychainAuthManager\n*L\n56#1:109\n56#1:110,5\n76#1:123\n76#1:124,5\n89#1:131,5\n62#1:115,8\n62#1:130\n*E\n"})
public final class KeychainAuthManager<A extends Account, SAT extends SecureAccountToken>
implements AuthManager<A, SAT> {
    @NotNull
    private final Keychain keychain;
    @NotNull
    private final TokenRefresher<A, SAT> tokenRefresher;
    @NotNull
    private final KSerializer<SAT> tokenSerializer;
    @NotNull
    private final Clock clock;
    private final long cooldown;
    @NotNull
    private final String serviceIdForKeychain;
    @NotNull
    private Instant backOffUntil;
    @NotNull
    private final Mutex refreshLock;
    @NotNull
    private final Json tokenJson;
    @NotNull
    private final MutableSharedFlow<RefreshEvent> _refreshFlow;
    @NotNull
    private final SharedFlow<RefreshEvent> refreshFlow;

    private KeychainAuthManager(String serviceId, Keychain keychain, TokenRefresher<? super A, SAT> tokenRefresher, KSerializer<SAT> tokenSerializer, Clock clock, long cooldown) {
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        Intrinsics.checkNotNullParameter((Object)keychain, (String)"keychain");
        Intrinsics.checkNotNullParameter(tokenRefresher, (String)"tokenRefresher");
        Intrinsics.checkNotNullParameter(tokenSerializer, (String)"tokenSerializer");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.keychain = keychain;
        this.tokenRefresher = tokenRefresher;
        this.tokenSerializer = tokenSerializer;
        this.clock = clock;
        this.cooldown = cooldown;
        this.serviceIdForKeychain = "Toolbox: " + serviceId;
        this.backOffUntil = Instant.Companion.getDISTANT_PAST();
        this.refreshLock = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.tokenJson = kotlinx.serialization.json.JsonKt.Json((Json)JsonKt.getJsonx(), KeychainAuthManager::tokenJson$lambda$0);
        this._refreshFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        this.refreshFlow = FlowKt.asSharedFlow(this._refreshFlow);
    }

    public /* synthetic */ KeychainAuthManager(String string, Keychain keychain, TokenRefresher tokenRefresher, KSerializer kSerializer, Clock clock, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            l = DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS);
        }
        this(string, keychain, tokenRefresher, kSerializer, clock, l, null);
    }

    @Override
    @NotNull
    public SharedFlow<RefreshEvent> getRefreshFlow() {
        return this.refreshFlow;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object get(@NotNull A account, @NotNull Continuation<? super LookupResult<AuthToken>> $completion) {
        if (!($completion instanceof get.1)) ** GOTO lbl-1000
        var14_3 = $completion;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ KeychainAuthManager<A, SAT> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.get(null, (Continuation<LookupResult<AuthToken>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = this.keychain;
                var4_7 = this.serviceIdForKeychain;
                var5_9 = account.getId();
                var12_10 = this;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)account);
                $continuation.L$1 = var12_10;
                $continuation.label = 1;
                v0 = var3_6.fetchFromKeychain(var5_9, var4_7, (Continuation<? super LookupResult<String>>)$continuation);
                if (v0 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                var12_10 = (KeychainAuthManager)$continuation.L$1;
                account = (Account)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                $this$map$iv = var12_10.parseToken((LookupResult)v0);
                $i$f$map = false;
                $this$flatMap$iv$iv = $this$map$iv;
                $i$f$flatMap = false;
                var7_12 = $this$flatMap$iv$iv;
                if (var7_12 instanceof LookupResult.NotFound) {
                    v1 = $this$flatMap$iv$iv;
                } else if (var7_12 instanceof LookupResult.Unavailable) {
                    v1 = $this$flatMap$iv$iv;
                } else if (var7_12 instanceof LookupResult.Found) {
                    it$iv = ((LookupResult.Found)$this$flatMap$iv$iv).getValue();
                    $i$a$-flatMap-LookupResultKt$map$1$iv = false;
                    it = (SecureAccountToken)it$iv;
                    $i$a$-map-KeychainAuthManager$get$2 = false;
                    var15_17 = new AuthToken(it);
                    v1 = new LookupResult.Found<AuthToken>(var15_17);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object cache(@NotNull String accountId, @NotNull AuthToken auth, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object refreshAndGet(@NotNull A account, @Nullable AuthToken invalidAuth, @NotNull Continuation<? super LookupResult<AuthToken>> $completion) {
        if (!($completion instanceof refreshAndGet.1)) ** GOTO lbl-1000
        var21_4 = $completion;
        if ((var21_4.label & -2147483648) != 0) {
            var21_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ KeychainAuthManager<A, SAT> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.refreshAndGet(null, null, (Continuation<LookupResult<AuthToken>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.refreshLock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = account;
                $continuation.L$1 = invalidAuth;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var23_6) {
                    return var23_6;
                }
                ** GOTO lbl33
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                invalidAuth = (AuthToken)$continuation.L$1;
                account = (Account)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 3 sources

                $i$a$-withLock$default-KeychainAuthManager$refreshAndGet$2 = 0;
                $continuation.L$0 = account;
                $continuation.L$1 = invalidAuth;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-KeychainAuthManager$refreshAndGet$2;
                $continuation.label = 2;
                v1 = DelayKt.delay-VtjQ1oo((long)this.backOffUntil.minus-5sfh64U(this.clock.now()), (Continuation)$continuation);
                ** if (v1 != var23_6) goto lbl44
lbl43:
                // 1 sources

                return var23_6;
lbl44:
                // 1 sources

                ** GOTO lbl56
            }
            case 2: {
                $i$a$-withLock$default-KeychainAuthManager$refreshAndGet$2 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                invalidAuth = (AuthToken)$continuation.L$1;
                account = (Account)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl56:
                // 2 sources

                $continuation.L$0 = account;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)invalidAuth);
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-KeychainAuthManager$refreshAndGet$2;
                $continuation.label = 3;
                v2 = this.updateUnsafe(account.getId(), (Function2<? super SAT, ? super Continuation<? super LookupResult<? extends SAT>>, ? extends Object>)((Function2)new Function2<SAT, Continuation<? super LookupResult<? extends SAT>>, Object>(invalidAuth, this, account, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ AuthToken $invalidAuth;
                    final /* synthetic */ KeychainAuthManager<A, SAT> this$0;
                    final /* synthetic */ A $account;
                    {
                        this.$invalidAuth = $invalidAuth;
                        this.this$0 = $receiver;
                        this.$account = $account;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        SecureAccountToken secureAccountToken = (SecureAccountToken)this.L$0;
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void storedToken;
                                AuthToken storedAuthToken;
                                ResultKt.throwOnFailure((Object)$result);
                                if (this.$invalidAuth != null && !Intrinsics.areEqual((Object)(storedAuthToken = new AuthToken((SecureAccountToken)storedToken)).getHeader(), (Object)this.$invalidAuth.getHeader())) {
                                    return new LookupResult.Unavailable("already fresh");
                                }
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)storedToken);
                                this.label = 1;
                                Object object2 = KeychainAuthManager.access$getTokenRefresher$p(this.this$0).refresh(this.$account, storedToken, (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value2;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(SAT p1, Continuation<? super LookupResult<? extends SAT>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super LookupResult<? extends SAT>>)$continuation);
                ** if (v2 != var23_6) goto lbl65
lbl64:
                // 1 sources

                return var23_6;
lbl65:
                // 1 sources

                ** GOTO lbl77
            }
            case 3: {
                $i$a$-withLock$default-KeychainAuthManager$refreshAndGet$2 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                invalidAuth = (AuthToken)$continuation.L$1;
                account = (Account)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl77:
                // 2 sources

                if (!((newToken = (LookupResult)v2) instanceof LookupResult.Found)) ** GOTO lbl101
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)account);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)invalidAuth);
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.L$3 = newToken;
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-KeychainAuthManager$refreshAndGet$2;
                $continuation.label = 4;
                v3 = this._refreshFlow.emit((Object)new RefreshEvent(account.getId(), ((SecureAccountToken)((LookupResult.Found)newToken).getValue()).getAuthorizationHeader(), ((SecureAccountToken)((LookupResult.Found)newToken).getValue()).getExpiresAt()), (Continuation)$continuation);
                ** if (v3 != var23_6) goto lbl88
lbl87:
                // 1 sources

                return var23_6;
lbl88:
                // 1 sources

                ** GOTO lbl101
            }
            case 4: {
                $i$a$-withLock$default-KeychainAuthManager$refreshAndGet$2 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                newToken = (LookupResult)$continuation.L$3;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                invalidAuth = (AuthToken)$continuation.L$1;
                account = (Account)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl101:
                    // 3 sources

                    $this$map$iv = newToken;
                    $i$f$map = false;
                    $this$flatMap$iv$iv = $this$map$iv;
                    $i$f$flatMap = false;
                    var13_20 = $this$flatMap$iv$iv;
                    if (var13_20 instanceof LookupResult.NotFound) {
                        v4 = $this$flatMap$iv$iv;
                    } else if (var13_20 instanceof LookupResult.Unavailable) {
                        v4 = $this$flatMap$iv$iv;
                    } else if (var13_20 instanceof LookupResult.Found) {
                        it$iv = ((LookupResult.Found)$this$flatMap$iv$iv).getValue();
                        $i$a$-flatMap-LookupResultKt$map$1$iv = false;
                        it = (SecureAccountToken)it$iv;
                        $i$a$-map-KeychainAuthManager$refreshAndGet$2$1 = false;
                        var22_25 = new AuthToken(it);
                        v4 = new LookupResult.Found<AuthToken>(var22_25);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    it = var9_14 = v4;
                    $i$a$-also-KeychainAuthManager$refreshAndGet$2$2 = false;
                    this.backOffUntil = this.clock.now().plus-LRDsOJo(this.cooldown);
                    var19_26 = var9_14;
                    return var19_26;
                }
                catch (Throwable var18_27) {
                    throw var18_27;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object store(@NotNull String accountId, @NotNull SAT token, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof store.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ KeychainAuthManager<A, SAT> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.store(null, null, (Continuation<Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                data = this.tokenJson.encodeToString((SerializationStrategy)this.tokenSerializer, token);
                $continuation.L$0 = accountId;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)token);
                $continuation.L$2 = data;
                $continuation.label = 1;
                v0 = this._refreshFlow.emit((Object)new RefreshEvent(accountId, token.getAuthorizationHeader(), token.getExpiresAt()), (Continuation)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl27
            }
            case 1: {
                data = (String)$continuation.L$2;
                token = (SecureAccountToken)$continuation.L$1;
                accountId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                var5_9 = this.keychain;
                var6_10 = this.serviceIdForKeychain;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)accountId);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)token);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)data);
                $continuation.label = 2;
                v1 = var5_9.writeToKeychain(accountId, data, var6_10, (Continuation<? super Unit>)$continuation);
                if (v1 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl43
            }
            case 2: {
                data = (String)$continuation.L$2;
                token = (SecureAccountToken)$continuation.L$1;
                accountId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object remove(@NotNull String accountId, @NotNull Continuation<? super Unit> $completion) {
        Keychain keychain = this.keychain;
        String string = this.serviceIdForKeychain;
        Object object = keychain.writeToKeychain(accountId, "", string, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final LookupResult<SAT> parseToken(LookupResult<String> $this$parseToken) {
        LookupResult lookupResult;
        LookupResult $this$flatMap$iv = $this$parseToken;
        boolean $i$f$flatMap = false;
        LookupResult lookupResult2 = $this$flatMap$iv;
        if (lookupResult2 instanceof LookupResult.NotFound) {
            lookupResult = $this$flatMap$iv;
        } else if (lookupResult2 instanceof LookupResult.Unavailable) {
            lookupResult = $this$flatMap$iv;
        } else if (lookupResult2 instanceof LookupResult.Found) {
            LookupResult lookupResult3;
            String it = (String)((LookupResult.Found)$this$flatMap$iv).getValue();
            boolean bl = false;
            try {
                lookupResult3 = new LookupResult.Found<Object>(this.tokenJson.decodeFromString((DeserializationStrategy)this.tokenSerializer, it));
            }
            catch (Exception e) {
                lookupResult3 = new LookupResult.NotFound("Couldn't parse token: " + Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName() + " " + e.getMessage());
            }
            lookupResult = lookupResult3;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return lookupResult;
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateUnsafe(String accountId, Function2<? super SAT, ? super Continuation<? super LookupResult<? extends SAT>>, ? extends Object> transform, Continuation<? super LookupResult<? extends SAT>> $completion) {
        if (!($completion instanceof updateUnsafe.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ KeychainAuthManager<A, SAT> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return KeychainAuthManager.access$updateUnsafe(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_7 = this.keychain;
                var5_8 = this.serviceIdForKeychain;
                var6_9 = this;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)accountId);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)transform);
                $continuation.L$2 = var6_9;
                $continuation.label = 1;
                v0 = var4_7.updateInKeychain(accountId, var5_8, (Function2<? super String, ? super Continuation<? super LookupResult<String>>, ? extends Object>)((Function2)new Function2<String, Continuation<? super LookupResult<? extends String>>, Object>(this, accountId, transform, null){
                    Object L$1;
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ KeychainAuthManager<A, SAT> this$0;
                    final /* synthetic */ String $accountId;
                    final /* synthetic */ Function2<SAT, Continuation<? super LookupResult<? extends SAT>>, Object> $transform;
                    {
                        this.this$0 = $receiver;
                        this.$accountId = $accountId;
                        this.$transform = $transform;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = (String)this.L$0;
                        var10_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                try {
                                    var4_4 = (SecureAccountToken)KeychainAuthManager.access$getTokenJson$p(this.this$0).decodeFromString((DeserializationStrategy)KeychainAuthManager.access$getTokenSerializer$p(this.this$0), (String)storedSecret);
                                }
                                catch (Exception e) {
                                    Logger.INSTANCE.error((Throwable)e, "Couldn't parse token for account " + this.$accountId);
                                    return new LookupResult.NotFound("Couldn't parse token: " + Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName() + " " + e.getMessage());
                                }
                                storedToken = var4_4;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)storedSecret);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)storedToken);
                                this.label = 1;
                                v0 = this.$transform.invoke(storedToken, (Object)this);
                                if (v0 == var10_3) {
                                    return var10_3;
                                }
                                ** GOTO lbl25
                            }
                            case 1: {
                                storedToken = (SecureAccountToken)this.L$1;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl25:
                                // 2 sources

                                var4_4 = (LookupResult)v0;
                                var5_6 = this.this$0;
                                $i$f$flatMap = false;
                                var7_10 = $this$flatMap$iv;
                                if (var7_10 instanceof LookupResult.NotFound) {
                                    v1 = $this$flatMap$iv;
                                } else if (var7_10 instanceof LookupResult.Unavailable) {
                                    v1 = $this$flatMap$iv;
                                } else if (var7_10 instanceof LookupResult.Found) {
                                    it = (SecureAccountToken)((LookupResult.Found)$this$flatMap$iv).getValue();
                                    $i$a$-flatMap-KeychainAuthManager$updateUnsafe$2$1 = false;
                                    v1 = new LookupResult.Found<String>(KeychainAuthManager.access$getTokenJson$p(var5_6).encodeToString((SerializationStrategy)KeychainAuthManager.access$getTokenSerializer$p(var5_6), (Object)it));
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                                return v1;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value2;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(String p1, Continuation<? super LookupResult<String>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super LookupResult<String>>)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl29
            }
            case 1: {
                var6_9 = (KeychainAuthManager)$continuation.L$2;
                transform = (Function2)$continuation.L$1;
                accountId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                return var6_9.parseToken((LookupResult)v0);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit tokenJson$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(false);
        return Unit.INSTANCE;
    }

    public /* synthetic */ KeychainAuthManager(String serviceId, Keychain keychain, TokenRefresher tokenRefresher, KSerializer tokenSerializer, Clock clock, long cooldown, DefaultConstructorMarker $constructor_marker) {
        this(serviceId, keychain, tokenRefresher, tokenSerializer, clock, cooldown);
    }

    public static final /* synthetic */ Object access$updateUnsafe(KeychainAuthManager $this, String accountId, Function2 transform2, Continuation $completion) {
        return $this.updateUnsafe(accountId, transform2, $completion);
    }

    public static final /* synthetic */ Json access$getTokenJson$p(KeychainAuthManager $this) {
        return $this.tokenJson;
    }

    public static final /* synthetic */ KSerializer access$getTokenSerializer$p(KeychainAuthManager $this) {
        return $this.tokenSerializer;
    }

    public static final /* synthetic */ TokenRefresher access$getTokenRefresher$p(KeychainAuthManager $this) {
        return $this.tokenRefresher;
    }
}

