/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts;

import com.jetbrains.toolbox.accounts.PluginSecureToken$;
import com.jetbrains.toolbox.accounts.SecureAccountToken;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Token;
import com.jetbrains.toolbox.common.serialization.InstantAsEpochSecondsSerializer;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlinx.datetime.Instant;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.LongSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@SourceDebugExtension(value={"SMAP\nSecureAccountToken.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecureAccountToken.kt\ncom/jetbrains/toolbox/accounts/PluginSecureToken\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
public final class PluginSecureToken
extends SecureAccountToken {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String accessToken;
    @NotNull
    private final String refreshToken;
    @Nullable
    private final Instant expiresAt;
    @NotNull
    private final String tokenType;
    @Nullable
    private final String idToken;
    @Nullable
    private final String scope;
    @Nullable
    private final Long refreshExpiresInSeconds;

    public PluginSecureToken(@NotNull String accessToken, @NotNull String refreshToken, @Nullable Instant expiresAt, @NotNull String tokenType, @Nullable String idToken, @Nullable String scope2, @Nullable Long refreshExpiresInSeconds) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        super(null);
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expiresAt = expiresAt;
        this.tokenType = tokenType;
        this.idToken = idToken;
        this.scope = scope2;
        this.refreshExpiresInSeconds = refreshExpiresInSeconds;
    }

    @Override
    @NotNull
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    @NotNull
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    @Nullable
    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    @NotNull
    public String getTokenType() {
        return this.tokenType;
    }

    @Override
    @Nullable
    public String getIdToken() {
        return this.idToken;
    }

    public PluginSecureToken(@NotNull OAuth2Token oAuth2Token) {
        Intrinsics.checkNotNullParameter((Object)oAuth2Token, (String)"oAuth2Token");
        PluginSecureToken pluginSecureToken = this;
        String string = oAuth2Token.getAccessToken();
        if (string == null) {
            PluginSecureToken pluginSecureToken2 = pluginSecureToken;
            boolean $i$a$-requireNotNull-PluginSecureToken$42 = false;
            PluginSecureToken pluginSecureToken3 = pluginSecureToken2;
            String $i$a$-requireNotNull-PluginSecureToken$42 = "accessToken is missing but required by https://www.rfc-editor.org/rfc/rfc6749.html#section-5.1";
            throw new IllegalArgumentException($i$a$-requireNotNull-PluginSecureToken$42.toString());
        }
        String string2 = oAuth2Token.getRefreshToken();
        if (string2 == null) {
            String string3 = string;
            PluginSecureToken pluginSecureToken4 = pluginSecureToken;
            boolean $i$a$-requireNotNull-PluginSecureToken$52 = false;
            String string4 = "refreshToken is missing but needed";
            PluginSecureToken pluginSecureToken5 = pluginSecureToken4;
            String string5 = string3;
            String $i$a$-requireNotNull-PluginSecureToken$52 = string4;
            throw new IllegalArgumentException($i$a$-requireNotNull-PluginSecureToken$52.toString());
        }
        Instant instant = oAuth2Token.getExpiresAt();
        String string6 = oAuth2Token.getTokenType();
        if (string6 == null) {
            Instant instant2 = instant;
            String string7 = string2;
            String string8 = string;
            PluginSecureToken pluginSecureToken6 = pluginSecureToken;
            boolean bl = false;
            String string9 = "tokenType is missing but required by https://www.rfc-editor.org/rfc/rfc6749.html#section-5.1";
            PluginSecureToken pluginSecureToken7 = pluginSecureToken6;
            String string10 = string8;
            String string11 = string7;
            Instant instant3 = instant2;
            String string12 = string9;
            throw new IllegalArgumentException(string12.toString());
        }
        Duration duration = oAuth2Token.getRefreshExpiresIn-FghU774();
        pluginSecureToken(string, string2, instant, string6, oAuth2Token.getIdToken(), oAuth2Token.getScope(), duration != null ? Long.valueOf(Duration.getInWholeSeconds-impl((long)duration.unbox-impl())) : null);
    }

    @Override
    @NotNull
    public String getAuthorizationHeader() {
        return ((CharSequence)this.getTokenType()).length() == 0 ? this.getAccessToken() : this.getTokenType() + " " + this.getAccessToken();
    }

    @NotNull
    public final PluginSecureToken updateFrom(@NotNull OAuth2Token token2) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        Intrinsics.checkNotNullParameter((Object)token2, (String)"token");
        String string7 = token2.getAccessToken();
        if (string7 == null) {
            string7 = string6 = this.getAccessToken();
        }
        if ((string5 = token2.getRefreshToken()) == null) {
            string5 = string4 = this.getRefreshToken();
        }
        if ((string3 = token2.getTokenType()) == null) {
            string3 = this.getTokenType();
        }
        String string8 = string3;
        Instant instant = token2.getExpiresAt();
        String string9 = token2.getIdToken();
        if (string9 == null) {
            string9 = string2 = this.getIdToken();
        }
        if ((string = token2.getScope()) == null) {
            string = this.scope;
        }
        String string10 = string;
        Duration duration = token2.getRefreshExpiresIn-FghU774();
        Long l = duration != null ? Long.valueOf(Duration.getInWholeSeconds-impl((long)duration.unbox-impl())) : null;
        return this.copy(string6, string4, instant, string8, string2, string10, l);
    }

    @NotNull
    public final PluginSecureToken copy(@NotNull String accessToken, @NotNull String refreshToken, @Nullable Instant expiresAt, @NotNull String tokenType, @Nullable String idToken, @Nullable String scope2, @Nullable Long refreshExpiresInSeconds) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return new PluginSecureToken(accessToken, refreshToken, expiresAt, tokenType, idToken, scope2, refreshExpiresInSeconds);
    }

    @NotNull
    public String toString() {
        return "PluginSecureToken(accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", expiresAt=" + this.expiresAt + ", tokenType=" + this.tokenType + ", idToken=" + this.idToken + ", scope=" + this.scope + ", refreshExpiresInSeconds=" + this.refreshExpiresInSeconds + ")";
    }

    public int hashCode() {
        int result2 = this.accessToken.hashCode();
        result2 = result2 * 31 + this.refreshToken.hashCode();
        result2 = result2 * 31 + (this.expiresAt == null ? 0 : this.expiresAt.hashCode());
        result2 = result2 * 31 + this.tokenType.hashCode();
        result2 = result2 * 31 + (this.idToken == null ? 0 : this.idToken.hashCode());
        result2 = result2 * 31 + (this.scope == null ? 0 : this.scope.hashCode());
        result2 = result2 * 31 + (this.refreshExpiresInSeconds == null ? 0 : ((Object)this.refreshExpiresInSeconds).hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PluginSecureToken)) {
            return false;
        }
        PluginSecureToken pluginSecureToken = (PluginSecureToken)other;
        if (!Intrinsics.areEqual((Object)this.accessToken, (Object)pluginSecureToken.accessToken)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.refreshToken, (Object)pluginSecureToken.refreshToken)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.expiresAt, (Object)pluginSecureToken.expiresAt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tokenType, (Object)pluginSecureToken.tokenType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.idToken, (Object)pluginSecureToken.idToken)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scope, (Object)pluginSecureToken.scope)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.refreshExpiresInSeconds, (Object)pluginSecureToken.refreshExpiresInSeconds);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$accounts_api(PluginSecureToken self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        SecureAccountToken.write$Self(self, output2, serialDesc);
        output2.encodeStringElement(serialDesc, 0, self.getAccessToken());
        output2.encodeStringElement(serialDesc, 1, self.getRefreshToken());
        output2.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)InstantAsEpochSecondsSerializer.INSTANCE, (Object)self.getExpiresAt());
        output2.encodeStringElement(serialDesc, 3, self.getTokenType());
        if (output2.shouldEncodeElementDefault(serialDesc, 4) ? true : self.getIdToken() != null) {
            output2.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.getIdToken());
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 5) ? true : self.scope != null) {
            output2.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.scope);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 6) ? true : self.refreshExpiresInSeconds != null) {
            output2.encodeNullableSerializableElement(serialDesc, 6, (SerializationStrategy)LongSerializer.INSTANCE, (Object)self.refreshExpiresInSeconds);
        }
    }

    public /* synthetic */ PluginSecureToken(int seen0, String accessToken, String refreshToken, Instant expiresAt, String tokenType, String idToken, String scope2, Long refreshExpiresInSeconds, SerializationConstructorMarker serializationConstructorMarker) {
        if (15 != (0xF & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)15, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        super(seen0, serializationConstructorMarker);
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expiresAt = expiresAt;
        this.tokenType = tokenType;
        this.idToken = (seen0 & 0x10) == 0 ? null : idToken;
        this.scope = (seen0 & 0x20) == 0 ? null : scope2;
        this.refreshExpiresInSeconds = (seen0 & 0x40) == 0 ? null : refreshExpiresInSeconds;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<PluginSecureToken> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

