/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface LookupResult<T> {

    public static final class Found<T>
    implements LookupResult<T> {
        private final T value;

        public Found(T value2) {
            this.value = value2;
        }

        public final T getValue() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return "Found(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Found)) {
                return false;
            }
            Found found = (Found)other;
            return Intrinsics.areEqual(this.value, found.value);
        }
    }

    public static final class NotFound
    implements LookupResult {
        @NotNull
        private final String message;

        public NotFound(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.message = message2;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public String toString() {
            return "NotFound(message=" + this.message + ")";
        }

        public int hashCode() {
            return this.message.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NotFound)) {
                return false;
            }
            NotFound notFound = (NotFound)other;
            return Intrinsics.areEqual((Object)this.message, (Object)notFound.message);
        }
    }

    public static final class Unavailable
    implements LookupResult {
        @NotNull
        private final String message;

        public Unavailable(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.message = message2;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public String toString() {
            return "Unavailable(message=" + this.message + ")";
        }

        public int hashCode() {
            return this.message.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Unavailable)) {
                return false;
            }
            Unavailable unavailable = (Unavailable)other;
            return Intrinsics.areEqual((Object)this.message, (Object)unavailable.message);
        }
    }
}

