/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts;

import com.jetbrains.toolbox.accounts.Account;
import com.jetbrains.toolbox.accounts.AccountProvider;
import com.jetbrains.toolbox.accounts.AuthConfiguration;
import com.jetbrains.toolbox.accounts.JetBrainsAccount;
import com.jetbrains.toolbox.accounts.JetBrainsAccountProvider;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public abstract sealed class AuthEvent {
    @NotNull
    private final AccountProvider<Account> provider;

    private AuthEvent(AccountProvider<? extends Account> provider2) {
        this.provider = provider2;
    }

    @NotNull
    public final AccountProvider<Account> getProvider() {
        return this.provider;
    }

    public /* synthetic */ AuthEvent(AccountProvider provider2, DefaultConstructorMarker $constructor_marker) {
        this(provider2);
    }

    public static final class ExtraAccountsRemoved
    extends AuthEvent {
        @NotNull
        private final JetBrainsAccount activeAccount;

        public ExtraAccountsRemoved(@NotNull JetBrainsAccountProvider provider2, @NotNull JetBrainsAccount activeAccount2) {
            Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)activeAccount2, (String)"activeAccount");
            super(provider2, null);
            this.activeAccount = activeAccount2;
        }

        @NotNull
        public final JetBrainsAccount getActiveAccount() {
            return this.activeAccount;
        }
    }

    public static final class LoggedIn
    extends AuthEvent {
        @NotNull
        private final Account account;
        @NotNull
        private final AuthConfiguration config;

        public LoggedIn(@NotNull AccountProvider<? extends Account> provider2, @NotNull Account account2, @NotNull AuthConfiguration config) {
            Intrinsics.checkNotNullParameter(provider2, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)account2, (String)"account");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            super(provider2, null);
            this.account = account2;
            this.config = config;
        }

        @NotNull
        public Account getAccount() {
            return this.account;
        }

        @NotNull
        public final AuthConfiguration getConfig() {
            return this.config;
        }
    }

    public static final class LoggedOut
    extends AuthEvent {
        @NotNull
        private final Account account;

        public LoggedOut(@NotNull AccountProvider<? extends Account> provider2, @NotNull Account account2) {
            Intrinsics.checkNotNullParameter(provider2, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)account2, (String)"account");
            super(provider2, null);
            this.account = account2;
        }

        @NotNull
        public Account getAccount() {
            return this.account;
        }
    }

    public static final class MalformedToken
    extends AuthEvent {
        public MalformedToken(@NotNull AccountProvider<? extends Account> provider2) {
            Intrinsics.checkNotNullParameter(provider2, (String)"provider");
            super(provider2, null);
        }
    }

    public static final class Rejected
    extends AuthEvent {
        public Rejected(@NotNull AccountProvider<? extends Account> provider2) {
            Intrinsics.checkNotNullParameter(provider2, (String)"provider");
            super(provider2, null);
        }
    }
}

