/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.accounts;

import com.jetbrains.toolbox.accounts.Account;
import com.jetbrains.toolbox.accounts.AccountProvider;
import com.jetbrains.toolbox.accounts.AccountProviderImpl;
import com.jetbrains.toolbox.accounts.AuthConfiguration;
import com.jetbrains.toolbox.accounts.AuthEvent;
import com.jetbrains.toolbox.accounts.AuthManager;
import com.jetbrains.toolbox.accounts.AuthToken;
import com.jetbrains.toolbox.accounts.AuthorizationRejectionException;
import com.jetbrains.toolbox.accounts.LoginRequiredException;
import com.jetbrains.toolbox.accounts.LookupResult;
import com.jetbrains.toolbox.accounts.NetworkConnectivityException;
import com.jetbrains.toolbox.accounts.RefreshEvent;
import com.jetbrains.toolbox.accounts.SecureAccountToken;
import com.jetbrains.toolbox.accounts.oauth.ClientProvider;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Client;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Response;
import com.jetbrains.toolbox.accounts.oauth.OAuth2ResponseExtensionsKt;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Token;
import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.common.extensions.StringExtensionsKt;
import com.jetbrains.toolbox.common.extensions.URIExtensionsKt;
import com.jetbrains.toolbox.network.AuthInterceptor;
import com.jetbrains.toolbox.network.BasicDownloadManager;
import com.jetbrains.toolbox.network.BlockingCalls;
import com.jetbrains.toolbox.network.DownloadSession;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nAccountProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountProviderImpl.kt\ncom/jetbrains/toolbox/accounts/AccountProviderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,341:1\n1617#2,9:342\n1869#2:351\n1870#2:353\n1626#2:354\n1869#2,2:355\n1#3:352\n1#3:357\n*S KotlinDebug\n*F\n+ 1 AccountProviderImpl.kt\ncom/jetbrains/toolbox/accounts/AccountProviderImpl\n*L\n239#1:342,9\n239#1:351\n239#1:353\n239#1:354\n240#1:355,2\n239#1:352\n*E\n"})
public abstract class AccountProviderImpl<A extends Account, SAT extends SecureAccountToken>
implements AccountProvider<A> {
    @NotNull
    private final String id;
    @NotNull
    private final String displayName;
    @NotNull
    private final String urlHost;
    @NotNull
    private final String urlPrefix;
    @NotNull
    private final BasicDownloadManager downloadManager;
    @NotNull
    private final Clock clock;
    @NotNull
    private final ClientProvider clientProvider;
    @NotNull
    private final AuthManager<A, SAT> authManager;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final MutableStateFlow<OAuth2Client> _authClient;
    @NotNull
    private final StateFlow<String> authState;
    @NotNull
    private final MutableStateFlow<List<A>> _accounts;
    @NotNull
    private final StateFlow<List<A>> accounts;
    @NotNull
    private final MutableSharedFlow<AuthEvent> _authEvent;
    @NotNull
    private final SharedFlow<AuthEvent> authEvent;
    @NotNull
    private final AuthInterceptor interceptor;
    private final long LOGIN_ATTEMPT_TTL;

    public AccountProviderImpl(@NotNull String id, @NotNull String displayName, @NotNull String urlHost, @NotNull String urlPrefix, @NotNull BasicDownloadManager downloadManager, @NotNull Clock clock, @NotNull ClientProvider clientProvider, @NotNull AuthManager<A, ? super SAT> authManager, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)urlHost, (String)"urlHost");
        Intrinsics.checkNotNullParameter((Object)urlPrefix, (String)"urlPrefix");
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)clientProvider, (String)"clientProvider");
        Intrinsics.checkNotNullParameter(authManager, (String)"authManager");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.id = id;
        this.displayName = displayName;
        this.urlHost = urlHost;
        this.urlPrefix = urlPrefix;
        this.downloadManager = downloadManager;
        this.clock = clock;
        this.clientProvider = clientProvider;
        this.authManager = authManager;
        this.coroutineScope = coroutineScope;
        this._authClient = StateFlowKt.MutableStateFlow(null);
        this.authState = FlowExtensionsKt.mapState((StateFlow)this._authClient, AccountProviderImpl::authState$lambda$0);
        this._accounts = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.accounts = FlowKt.asStateFlow(this._accounts);
        this._authEvent = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        this.authEvent = FlowKt.asSharedFlow(this._authEvent);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AccountProviderImpl<A, SAT> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.getAuthManager().getRefreshFlow().collect(new FlowCollector(){

                            public final Object emit(RefreshEvent authRefreshEvent, Continuation<? super Unit> $completion) {
                                String string = authRefreshEvent.getAccountId();
                                if (string == null) {
                                    Account account2 = (Account)CollectionsKt.singleOrNull((List)((List)this$0.getAccounts().getValue()));
                                    string = account2 != null ? account2.getId() : null;
                                    if (string == null) {
                                        return Unit.INSTANCE;
                                    }
                                }
                                String accountId = string;
                                Object a = this$0.getAccount(accountId);
                                if (a == null) {
                                    return Unit.INSTANCE;
                                }
                                Object account3 = a;
                                BuildersKt.launch$default((CoroutineScope)this$0.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, account3, authRefreshEvent, null){
                                    Object L$0;
                                    int label;
                                    final /* synthetic */ AccountProviderImpl<A, SAT> this$0;
                                    final /* synthetic */ A $account;
                                    final /* synthetic */ RefreshEvent $authRefreshEvent;
                                    {
                                        this.this$0 = $receiver;
                                        this.$account = $account;
                                        this.$authRefreshEvent = $authRefreshEvent;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.L$0 = var3_3 = this.this$0;
                                                this.label = 1;
                                                v0 = this.this$0.updateAccountFromAuth(this.$account, this.$authRefreshEvent.getAuthorizationHeader(), (Continuation)this);
                                                if (v0 == var4_2) {
                                                    return var4_2;
                                                }
                                                ** GOTO lbl15
                                            }
                                            case 1: {
                                                var3_3 = (AccountProviderImpl<Account, SAT>)this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl15:
                                                // 2 sources

                                                updatedAccount = var3_3.updateAccountTimestamp-moChb0s((Account)v0, this.this$0.getClock().now(), null);
                                                this.this$0.updateAccount(this.$account.getId(), (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$1(com.jetbrains.toolbox.accounts.Account com.jetbrains.toolbox.accounts.Account ), (Lcom/jetbrains/toolbox/accounts/Account;)Lcom/jetbrains/toolbox/accounts/Account;)((Account)updatedAccount));
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }

                                    private static final Account invokeSuspend$lambda$1(Account $updatedAccount, Account it) {
                                        Account account2;
                                        Account account3 = it;
                                        if (account3 != null) {
                                            Account it2 = account3;
                                            boolean bl = false;
                                            account2 = $updatedAccount;
                                        } else {
                                            account2 = null;
                                        }
                                        return account2;
                                    }
                                }), (int)3, null);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.interceptor = arg_0 -> AccountProviderImpl.interceptor$lambda$11(this, arg_0);
        this.LOGIN_ATTEMPT_TTL = DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.MINUTES);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    protected final BasicDownloadManager getDownloadManager() {
        return this.downloadManager;
    }

    @NotNull
    protected final Clock getClock() {
        return this.clock;
    }

    @NotNull
    protected final AuthManager<A, SAT> getAuthManager() {
        return this.authManager;
    }

    @NotNull
    protected final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @Override
    @NotNull
    public StateFlow<String> getAuthState() {
        return this.authState;
    }

    @Override
    @NotNull
    public StateFlow<List<A>> getAccounts() {
        return this.accounts;
    }

    @NotNull
    protected final MutableSharedFlow<AuthEvent> get_authEvent() {
        return this._authEvent;
    }

    @Override
    @NotNull
    public SharedFlow<AuthEvent> getAuthEvent() {
        return this.authEvent;
    }

    @NotNull
    protected abstract A updateAccountTimestamp-moChb0s(@NotNull A var1, @Nullable Instant var2, @Nullable Duration var3);

    @Nullable
    protected Object updateAccountFromAuth(@NotNull A account2, @NotNull String auth, @NotNull Continuation<? super A> $completion) {
        return account2;
    }

    @Nullable
    protected abstract Object handle(@NotNull OAuth2Token var1, @NotNull AuthConfiguration var2, @NotNull Continuation<? super Unit> var3);

    @Nullable
    protected abstract A getAccountToInterceptUri(@NotNull URI var1);

    @Nullable
    protected final A updateAccount(@NotNull String id, @NotNull Function1<? super A, ? extends A> update2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(update2, (String)"update");
        return (A)((Account)FlowExtensionsKt.getAndUpdateInPlace(this._accounts, update2, arg_0 -> AccountProviderImpl.updateAccount$lambda$1(id, arg_0)));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    protected final Object add(@NotNull A account, @NotNull SAT token, @NotNull AuthConfiguration authConfiguration, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof add.1)) ** GOTO lbl-1000
        var6_5 = $completion;
        if ((var6_5.label & -2147483648) != 0) {
            var6_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AccountProviderImpl<A, SAT> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.add(null, null, null, (Continuation<Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = account;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable(token /* !! */ );
                $continuation.L$2 = authConfiguration;
                $continuation.label = 1;
                v0 = this.authManager.store(account.getId(), token /* !! */ , (Continuation<Unit>)$continuation);
                if (v0 == var7_7) {
                    return var7_7;
                }
                ** GOTO lbl26
            }
            case 1: {
                authConfiguration = (AuthConfiguration)$continuation.L$2;
                token /* !! */  = (SecureAccountToken)$continuation.L$1;
                account = (Account)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                this.updateAccount(account.getId(), (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, add$lambda$2(com.jetbrains.toolbox.accounts.Account com.jetbrains.toolbox.accounts.Account ), (Lcom/jetbrains/toolbox/accounts/Account;)Lcom/jetbrains/toolbox/accounts/Account;)((Account)account));
                BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, account, authConfiguration, null){
                    int label;
                    final /* synthetic */ AccountProviderImpl<A, SAT> this$0;
                    final /* synthetic */ A $account;
                    final /* synthetic */ AuthConfiguration $authConfiguration;
                    {
                        this.this$0 = $receiver;
                        this.$account = $account;
                        this.$authConfiguration = $authConfiguration;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.this$0.get_authEvent().emit((Object)new AuthEvent.LoggedIn((AccountProvider<? extends Account>)this.this$0, (Account)this.$account, this.$authConfiguration), (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected final Object handle(@NotNull OAuth2Response response, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof handle.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AccountProviderImpl<A, SAT> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handle((OAuth2Response)null, (Continuation<Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                client = (OAuth2Client)this._authClient.getValue();
                if (client == null) {
                    Logger.INSTANCE.warn("Client doesn't exist, but got response, for provider " + this.getDisplayName());
                    return Boxing.boxBoolean((boolean)false);
                }
                $continuation.L$0 = response;
                $continuation.L$1 = client;
                $continuation.label = 1;
                v0 = this.downloadManager.createSession((Continuation<? super DownloadSession>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                client = (OAuth2Client)$continuation.L$1;
                response = (OAuth2Response)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)response);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)v0), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(client, response, this, null){
                    Object L$1;
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ OAuth2Client $client;
                    final /* synthetic */ OAuth2Response $response;
                    final /* synthetic */ AccountProviderImpl<A, SAT> this$0;
                    {
                        this.$client = $client;
                        this.$response = $response;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        block16: {
                            var2_2 = (CoroutineScope)this.L$0;
                            var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.L$0 = $this$withContext;
                                    this.label = 1;
                                    v0 = this.$client.fetchFromCode(this.$response, (Continuation<? super OAuth2Token>)((Continuation)this));
                                    ** if (v0 != var5_3) goto lbl13
lbl12:
                                    // 1 sources

                                    return var5_3;
lbl13:
                                    // 1 sources

                                    ** GOTO lbl19
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl19:
                                    // 2 sources

                                    oAuth2Token = (OAuth2Token)v0;
                                    this.L$0 = $this$withContext;
                                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)oAuth2Token);
                                    this.label = 2;
                                    v1 = this.this$0.handle(oAuth2Token, this.$client.getAuthConfiguration(), (Continuation<Unit>)((Continuation)this));
                                    ** if (v1 != var5_3) goto lbl26
lbl25:
                                    // 1 sources

                                    return var5_3;
lbl26:
                                    // 1 sources

                                    ** GOTO lbl33
                                }
                                case 2: {
                                    oAuth2Token = (OAuth2Token)this.L$1;
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl33:
                                        // 2 sources

                                        var3_5 = true;
                                    }
                                    catch (AuthorizationRejectionException ex) {
                                        this.this$0.cancelLogin();
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                                        this.L$1 = ex;
                                        this.label = 3;
                                        v2 = this.this$0.get_authEvent().emit((Object)new AuthEvent.Rejected((AccountProvider<? extends Account>)this.this$0), (Continuation)this);
                                        if (v2 == var5_3) {
                                            return var5_3;
                                        }
                                        ** GOTO lbl48
                                    }
                                }
                                case 3: {
                                    ex = (AuthorizationRejectionException)this.L$1;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
lbl48:
                                    // 2 sources

                                    v3 = ex;
                                    v4 = this.$client.getBaseUrl();
                                    if (v4 == null) {
                                        v4 = "an unknown host";
                                    }
                                    Logger.INSTANCE.warn(v3, "The authorization request to " + v4 + " was rejected");
                                    var3_5 = false;
                                    break block16;
                                }
                            }
                            catch (Throwable t) {
                                JobKt.ensureActive((CoroutineContext)$this$withContext.getCoroutineContext());
                                this.this$0.cancelLogin();
                                v5 = this.$client.getBaseUrl();
                                if (v5 == null) {
                                    v5 = "an unknown host";
                                }
                                Logger.INSTANCE.error(t, "Failed to log in to " + v5 + " due to an unhandled error");
                                var3_5 = false;
                            }
                        }
                        return Boxing.boxBoolean((boolean)(var3_5 != false));
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value2;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl40
            }
            case 2: {
                client = (OAuth2Client)$continuation.L$1;
                response = (OAuth2Response)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl40:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object getAuth(@NotNull String id, boolean forceRefresh, @NotNull Continuation<? super AuthToken> $completion) {
        return AccountProviderImpl.getAuth$suspendImpl(this, id, forceRefresh, $completion);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static /* synthetic */ <A extends Account, SAT extends SecureAccountToken> Object getAuth$suspendImpl(AccountProviderImpl<A, SAT> $this, String id, boolean forceRefresh, Continuation<? super AuthToken> $completion) {
        block16: {
            block17: {
                if (!($completion instanceof getAuth.1)) ** GOTO lbl-1000
                var9_4 = $completion;
                if ((var9_4.label & -2147483648) != 0) {
                    var9_4.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl($this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        boolean Z$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ AccountProviderImpl<A, SAT> this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return AccountProviderImpl.getAuth$suspendImpl(this.this$0, null, false, (Continuation<? super AuthToken>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $this.getAccount(id);
                        if (v0 == null) {
                            throw new LoginRequiredException("No such account: " + id, null, 2, null);
                        }
                        account /* !! */  = v0;
                        if (account /* !! */ .getExpired()) {
                            throw new LoginRequiredException("Session has expired for account: " + id, null, 2, null);
                        }
                        if (!forceRefresh) break;
                        $continuation.L$0 = $this;
                        $continuation.L$1 = id;
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)account /* !! */ );
                        $continuation.Z$0 = forceRefresh;
                        $continuation.label = 1;
                        v1 = AuthManager.refreshAndGet$default($this.authManager, account /* !! */ , null, $continuation, 2, null);
                        if (v1 == var10_6) {
                            return var10_6;
                        }
                        ** GOTO lbl35
                    }
                    case 1: {
                        forceRefresh = $continuation.Z$0;
                        account /* !! */  = (Account)$continuation.L$2;
                        id = (String)$continuation.L$1;
                        $this = (AccountProviderImpl)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl35:
                        // 2 sources

                        v2 = (LookupResult)v1;
                        break block16;
                    }
                }
                $continuation.L$0 = $this;
                $continuation.L$1 = id;
                $continuation.L$2 = account /* !! */ ;
                $continuation.Z$0 = forceRefresh;
                $continuation.label = 2;
                v3 = $this.authManager.get(account /* !! */ , (Continuation<LookupResult<AuthToken>>)$continuation);
                if (v3 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl53
                {
                    case 2: {
                        forceRefresh = $continuation.Z$0;
                        account /* !! */  = (Account)$continuation.L$2;
                        id = (String)$continuation.L$1;
                        $this = (AccountProviderImpl)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl53:
                        // 2 sources

                        if (!((authHeaderResponse = (LookupResult)v3) instanceof LookupResult.Found)) break block17;
                        expiresAt = ((AuthToken)((LookupResult.Found)authHeaderResponse).getValue()).getExpiresAt();
                        if (expiresAt == null || expiresAt.compareTo($this.clock.now()) >= 0) break;
                        $continuation.L$0 = $this;
                        $continuation.L$1 = id;
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)account /* !! */ );
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)authHeaderResponse);
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)expiresAt);
                        $continuation.Z$0 = forceRefresh;
                        $continuation.label = 3;
                        v4 = AuthManager.refreshAndGet$default($this.authManager, account /* !! */ , null, $continuation, 2, null);
                        if (v4 == var10_6) {
                            return var10_6;
                        }
                        ** GOTO lbl76
                    }
                    case 3: {
                        forceRefresh = $continuation.Z$0;
                        expiresAt = (Instant)$continuation.L$4;
                        authHeaderResponse = (LookupResult)$continuation.L$3;
                        account /* !! */  = (Account)$continuation.L$2;
                        id = (String)$continuation.L$1;
                        $this = (AccountProviderImpl)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl76:
                        // 2 sources

                        v2 = (LookupResult)v4;
                        break block16;
                    }
                }
                v2 = authHeaderResponse;
                break block16;
            }
            v2 = authHeaderResponse;
        }
        var6_8 = response = v2;
        if (var6_8 instanceof LookupResult.Found) {
            return ((LookupResult.Found)response).getValue();
        }
        if (var6_8 instanceof LookupResult.NotFound) {
            $this.updateAccount(id, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getAuth$lambda$4(com.jetbrains.toolbox.accounts.AccountProviderImpl com.jetbrains.toolbox.accounts.Account ), (Lcom/jetbrains/toolbox/accounts/Account;)Lcom/jetbrains/toolbox/accounts/Account;)((AccountProviderImpl)$this));
            throw new LoginRequiredException(((LookupResult.NotFound)response).getMessage(), null, 2, null);
        }
        if (var6_8 instanceof LookupResult.Unavailable) {
            throw new NetworkConnectivityException(((LookupResult.Unavailable)response).getMessage(), null, 2, null);
        }
        throw new NoWhenBranchMatchedException();
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    protected final String initiateLogin(@NotNull AuthConfiguration authConfiguration) {
        Intrinsics.checkNotNullParameter((Object)authConfiguration, (String)"authConfiguration");
        OAuth2Client client = this.clientProvider.createClient(authConfiguration);
        this._authClient.setValue((Object)client);
        String authUrl = client.getAuthUrl();
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, client, null){
            int label;
            final /* synthetic */ AccountProviderImpl<A, SAT> this$0;
            final /* synthetic */ OAuth2Client $client;
            {
                this.this$0 = $receiver;
                this.$client = $client;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)AccountProviderImpl.access$getLOGIN_ATTEMPT_TTL$p(this.this$0), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        AccountProviderImpl.access$get_authClient$p(this.this$0).compareAndSet((Object)this.$client, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return authUrl;
    }

    @Override
    public void cancelLogin() {
        this._authClient.setValue(null);
    }

    @Override
    @Nullable
    public Object logout(@NotNull String id, @NotNull Continuation<? super Unit> $completion) {
        return AccountProviderImpl.logout$suspendImpl(this, id, $completion);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static /* synthetic */ <A extends Account, SAT extends SecureAccountToken> Object logout$suspendImpl(AccountProviderImpl<A, SAT> $this, String id, Continuation<? super Unit> $completion) {
        if (!($completion instanceof logout.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AccountProviderImpl<A, SAT> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AccountProviderImpl.logout$suspendImpl(this.this$0, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                account /* !! */  = $this.updateAccount(id, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, logout$lambda$5(com.jetbrains.toolbox.accounts.Account ), (Lcom/jetbrains/toolbox/accounts/Account;)Lcom/jetbrains/toolbox/accounts/Account;)());
                $continuation.L$0 = $this;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)id);
                $continuation.L$2 = account /* !! */ ;
                $continuation.label = 1;
                v0 = $this.authManager.remove(id, (Continuation<Unit>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                account /* !! */  = (Account)$continuation.L$2;
                id = (String)$continuation.L$1;
                $this = (AccountProviderImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                BuildersKt.launch$default((CoroutineScope)$this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(account /* !! */ , $this, null){
                    int label;
                    final /* synthetic */ A $account;
                    final /* synthetic */ AccountProviderImpl<A, SAT> this$0;
                    {
                        this.$account = $account;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                if (this.$account == null) return Unit.INSTANCE;
                                this.label = 1;
                                Object object2 = this.this$0.get_authEvent().emit((Object)new AuthEvent.LoggedOut((AccountProvider<? extends Account>)this.this$0, (Account)this.$account), (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canHandle(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (!Intrinsics.areEqual((Object)uri.getHost(), (Object)this.urlHost)) return false;
        String string = uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (!StringsKt.startsWith$default((String)string, (String)("/" + this.urlPrefix), (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Override
    @Nullable
    public Object handle(@NotNull URI uri, @NotNull Continuation<? super Unit> $completion) {
        return AccountProviderImpl.handle$suspendImpl(this, uri, $completion);
    }

    static /* synthetic */ <A extends Account, SAT extends SecureAccountToken> Object handle$suspendImpl(AccountProviderImpl<A, SAT> $this, URI uri, Continuation<? super Unit> $completion) {
        Object object = $this.handle(OAuth2ResponseExtensionsKt.toOAuthResponse(uri), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object login(@NotNull AuthConfiguration authConfiguration, @NotNull String code, @NotNull Continuation<? super Boolean> $completion) {
        String authUrl = this.initiateLogin(authConfiguration);
        Object object = StringExtensionsKt.toUriOrNull(authUrl);
        String state2 = object != null && (object = URIExtensionsKt.parseQuery((URI)object)) != null ? (String)object.get("state") : null;
        String redirectUri = authConfiguration.getRedirectUrl();
        return this.handle(new OAuth2Response(state2, code, null, null, null, redirectUri, 28, null), $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tryLoadAccounts(@NotNull List<? extends Account> accounts2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(accounts2, (String)"accounts");
        Iterable $this$mapNotNull$iv = accounts2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            A it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Account account2 = (Account)element$iv$iv;
            boolean bl2 = false;
            if (this.tryCast(account2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Account account3 = (Account)element$iv;
            boolean bl = false;
            this.updateAccount(account3.getId(), arg_0 -> AccountProviderImpl.tryLoadAccounts$lambda$8$lambda$7(account3, arg_0));
        }
    }

    @Override
    @NotNull
    public AuthInterceptor getInterceptor() {
        return this.interceptor;
    }

    private final Response unauthorizedResponse(Request request2, String message2) {
        return new Response.Builder().code(401).message(message2).protocol(Protocol.HTTP_1_1).header("Content-Length", "0").header("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate").request(request2).body(ResponseBody.Companion.create$default(ResponseBody.Companion, new byte[0], null, 1, null)).build();
    }

    private final void expire(A account2) {
        this.updateAccount(((Account)account2).getId(), arg_0 -> AccountProviderImpl.expire$lambda$13(this, arg_0));
    }

    @Nullable
    protected abstract A tryCast(@NotNull Account var1);

    @Override
    @Nullable
    public A getAccount(@NotNull String id) {
        return AccountProvider.super.getAccount(id);
    }

    @Override
    public boolean getImpliesUiMode() {
        return AccountProvider.super.getImpliesUiMode();
    }

    private static final String authState$lambda$0(OAuth2Client it) {
        OAuth2Client oAuth2Client = it;
        return oAuth2Client != null ? oAuth2Client.getBaseUrl() : null;
    }

    private static final boolean updateAccount$lambda$1(String $id, Account it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getId(), (Object)$id);
    }

    private static final Account add$lambda$2(Account $account, Account it) {
        return $account;
    }

    private static final Account getAuth$lambda$4(AccountProviderImpl this$0, Account it) {
        Account account2;
        Account account3 = it;
        if (account3 != null) {
            Account it2 = account3;
            boolean bl = false;
            account2 = this$0.updateAccountTimestamp-moChb0s(it2, this$0.clock.now(), Duration.box-impl((long)Duration.Companion.getZERO-UwyO8pc()));
        } else {
            account2 = null;
        }
        return account2;
    }

    private static final Account logout$lambda$5(Account it) {
        return null;
    }

    private static final Account tryLoadAccounts$lambda$8$lambda$7(Account $account, Account it) {
        return $account;
    }

    private static final String interceptor$lambda$11$lambda$9(URI $uri, Account $account) {
        return "Intercepting request to '" + $uri + "' using account " + $account.getId();
    }

    private static final <A extends Account, SAT extends SecureAccountToken> Response interceptor$lambda$11$logAndProceedWithoutAuth(boolean requireAuthHeader, AccountProviderImpl<A, SAT> this$0, Request request2, Interceptor.Chain $chain, String message2) {
        Logger.INSTANCE.error(message2);
        return requireAuthHeader ? super.unauthorizedResponse(request2, message2) : $chain.proceed(request2);
    }

    private static final Response interceptor$lambda$11(AccountProviderImpl this$0, Interceptor.Chain chain) {
        Response response2;
        LookupResult result2;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request originalRequest = chain.request();
        boolean requireAuthHeader = Intrinsics.areEqual((Object)originalRequest.header("X-Toolbox-Authorization-Required"), (Object)"true");
        if (originalRequest.header("Authorization") != null) {
            return chain.proceed(originalRequest);
        }
        URI uri = originalRequest.url().uri();
        Object a = this$0.getAccountToInterceptUri(uri);
        if (a == null) {
            return chain.proceed(originalRequest);
        }
        Object account2 = a;
        Logger.INSTANCE.trace(() -> AccountProviderImpl.interceptor$lambda$11$lambda$9(uri, account2));
        Request request2 = requireAuthHeader ? originalRequest.newBuilder().removeHeader("X-Toolbox-Authorization-Required").build() : originalRequest;
        LookupResult lookupResult = result2 = !((Account)account2).getExpired() ? (LookupResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LookupResult<? extends AuthToken>>, Object>(this$0, account2, null){
            int label;
            final /* synthetic */ AccountProviderImpl<A, SAT> this$0;
            final /* synthetic */ A $account;
            {
                this.this$0 = $receiver;
                this.$account = $account;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)BlockingCalls.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LookupResult<? extends AuthToken>>, Object>(this.this$0, this.$account, null){
                            int label;
                            final /* synthetic */ AccountProviderImpl<A, SAT> this$0;
                            final /* synthetic */ A $account;
                            {
                                this.this$0 = $receiver;
                                this.$account = $account;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = this.this$0.getAuthManager().get(this.$account, (Continuation<LookupResult<AuthToken>>)((Continuation)this));
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super LookupResult<AuthToken>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super LookupResult<AuthToken>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null) : (LookupResult)new LookupResult.NotFound("account expired");
        if (!(lookupResult instanceof LookupResult.Found)) {
            if (lookupResult instanceof LookupResult.NotFound) {
                this$0.expire(account2);
                return AccountProviderImpl.interceptor$lambda$11$logAndProceedWithoutAuth(requireAuthHeader, this$0, request2, chain, "Couldn't get authorization header: " + ((LookupResult.NotFound)result2).getMessage());
            }
            if (lookupResult instanceof LookupResult.Unavailable) {
                return AccountProviderImpl.interceptor$lambda$11$logAndProceedWithoutAuth(requireAuthHeader, this$0, request2, chain, "Couldn't get authorization header due to network issues: " + ((LookupResult.Unavailable)result2).getMessage());
            }
            throw new NoWhenBranchMatchedException();
        }
        AuthToken auth = (AuthToken)((LookupResult.Found)result2).getValue();
        Request requestWithAuth = request2.newBuilder().header("Authorization", auth.getHeader()).build();
        Response response3 = chain.proceed(requestWithAuth);
        if (response3.code() != 401) {
            return response3;
        }
        response3.close();
        LookupResult refreshResult2 = (LookupResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LookupResult<? extends AuthToken>>, Object>(this$0, account2, auth, null){
            int label;
            final /* synthetic */ AccountProviderImpl<A, SAT> this$0;
            final /* synthetic */ A $account;
            final /* synthetic */ AuthToken $auth;
            {
                this.this$0 = $receiver;
                this.$account = $account;
                this.$auth = $auth;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)BlockingCalls.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LookupResult<? extends AuthToken>>, Object>(this.this$0, this.$account, this.$auth, null){
                            int label;
                            final /* synthetic */ AccountProviderImpl<A, SAT> this$0;
                            final /* synthetic */ A $account;
                            final /* synthetic */ AuthToken $auth;
                            {
                                this.this$0 = $receiver;
                                this.$account = $account;
                                this.$auth = $auth;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = this.this$0.getAuthManager().refreshAndGet(this.$account, this.$auth, (Continuation<LookupResult<AuthToken>>)((Continuation)this));
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super LookupResult<AuthToken>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super LookupResult<AuthToken>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (!(refreshResult2 instanceof LookupResult.Found)) {
            if (refreshResult2 instanceof LookupResult.NotFound) {
                String message2 = "Couldn't refresh authorization header: " + ((LookupResult.NotFound)refreshResult2).getMessage();
                Logger.INSTANCE.error(message2);
                this$0.expire(account2);
                return this$0.unauthorizedResponse(requestWithAuth, message2);
            }
            if (refreshResult2 instanceof LookupResult.Unavailable) {
                throw new IOException("couldn't get authorization header due to network issues: " + ((LookupResult.Unavailable)refreshResult2).getMessage());
            }
            throw new NoWhenBranchMatchedException();
        }
        AuthToken refreshedAuth2 = (AuthToken)((LookupResult.Found)refreshResult2).getValue();
        Response it = response2 = chain.proceed(request2.newBuilder().addHeader("Authorization", refreshedAuth2.getHeader()).build());
        boolean bl = false;
        if (it.code() == 401) {
            Logger.INSTANCE.error("Request to '" + uri + "' failed with 401 after refreshing the authorization header; expiring the session");
            this$0.expire(account2);
        }
        return response2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Account expire$lambda$13(AccountProviderImpl this$0, Account it) {
        Object object;
        Account account2 = it;
        if (account2 != null) {
            void var2_2;
            Account it2 = account2;
            boolean bl = false;
            object = !it2.getExpired() ? this$0.updateAccountTimestamp-moChb0s(it2, this$0.clock.now(), Duration.box-impl((long)Duration.Companion.getZERO-UwyO8pc())) : var2_2;
        } else {
            object = null;
        }
        return object;
    }

    public static final /* synthetic */ long access$getLOGIN_ATTEMPT_TTL$p(AccountProviderImpl $this) {
        return $this.LOGIN_ATTEMPT_TTL;
    }

    public static final /* synthetic */ MutableStateFlow access$get_authClient$p(AccountProviderImpl $this) {
        return $this._authClient;
    }
}

