/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.InAppNotificationDuration;
import com.jetbrains.toolbox.SnackbarInfo$;
import com.jetbrains.toolbox.Strings;
import com.jetbrains.toolbox.fus.FusEnums;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
public final class SnackbarInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String header;
    @NotNull
    private final String body;
    @Nullable
    private final String actionLabel;
    @Nullable
    private final String dismissLabel;
    private final boolean competing;
    @Nullable
    private final FusEnums.NotificationType notificationType;
    @NotNull
    private final InAppNotificationDuration duration;
    @NotNull
    private final String id;
    @NotNull
    private final String legacyMessage;
    @Nullable
    private final String legacyActionLabel;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public SnackbarInfo(@NotNull String header, @NotNull String body, @Nullable String actionLabel, @Nullable String dismissLabel, boolean competing, @Nullable FusEnums.NotificationType notificationType, @NotNull InAppNotificationDuration duration, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)((Object)duration), (String)"duration");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.header = header;
        this.body = body;
        this.actionLabel = actionLabel;
        this.dismissLabel = dismissLabel;
        this.competing = competing;
        this.notificationType = notificationType;
        this.duration = duration;
        this.id = id;
        String string = Strings.Companion.join(this.header, this.body);
        Intrinsics.checkNotNull((Object)string);
        this.legacyMessage = string;
        this.legacyActionLabel = Strings.Companion.join(this.actionLabel, this.dismissLabel);
    }

    public /* synthetic */ SnackbarInfo(String string, String string2, String string3, String string4, boolean bl, FusEnums.NotificationType notificationType, InAppNotificationDuration inAppNotificationDuration, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            notificationType = null;
        }
        if ((n & 0x40) != 0) {
            inAppNotificationDuration = InAppNotificationDuration.Indefinite;
        }
        this(string, string2, string3, string4, bl, notificationType, inAppNotificationDuration, string5);
    }

    public final boolean getCompeting() {
        return this.competing;
    }

    @Nullable
    public final FusEnums.NotificationType getNotificationType() {
        return this.notificationType;
    }

    @NotNull
    public final InAppNotificationDuration getDuration() {
        return this.duration;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getLegacyMessage() {
        return this.legacyMessage;
    }

    @Nullable
    public final String getLegacyActionLabel() {
        return this.legacyActionLabel;
    }

    @NotNull
    public String toString() {
        return "SnackbarInfo(header=" + this.header + ", body=" + this.body + ", actionLabel=" + this.actionLabel + ", dismissLabel=" + this.dismissLabel + ", competing=" + this.competing + ", notificationType=" + this.notificationType + ", duration=" + this.duration + ", id=" + this.id + ")";
    }

    public int hashCode() {
        int result2 = this.header.hashCode();
        result2 = result2 * 31 + this.body.hashCode();
        result2 = result2 * 31 + (this.actionLabel == null ? 0 : this.actionLabel.hashCode());
        result2 = result2 * 31 + (this.dismissLabel == null ? 0 : this.dismissLabel.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.competing);
        result2 = result2 * 31 + (this.notificationType == null ? 0 : this.notificationType.hashCode());
        result2 = result2 * 31 + this.duration.hashCode();
        result2 = result2 * 31 + this.id.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SnackbarInfo)) {
            return false;
        }
        SnackbarInfo snackbarInfo = (SnackbarInfo)other;
        if (!Intrinsics.areEqual((Object)this.header, (Object)snackbarInfo.header)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.body, (Object)snackbarInfo.body)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.actionLabel, (Object)snackbarInfo.actionLabel)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dismissLabel, (Object)snackbarInfo.dismissLabel)) {
            return false;
        }
        if (this.competing != snackbarInfo.competing) {
            return false;
        }
        if (this.notificationType != snackbarInfo.notificationType) {
            return false;
        }
        if (this.duration != snackbarInfo.duration) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.id, (Object)snackbarInfo.id);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$api(SnackbarInfo self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        boolean bl;
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output2.encodeStringElement(serialDesc, 0, self.header);
        output2.encodeStringElement(serialDesc, 1, self.body);
        if (output2.shouldEncodeElementDefault(serialDesc, 2) ? true : self.actionLabel != null) {
            output2.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.actionLabel);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 3) ? true : self.dismissLabel != null) {
            output2.encodeNullableSerializableElement(serialDesc, 3, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.dismissLabel);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 4) ? true : self.competing) {
            output2.encodeBooleanElement(serialDesc, 4, self.competing);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 5) ? true : self.notificationType != null) {
            output2.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)lazyArray[5].getValue(), (Object)self.notificationType);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 6) ? true : self.duration != InAppNotificationDuration.Indefinite) {
            output2.encodeSerializableElement(serialDesc, 6, (SerializationStrategy)lazyArray[6].getValue(), (Object)self.duration);
        }
        output2.encodeStringElement(serialDesc, 7, self.id);
        if (output2.shouldEncodeElementDefault(serialDesc, 8)) {
            bl = true;
        } else {
            String string = self.legacyMessage;
            String string2 = Strings.Companion.join(self.header, self.body);
            Intrinsics.checkNotNull((Object)string2);
            bl = !Intrinsics.areEqual((Object)string, (Object)string2);
        }
        if (bl) {
            output2.encodeStringElement(serialDesc, 8, self.legacyMessage);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 9) ? true : !Intrinsics.areEqual((Object)self.legacyActionLabel, (Object)Strings.Companion.join(self.actionLabel, self.dismissLabel))) {
            output2.encodeNullableSerializableElement(serialDesc, 9, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.legacyActionLabel);
        }
    }

    public /* synthetic */ SnackbarInfo(int seen0, String header, String body, String actionLabel, String dismissLabel, boolean competing, FusEnums.NotificationType notificationType, InAppNotificationDuration duration, String id, String legacyMessage, String legacyActionLabel, SerializationConstructorMarker serializationConstructorMarker) {
        if (131 != (0x83 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)131, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.header = header;
        this.body = body;
        this.actionLabel = (seen0 & 4) == 0 ? null : actionLabel;
        this.dismissLabel = (seen0 & 8) == 0 ? null : dismissLabel;
        this.competing = (seen0 & 0x10) == 0 ? false : competing;
        this.notificationType = (seen0 & 0x20) == 0 ? null : notificationType;
        this.duration = (seen0 & 0x40) == 0 ? InAppNotificationDuration.Indefinite : duration;
        this.id = id;
        if ((seen0 & 0x100) == 0) {
            String string = Strings.Companion.join(this.header, this.body);
            Intrinsics.checkNotNull((Object)string);
            this.legacyMessage = string;
        } else {
            this.legacyMessage = legacyMessage;
        }
        this.legacyActionLabel = (seen0 & 0x200) == 0 ? Strings.Companion.join(this.actionLabel, this.dismissLabel) : legacyActionLabel;
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{null, null, null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> EnumsKt.createSimpleEnumSerializer((String)"com.jetbrains.toolbox.fus.FusEnums.NotificationType", (Enum[])FusEnums.NotificationType.values())), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> EnumsKt.createSimpleEnumSerializer((String)"com.jetbrains.toolbox.InAppNotificationDuration", (Enum[])InAppNotificationDuration.values())), null, null, null};
        $childSerializers = lazyArray;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<SnackbarInfo> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

