/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.LinuxDistro;
import java.io.File;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nOS.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OS.kt\ncom/jetbrains/toolbox/RegexLinuxDistroInfoProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n1#2:222\n*E\n"})
final class RegexLinuxDistroInfoProvider {
    @NotNull
    private final String filename;
    @NotNull
    private final Regex idRegex;
    @NotNull
    private final Regex versionRegex;
    @Nullable
    private final Regex nameRegex;
    @Nullable
    private final Regex prettyNameRegex;

    public RegexLinuxDistroInfoProvider(@NotNull String filename, @NotNull Regex idRegex, @NotNull Regex versionRegex, @Nullable Regex nameRegex, @Nullable Regex prettyNameRegex) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)idRegex, (String)"idRegex");
        Intrinsics.checkNotNullParameter((Object)versionRegex, (String)"versionRegex");
        this.filename = filename;
        this.idRegex = idRegex;
        this.versionRegex = versionRegex;
        this.nameRegex = nameRegex;
        this.prettyNameRegex = prettyNameRegex;
    }

    @Nullable
    public LinuxDistro collectDistroInfo() {
        File file = new File(this.filename);
        if (file.exists()) {
            try {
                String string;
                String string2;
                String name2;
                String version;
                String id;
                block14: {
                    String string3;
                    String string4;
                    List lines;
                    block13: {
                        String string5;
                        String string6;
                        block12: {
                            String string7;
                            Object object;
                            block11: {
                                lines = FilesKt.readLines$default((File)file, null, (int)1, null);
                                for (Object line : (Iterable)lines) {
                                    boolean bl = false;
                                    if ((line = this.extractId((String)line)) == null) continue;
                                    object = line;
                                    break block11;
                                }
                                object = string7 = null;
                            }
                            if (object == null) {
                                string7 = "unknown";
                            }
                            id = string7;
                            for (String line : (Iterable)lines) {
                                boolean bl = false;
                                String string8 = this.extractVersion(line);
                                if (string8 == null) continue;
                                string6 = string8;
                                break block12;
                            }
                            string6 = string5 = null;
                        }
                        if (string6 == null) {
                            string5 = "";
                        }
                        version = string5;
                        for (String line : (Iterable)lines) {
                            boolean bl = false;
                            String string9 = this.extractName(line);
                            if (string9 == null) continue;
                            string4 = string9;
                            break block13;
                        }
                        string4 = string3 = null;
                    }
                    if (string4 == null) {
                        string3 = "";
                    }
                    name2 = string3;
                    for (String line : (Iterable)lines) {
                        boolean bl = false;
                        String string10 = this.extractPrettyName(line);
                        if (string10 == null) continue;
                        string2 = string10;
                        break block14;
                    }
                    string2 = string = null;
                }
                if (string2 == null) {
                    string = name2;
                }
                String prettyName = string;
                LinuxDistro distro = new LinuxDistro(id, version, name2, prettyName);
                Logger.INSTANCE.info("Linux distribution according to " + this.filename + ": " + distro);
                return distro;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public final String extractId(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.match(line, this.idRegex);
    }

    @Nullable
    public final String extractVersion(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.match(line, this.versionRegex);
    }

    @Nullable
    public final String extractName(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.match(line, this.nameRegex);
    }

    @Nullable
    public final String extractPrettyName(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.match(line, this.prettyNameRegex);
    }

    private final String match(String line, Regex regex) {
        Object object = regex;
        return object != null && (object = Regex.find$default((Regex)object, (CharSequence)line, (int)0, (int)2, null)) != null && (object = object.getGroupValues()) != null ? (String)CollectionsKt.getOrNull((List)object, (int)1) : null;
    }

    @NotNull
    public final RegexLinuxDistroInfoProvider copy(@NotNull String filename, @NotNull Regex idRegex, @NotNull Regex versionRegex, @Nullable Regex nameRegex, @Nullable Regex prettyNameRegex) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)idRegex, (String)"idRegex");
        Intrinsics.checkNotNullParameter((Object)versionRegex, (String)"versionRegex");
        return new RegexLinuxDistroInfoProvider(filename, idRegex, versionRegex, nameRegex, prettyNameRegex);
    }

    public static /* synthetic */ RegexLinuxDistroInfoProvider copy$default(RegexLinuxDistroInfoProvider regexLinuxDistroInfoProvider, String string, Regex regex, Regex regex2, Regex regex3, Regex regex4, int n, Object object) {
        if ((n & 1) != 0) {
            string = regexLinuxDistroInfoProvider.filename;
        }
        if ((n & 2) != 0) {
            regex = regexLinuxDistroInfoProvider.idRegex;
        }
        if ((n & 4) != 0) {
            regex2 = regexLinuxDistroInfoProvider.versionRegex;
        }
        if ((n & 8) != 0) {
            regex3 = regexLinuxDistroInfoProvider.nameRegex;
        }
        if ((n & 0x10) != 0) {
            regex4 = regexLinuxDistroInfoProvider.prettyNameRegex;
        }
        return regexLinuxDistroInfoProvider.copy(string, regex, regex2, regex3, regex4);
    }

    @NotNull
    public String toString() {
        return "RegexLinuxDistroInfoProvider(filename=" + this.filename + ", idRegex=" + this.idRegex + ", versionRegex=" + this.versionRegex + ", nameRegex=" + this.nameRegex + ", prettyNameRegex=" + this.prettyNameRegex + ")";
    }

    public int hashCode() {
        int result2 = this.filename.hashCode();
        result2 = result2 * 31 + this.idRegex.hashCode();
        result2 = result2 * 31 + this.versionRegex.hashCode();
        result2 = result2 * 31 + (this.nameRegex == null ? 0 : this.nameRegex.hashCode());
        result2 = result2 * 31 + (this.prettyNameRegex == null ? 0 : this.prettyNameRegex.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RegexLinuxDistroInfoProvider)) {
            return false;
        }
        RegexLinuxDistroInfoProvider regexLinuxDistroInfoProvider = (RegexLinuxDistroInfoProvider)other;
        if (!Intrinsics.areEqual((Object)this.filename, (Object)regexLinuxDistroInfoProvider.filename)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.idRegex, (Object)regexLinuxDistroInfoProvider.idRegex)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.versionRegex, (Object)regexLinuxDistroInfoProvider.versionRegex)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.nameRegex, (Object)regexLinuxDistroInfoProvider.nameRegex)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.prettyNameRegex, (Object)regexLinuxDistroInfoProvider.prettyNameRegex);
    }
}

