/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.Point;
import com.jetbrains.toolbox.Size;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Rect {
    private final int left;
    private final int top;
    private final int right;
    private final int bottom;

    public Rect(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public final int getLeft() {
        return this.left;
    }

    public final int getTop() {
        return this.top;
    }

    public final int getRight() {
        return this.right;
    }

    public final int getBottom() {
        return this.bottom;
    }

    public Rect(@NotNull Point origin, @NotNull Size size) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        this(origin.getX(), origin.getY(), origin.getX() + size.getWidth(), origin.getY() + size.getHeight());
    }

    public final int getWidth() {
        return this.right - this.left;
    }

    public final int getHeight() {
        return this.bottom - this.top;
    }

    @NotNull
    public String toString() {
        return "Rect(left=" + this.left + ", top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.left);
        result2 = result2 * 31 + Integer.hashCode(this.top);
        result2 = result2 * 31 + Integer.hashCode(this.right);
        result2 = result2 * 31 + Integer.hashCode(this.bottom);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rect)) {
            return false;
        }
        Rect rect = (Rect)other;
        if (this.left != rect.left) {
            return false;
        }
        if (this.top != rect.top) {
            return false;
        }
        if (this.right != rect.right) {
            return false;
        }
        return this.bottom == rect.bottom;
    }
}

