/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.OSKt;
import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.interop.LibC;
import com.jetbrains.toolbox.interop.Win32Nls;
import com.jetbrains.toolbox.platform.CpuArch;
import com.jetbrains.toolbox.platform.Platform;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.nio.charset.Charset;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class OS {
    @NotNull
    public static final OS INSTANCE;
    @NotNull
    private static final String kernelName;
    @NotNull
    private static final String type;
    private static final long PID;
    @NotNull
    private static final Lazy cpuArch$delegate;
    @NotNull
    private static final Lazy isMacArm$delegate;
    @NotNull
    private static final Lazy isWindowsArm$delegate;
    @NotNull
    private static final String xdgCurrentDesktop;
    @NotNull
    private static final String xdgSessionType;
    private static final boolean isLinuxWayland;
    @NotNull
    private static final Lazy systemCharset$delegate;

    private OS() {
    }

    @NotNull
    public final String getKernelName() {
        return kernelName;
    }

    @NotNull
    public final String getFullKernelVersion() {
        String string = System.getProperty("os.version");
        if (string == null) {
            string = "Unknown OS Version";
        }
        return string;
    }

    @NotNull
    public final String getKernelVersion-Y_E1uuk() {
        return BuildNumber.constructor-impl(this.getFullKernelVersion());
    }

    @NotNull
    public final String getNameAndVersion() {
        String result2 = kernelName + " " + this.getFullKernelVersion();
        if (com.jetbrains.toolbox.common.platform.OS.INSTANCE.isLinux() && !Intrinsics.areEqual((Object)OSKt.getLinuxOsReleaseInfo(), (Object)OSKt.getUnknownLinuxDistro())) {
            return OSKt.getLinuxOsReleaseInfo().getId() + " " + OSKt.getLinuxOsReleaseInfo().getVersion() + " (" + result2 + ")";
        }
        if (com.jetbrains.toolbox.common.platform.OS.INSTANCE.isWindows()) {
            Object object = System.getProperty("os.name");
            if (object == null) {
                object = result2;
            }
            return object;
        }
        return result2;
    }

    @NotNull
    public final String getType() {
        return type;
    }

    public final long getPID() {
        return PID;
    }

    @NotNull
    public final String getCpuArch() {
        Lazy lazy = cpuArch$delegate;
        return (String)lazy.getValue();
    }

    public final boolean isMacArm() {
        Lazy lazy = isMacArm$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final String getXdgCurrentDesktop() {
        return xdgCurrentDesktop;
    }

    @NotNull
    public final String getGlibcVersion-Y_E1uuk() {
        String string;
        if (com.jetbrains.toolbox.common.platform.OS.INSTANCE.isLinux()) {
            String string2;
            try {
                string2 = BuildNumber.constructor-impl(LibC.Companion.getINSTANCE().gnu_get_libc_version());
            }
            catch (Throwable t2) {
                Logger.INSTANCE.error(t2, "Unable to get glibc version");
                string2 = BuildNumber.Companion.getZERO-Y_E1uuk();
            }
            string = string2;
        } else {
            string = BuildNumber.Companion.getZERO-Y_E1uuk();
        }
        return string;
    }

    @Nullable
    public final Path getApplicationExecutable(@NotNull OS.Type os) {
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        return switch (WhenMappings.$EnumSwitchMapping$0[os.ordinal()]) {
            case 3 -> {
                int pid = Kernel32.INSTANCE.GetCurrentProcessId();
                WinNT.HANDLE h = Kernel32.INSTANCE.OpenProcess(1024, false, pid);
                char[] path = new char[260];
                IntByReference size = new IntByReference(path.length);
                Kernel32.INSTANCE.QueryFullProcessImageName(h, 0, path, size);
                Kernel32.INSTANCE.CloseHandle(h);
                String executable = new String(path, 0, size.getValue());
                yield Path.Companion.get$default((Path.Companion)Path.Companion, (String)executable, (boolean)false, (int)1, null);
            }
            case 2 -> StandardPaths.INSTANCE.getApplicationFile();
            case 1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ Path getApplicationExecutable$default(OS oS, OS.Type type2, int n, Object object) {
        if ((n & 1) != 0) {
            type2 = com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType();
        }
        return oS.getApplicationExecutable(type2);
    }

    @NotNull
    public final Charset getSystemCharset() {
        Lazy lazy = systemCharset$delegate;
        return (Charset)lazy.getValue();
    }

    private static final String cpuArch_delegate$lambda$0() {
        return switch (WhenMappings.$EnumSwitchMapping$1[Platform.INSTANCE.getCpuArch().ordinal()]) {
            case 1 -> "arm64";
            case 2 -> "x64";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final boolean isMacArm_delegate$lambda$1() {
        return com.jetbrains.toolbox.common.platform.OS.INSTANCE.isMac() && Platform.INSTANCE.getCpuArch() == CpuArch.ARM64;
    }

    private static final boolean isWindowsArm_delegate$lambda$2() {
        return com.jetbrains.toolbox.common.platform.OS.INSTANCE.isWindows() && Platform.INSTANCE.getCpuArch() == CpuArch.ARM64;
    }

    private static final Charset systemCharset_delegate$lambda$3() {
        Charset charset;
        if (com.jetbrains.toolbox.common.platform.OS.INSTANCE.isWindows()) {
            int acp = Win32Nls.Companion.getINSTANCE().GetACP();
            if (acp == 65001) {
                return Charsets.UTF_8;
            }
            String[] stringArray = new String[]{"windows-", "x-windows-", "x-mswin-", "IBM", "x-IBM"};
            for (String prefix : stringArray) {
                try {
                    Charset charset2 = Charset.forName(prefix + acp);
                    Logger.INSTANCE.info("Using charset " + charset2 + " for ACP " + acp);
                    Intrinsics.checkNotNull((Object)charset2);
                    return charset2;
                }
                catch (Exception exception) {
                }
            }
            charset = Charset.defaultCharset();
        } else {
            charset = Charset.defaultCharset();
        }
        Charset charset3 = charset;
        Intrinsics.checkNotNull((Object)charset3);
        return charset3;
    }

    static {
        String string;
        INSTANCE = new OS();
        kernelName = switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
            case 1 -> "Linux";
            case 2 -> "macOS";
            case 3 -> "Windows";
            default -> throw new NoWhenBranchMatchedException();
        };
        type = switch (WhenMappings.$EnumSwitchMapping$0[com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType().ordinal()]) {
            case 1 -> "linux";
            case 2 -> "macOS";
            case 3 -> "windows";
            default -> throw new NoWhenBranchMatchedException();
        };
        PID = ProcessHandle.current().pid();
        cpuArch$delegate = LazyKt.lazy(OS::cpuArch_delegate$lambda$0);
        isMacArm$delegate = LazyKt.lazy(OS::isMacArm_delegate$lambda$1);
        isWindowsArm$delegate = LazyKt.lazy(OS::isWindowsArm_delegate$lambda$2);
        String string2 = System.getenv("XDG_CURRENT_DESKTOP");
        if (string2 == null) {
            string2 = xdgCurrentDesktop = "";
        }
        if ((string = System.getenv("XDG_SESSION_TYPE")) == null) {
            string = "";
        }
        xdgSessionType = string;
        isLinuxWayland = StringsKt.contains$default((CharSequence)xdgSessionType, (CharSequence)"wayland", (boolean)false, (int)2, null);
        systemCharset$delegate = LazyKt.lazy(OS::systemCharset_delegate$lambda$3);
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Mac.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CpuArch.values().length];
            try {
                nArray[CpuArch.ARM64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.X86_64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

