/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.Notifications;
import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.UIEvent;
import com.jetbrains.toolbox.UIGlobalState;
import com.jetbrains.toolbox.WindowManager;
import com.jetbrains.toolbox.interop.Foundation;
import com.jetbrains.toolbox.interop.ID;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class NotificationsMac
implements Notifications {
    @NotNull
    private final UIGlobalState uiGlobalState;
    @NotNull
    private final WindowManager windowManager;

    public NotificationsMac(@NotNull UIGlobalState uiGlobalState, @NotNull WindowManager windowManager) {
        Intrinsics.checkNotNullParameter((Object)uiGlobalState, (String)"uiGlobalState");
        Intrinsics.checkNotNullParameter((Object)windowManager, (String)"windowManager");
        this.uiGlobalState = uiGlobalState;
        this.windowManager = windowManager;
    }

    private final Object showNotification(String message2, Continuation<? super Unit> $completion) {
        Object[] objectArray;
        Logger.INSTANCE.info("Show notification '" + message2 + "' (inApp=" + this.windowManager.isWindowFocused().getValue() + ")");
        if (((Boolean)this.windowManager.isWindowFocused().getValue()).booleanValue()) {
            Object object = this.uiGlobalState.processEvent(new UIEvent.InAppNotification(message2), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        ID notification2 = Foundation.invoke(Foundation.getClass("NSUserNotification"), "new", new Object[0]);
        if (BuildNumber.compareTo-Szkhn3Q(OS.INSTANCE.getKernelVersion-Y_E1uuk(), BuildNumber.constructor-impl("10.16")) < 0) {
            objectArray = new Object[]{Foundation.nsString("JetBrains Toolbox")};
            Foundation.invoke(notification2, "setTitle:", objectArray);
        }
        objectArray = new Object[]{Foundation.nsString(StringsKt.replace$default((String)message2, (String)"%", (String)"%%", (boolean)false, (int)4, null))};
        Foundation.invoke(notification2, "setInformativeText:", objectArray);
        ID center = Foundation.invoke(Foundation.getClass("NSUserNotificationCenter"), "defaultUserNotificationCenter", new Object[0]);
        Object[] objectArray2 = new Object[]{notification2};
        Foundation.invoke(center, "deliverNotification:", objectArray2);
        Foundation.invoke(notification2, "release", new Object[0]);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object showInfoMessage(@NotNull String message2, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.showNotification(message2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object showErrorMessage(@NotNull String message2, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.showNotification(message2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

