/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.StandardPathsKt;
import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import com.jetbrains.toolbox.common.io.FileExtensionsKt;
import java.io.File;
import java.util.Comparator;
import java.util.concurrent.CancellationException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nLogging.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logging.kt\ncom/jetbrains/toolbox/LoggingKt\n+ 2 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n7#2,7:67\n7#2,7:76\n7#2,7:85\n7#2,7:93\n622#3:74\n1321#3:75\n1322#3:83\n1321#3:84\n1322#3:92\n1#4:100\n*S KotlinDebug\n*F\n+ 1 Logging.kt\ncom/jetbrains/toolbox/LoggingKt\n*L\n14#1:67,7\n33#1:76,7\n40#1:85,7\n25#1:93,7\n29#1:74\n31#1:75\n31#1:83\n38#1:84\n38#1:92\n*E\n"})
public final class LoggingKt {
    public static final void cleanupLogsFolder(@NotNull File dir) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        ThreadGuardKt.assertNotMainThread("java.io.File.canonicalPath|lastModified|delete()");
        boolean $i$f$catching = false;
        try {
            boolean bl = false;
            FileExtensionsKt.div(dir, "toolbox-oom-" + ProcessHandle.current().pid() + ".hprof").delete();
            object = Result.constructor-impl((Object)FileExtensionsKt.div(dir, "toolbox-error-" + ProcessHandle.current().pid() + ".log").delete());
        }
        catch (CancellationException c$iv) {
            throw c$iv;
        }
        catch (Throwable t$iv) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
        }
        Regex toolboxLogRegex = new Regex("toolbox\\..*\\.log");
        try {
            Object object2;
            boolean $i$f$catching2;
            Pair it;
            Sequence allLogFiles = SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)((Sequence)FilesKt.walkBottomUp((File)dir)), arg_0 -> LoggingKt.cleanupLogsFolder$lambda$1(toolboxLogRegex, arg_0)), LoggingKt::cleanupLogsFolder$lambda$4);
            Sequence $this$sortedByDescending$iv = SequencesKt.filter((Sequence)allLogFiles, LoggingKt::cleanupLogsFolder$lambda$5);
            boolean $i$f$sortedByDescending = false;
            Sequence $this$forEach$iv = SequencesKt.drop((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)b;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Instant)it.getSecond());
                    it = (Pair)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Instant)it.getSecond())));
                }
            }), (int)2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Pair)element$iv;
                boolean bl = false;
                Logger.INSTANCE.info("Removing stale memory dump: " + it.getFirst() + "...");
                $i$f$catching2 = false;
                try {
                    boolean bl2 = false;
                    object2 = Result.constructor-impl((Object)((File)it.getFirst()).delete());
                }
                catch (CancellationException c$iv) {
                    throw c$iv;
                }
                catch (Throwable t$iv) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
                }
            }
            $this$forEach$iv = SequencesKt.filter((Sequence)allLogFiles, LoggingKt::cleanupLogsFolder$lambda$9);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Pair)element$iv;
                boolean bl = false;
                Logger.INSTANCE.info("Removing stale file under logs: " + it.getFirst() + "...");
                $i$f$catching2 = false;
                try {
                    boolean bl3 = false;
                    object2 = Result.constructor-impl((Object)((File)it.getFirst()).delete());
                }
                catch (CancellationException c$iv) {
                    throw c$iv;
                }
                catch (Throwable t$iv) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
                }
            }
            LoggingKt.cleanupOldStdOutputFiles();
        }
        catch (Throwable t2) {
            Logger.INSTANCE.warn(t2, "Failed to cleanup logs dir. " + t2.getMessage());
        }
    }

    public static final void cleanupOldStdOutputFiles() {
        ThreadGuardKt.assertNotMainThread("java.io.File.lastModified|delete()|listFiles()");
        try {
            File[] fileArray = StandardPathsKt.getLogsDirectory().toFile().listFiles();
            if (fileArray == null) {
                fileArray = new File[]{};
            }
            for (File file : fileArray) {
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.endsWith((String)string, (String)"-stderr.txt", (boolean)true)) {
                    String string2 = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    if (!StringsKt.endsWith((String)string2, (String)"-stdout.txt", (boolean)true)) continue;
                }
                if (Clock.System.INSTANCE.now().toEpochMilliseconds() - file.lastModified() <= 172800L) continue;
                Logger.INSTANCE.debug("Standard output file '" + file + "' is too old, deleting it");
                if (file.delete()) continue;
                Logger.INSTANCE.info("Unable to delete standard output file '" + file + "', probably it's still in use");
            }
        }
        catch (Throwable t2) {
            Logger.INSTANCE.warn(t2, "Failed to cleanup logs directory");
        }
    }

    private static final boolean cleanupLogsFolder$lambda$1(Regex $toolboxLogRegex, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
        return $toolboxLogRegex.containsMatchIn((CharSequence)string);
    }

    private static final Pair cleanupLogsFolder$lambda$4(File it) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        File file = it;
        boolean $i$f$catching = false;
        try {
            boolean bl = false;
            object2 = Result.constructor-impl((Object)Instant.Companion.fromEpochMilliseconds(it.lastModified()));
        }
        catch (CancellationException c$iv) {
            throw c$iv;
        }
        catch (Throwable t$iv) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
        }
        File file2 = file;
        Object object3 = object2;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable == null) {
            object = object3;
        } else {
            t$iv = throwable;
            file = file2;
            boolean bl = false;
            object = Clock.System.INSTANCE.now();
            file2 = file;
        }
        return TuplesKt.to((Object)file2, (Object)object);
    }

    private static final boolean cleanupLogsFolder$lambda$5(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = ((File)it.getFirst()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.endsWith$default((String)string, (String)".hprof", (boolean)false, (int)2, null);
    }

    private static final boolean cleanupLogsFolder$lambda$9(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Duration.compareTo-LRDsOJo((long)Clock.System.INSTANCE.now().minus-5sfh64U((Instant)it.getSecond()), (long)DurationKt.toDuration((int)14, (DurationUnit)DurationUnit.DAYS)) > 0;
    }
}

