/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.ApplicationsRefresher;
import com.jetbrains.toolbox.EnvironmentViewManager;
import com.jetbrains.toolbox.EnvironmentViewManagerFactory;
import com.jetbrains.toolbox.EnvironmentViewManagerImpl;
import com.jetbrains.toolbox.UIGlobalState;
import com.jetbrains.toolbox.UILicenseAgreementManager;
import com.jetbrains.toolbox.enterprise.EnterpriseConfigManager;
import com.jetbrains.toolbox.enterprise.settings.EnterpriseToolboxSettingsProvider;
import com.jetbrains.toolbox.gateway.DevEnvironment;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.DevEnvironmentManager;
import com.jetbrains.toolbox.gateway.log.RemoteDevLogArchiveCollector;
import com.jetbrains.toolbox.gateway.utils.DevEnvironmentManagerExtensions;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.integration.OSIntegrationManager;
import com.jetbrains.toolbox.licensing.LicenseInfoProvider;
import com.jetbrains.toolbox.manager.SnackbarManager;
import com.jetbrains.toolbox.settings.SettingsManager;
import com.jetbrains.toolbox.tools.LicenseAgreementManager;
import com.jetbrains.toolbox.viewmodel.dialogs.DialogManagerImpl;
import com.jetbrains.toolbox.viewmodel.gateway.ToolInstallationDialog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.KotlinNothingValueException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnvironmentViewManagerFactoryImpl
implements EnvironmentViewManagerFactory {
    @NotNull
    private final DevEnvironmentManager devEnvironmentManager;
    @NotNull
    private final SnackbarManager snackbarManager;
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final EnterpriseToolboxSettingsProvider enterpriseToolboxSettingsProvider;
    @NotNull
    private final RemoteDevLogArchiveCollector remoteDevLogArchiveCollector;
    @NotNull
    private final OSIntegrationManager osIntegrationManager;
    @NotNull
    private final UIGlobalState uiGlobalState;
    @NotNull
    private final StateFlow<I18n> i18nState;
    @NotNull
    private final LicenseInfoProvider licenseInfoProvider;
    @NotNull
    private final ApplicationsRefresher applicationsRefresher;
    @NotNull
    private final EnterpriseConfigManager enterpriseConfigManager;
    @NotNull
    private final Clock clock;
    @NotNull
    private final UILicenseAgreementManager uiLicenseAgreementManager;
    @NotNull
    private final ToolInstallationDialog toolInstallationDialog;
    @NotNull
    private final ConcurrentHashMap<DevEnvironment, EnvironmentViewManager> cache;

    public EnvironmentViewManagerFactoryImpl(@NotNull DevEnvironmentManager devEnvironmentManager, @NotNull SnackbarManager snackbarManager, @NotNull DialogManagerImpl dialogManager, @NotNull SettingsManager settingsManager, @NotNull EnterpriseToolboxSettingsProvider enterpriseToolboxSettingsProvider, @NotNull LicenseAgreementManager licenseAgreementManager, @NotNull RemoteDevLogArchiveCollector remoteDevLogArchiveCollector, @NotNull OSIntegrationManager osIntegrationManager, @NotNull UIGlobalState uiGlobalState, @NotNull StateFlow<? extends I18n> i18nState, @NotNull LicenseInfoProvider licenseInfoProvider, @NotNull ApplicationsRefresher applicationsRefresher, @NotNull EnterpriseConfigManager enterpriseConfigManager, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)devEnvironmentManager, (String)"devEnvironmentManager");
        Intrinsics.checkNotNullParameter((Object)snackbarManager, (String)"snackbarManager");
        Intrinsics.checkNotNullParameter((Object)dialogManager, (String)"dialogManager");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)enterpriseToolboxSettingsProvider, (String)"enterpriseToolboxSettingsProvider");
        Intrinsics.checkNotNullParameter((Object)licenseAgreementManager, (String)"licenseAgreementManager");
        Intrinsics.checkNotNullParameter((Object)remoteDevLogArchiveCollector, (String)"remoteDevLogArchiveCollector");
        Intrinsics.checkNotNullParameter((Object)osIntegrationManager, (String)"osIntegrationManager");
        Intrinsics.checkNotNullParameter((Object)uiGlobalState, (String)"uiGlobalState");
        Intrinsics.checkNotNullParameter(i18nState, (String)"i18nState");
        Intrinsics.checkNotNullParameter((Object)licenseInfoProvider, (String)"licenseInfoProvider");
        Intrinsics.checkNotNullParameter((Object)applicationsRefresher, (String)"applicationsRefresher");
        Intrinsics.checkNotNullParameter((Object)enterpriseConfigManager, (String)"enterpriseConfigManager");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.devEnvironmentManager = devEnvironmentManager;
        this.snackbarManager = snackbarManager;
        this.settingsManager = settingsManager;
        this.enterpriseToolboxSettingsProvider = enterpriseToolboxSettingsProvider;
        this.remoteDevLogArchiveCollector = remoteDevLogArchiveCollector;
        this.osIntegrationManager = osIntegrationManager;
        this.uiGlobalState = uiGlobalState;
        this.i18nState = i18nState;
        this.licenseInfoProvider = licenseInfoProvider;
        this.applicationsRefresher = applicationsRefresher;
        this.enterpriseConfigManager = enterpriseConfigManager;
        this.clock = clock;
        this.uiLicenseAgreementManager = new UILicenseAgreementManager(this.uiGlobalState, licenseAgreementManager);
        this.toolInstallationDialog = new ToolInstallationDialog(dialogManager, this.snackbarManager, this.i18nState);
        this.cache = new ConcurrentHashMap();
    }

    @Override
    @Nullable
    public EnvironmentViewManager create(@NotNull DevEnvironmentId devEnvironmentId) {
        Intrinsics.checkNotNullParameter((Object)devEnvironmentId, (String)"devEnvironmentId");
        DevEnvironment devEnvironment = DevEnvironmentManagerExtensions.INSTANCE.findEnvironment(this.devEnvironmentManager, devEnvironmentId);
        if (devEnvironment == null) {
            return null;
        }
        DevEnvironment environment = devEnvironment;
        EnvironmentViewManager environmentViewManager = this.cache.get(environment);
        if (environmentViewManager == null) {
            Object object = this.snackbarManager;
            UILicenseAgreementManager uILicenseAgreementManager = this.uiLicenseAgreementManager;
            RemoteDevLogArchiveCollector remoteDevLogArchiveCollector = this.remoteDevLogArchiveCollector;
            OSIntegrationManager oSIntegrationManager = this.osIntegrationManager;
            SettingsManager settingsManager = this.settingsManager;
            EnterpriseToolboxSettingsProvider enterpriseToolboxSettingsProvider = this.enterpriseToolboxSettingsProvider;
            StateFlow<I18n> stateFlow = this.i18nState;
            UIGlobalState uIGlobalState = this.uiGlobalState;
            ToolInstallationDialog toolInstallationDialog = this.toolInstallationDialog;
            LicenseInfoProvider licenseInfoProvider = this.licenseInfoProvider;
            ApplicationsRefresher applicationsRefresher = this.applicationsRefresher;
            EnterpriseConfigManager enterpriseConfigManager = this.enterpriseConfigManager;
            Clock clock = this.clock;
            Object it = object = new EnvironmentViewManagerImpl(devEnvironmentId, environment, (SnackbarManager)object, uILicenseAgreementManager, remoteDevLogArchiveCollector, oSIntegrationManager, settingsManager, enterpriseToolboxSettingsProvider, toolInstallationDialog, applicationsRefresher, stateFlow, uIGlobalState, licenseInfoProvider, enterpriseConfigManager, clock);
            boolean bl = false;
            ((Map)this.cache).put(environment, it);
            BuildersKt.launch$default((CoroutineScope)environment.getEnvironmentScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, environment, null){
                int label;
                final /* synthetic */ EnvironmentViewManagerFactoryImpl this$0;
                final /* synthetic */ DevEnvironment $environment;
                {
                    this.this$0 = $receiver;
                    this.$environment = $environment;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = DelayKt.awaitCancellation((Continuation)((Continuation)this));
                            if (object2 != object) throw new KotlinNothingValueException();
                            return object;
                        }
                        case 1: {
                            Object object2;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                object2 = $result;
                                throw new KotlinNothingValueException();
                            }
                            catch (Throwable throwable) {
                                EnvironmentViewManagerFactoryImpl.access$getCache$p(this.this$0).remove(this.$environment);
                                throw throwable;
                            }
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            environmentViewManager = (EnvironmentViewManager)object;
        }
        return environmentViewManager;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getCache$p(EnvironmentViewManagerFactoryImpl $this) {
        return $this.cache;
    }
}

