/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox;

import com.jetbrains.toolbox.ApplicationStartInfo;
import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.CommandLine;
import com.jetbrains.toolbox.common.extensions.StringExtensionsKt;
import com.jetbrains.toolbox.enterprise.EnterpriseIntelliJAuthRequest;
import com.jetbrains.toolbox.settings.GraphicsApi;
import java.util.Arrays;
import java.util.Locale;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nCommandLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandLine.kt\ncom/jetbrains/toolbox/CommandLine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n295#2,2:74\n1869#2,2:76\n*S KotlinDebug\n*F\n+ 1 CommandLine.kt\ncom/jetbrains/toolbox/CommandLine\n*L\n51#1:74,2\n56#1:76,2\n*E\n"})
public final class CommandLine
implements ApplicationStartInfo {
    @NotNull
    private final String[] arguments;

    public CommandLine(@NotNull String[] arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        this.arguments = arguments;
    }

    @Override
    @NotNull
    public String[] getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isTrace() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--trace");
    }

    public boolean isDebug() {
        return this.isTrace() || ArraysKt.contains((Object[])this.getArguments(), (Object)"--debug");
    }

    public final boolean isMinimize() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--minimize") || this.getEnterpriseAuthRequest() != null;
    }

    public final boolean isUpdateFailed() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--update-failed");
    }

    public final boolean isForceAutostartIntegration() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--force-autostart-integration");
    }

    public final boolean isUninstallMode() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--uninstall");
    }

    public final boolean isInstallMode() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--install");
    }

    public final boolean isIntegrateIntoSystem() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--integrate-into-system");
    }

    @Nullable
    public final Path getInstallTarget() {
        String string = this.getArgumentValue(this.getArguments(), "--install-target");
        return string != null && (string = StringExtensionsKt.getNullIfBlank(string)) != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null) : null;
    }

    @Nullable
    public final Path getInstallSource() {
        String string = this.getArgumentValue(this.getArguments(), "--install-source");
        return string != null && (string = StringExtensionsKt.getNullIfBlank(string)) != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null) : null;
    }

    public final long getWaitForPid() {
        Long l = (Long)this.getArgumentValue(this.getArguments(), "--wait-for-pid", CommandLine::_get_waitForPid_$lambda$0);
        return l != null ? l : 0L;
    }

    public final boolean isSelfCheck() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--self-check");
    }

    @Nullable
    public final String getInstallCommand() {
        return this.getArgumentValue(this.getArguments(), "--install-command");
    }

    @Nullable
    public final String getEuaVersionAccepted-12qw-PM() {
        BuildNumber buildNumber = (BuildNumber)this.getArgumentValue(this.getArguments(), "--eua-version-accepted", euaVersionAccepted.1.INSTANCE);
        return buildNumber != null ? buildNumber.unbox-impl() : null;
    }

    public final boolean isOnboardingFinished() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--onboarding-finished");
    }

    public final boolean getCopySettingsToDev() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--copy-settings-to-dev");
    }

    public final boolean isStatisticsAllowed() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--statistics-allowed");
    }

    @Nullable
    public final Boolean getAutoUpdate() {
        return (Boolean)this.getArgumentValue(this.getArguments(), "--auto-update", CommandLine::_get_autoUpdate_$lambda$1);
    }

    public final boolean getDisableStdioLogging() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--disable-stdio-logging");
    }

    @Nullable
    public final Long getIdeDaemonPid() {
        return (Long)this.getArgumentValue(this.getArguments(), "--daemon-for-ide", CommandLine::_get_ideDaemonPid_$lambda$2);
    }

    @Nullable
    public final EnterpriseIntelliJAuthRequest getEnterpriseAuthRequest() {
        String string = this.getArgumentValue(this.getArguments(), "--enterprise-auth-token");
        if (string == null) {
            return null;
        }
        String token2 = string;
        String string2 = this.getArgumentValue(this.getArguments(), "--enterprise-auth-callback");
        if (string2 == null) {
            return null;
        }
        String callbackUrl = string2;
        String string3 = this.getArgumentValue(this.getArguments(), "--enterprise-auth-callback-token");
        if (string3 == null) {
            return null;
        }
        String callbackToken = string3;
        boolean requireNew = ArraysKt.contains((Object[])this.getArguments(), (Object)"--enterprise-require-new-token");
        return new EnterpriseIntelliJAuthRequest(token2, callbackUrl, callbackToken, requireNew);
    }

    public final boolean getGateway() {
        return ArraysKt.contains((Object[])this.getArguments(), (Object)"--enable-gateway");
    }

    @Nullable
    public final GraphicsApi getGraphicsApi() {
        return (GraphicsApi)((Object)this.getArgumentValue(this.getArguments(), "--graphics-api", CommandLine::_get_graphicsApi_$lambda$5));
    }

    private final String getArgumentValue(String[] arguments, String arg) {
        return (String)this.getArgumentValue(arguments, arg, CommandLine::getArgumentValue$lambda$6);
    }

    private final <T> T getArgumentValue(String[] arguments, String arg, Function1<? super String, ? extends T> convert2) {
        int idx = ArraysKt.indexOf((Object[])arguments, (Object)arg);
        return (T)(0 <= idx && idx < arguments.length - 1 ? convert2.invoke((Object)arguments[idx + 1]) : null);
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.getArguments());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Long _get_waitForPid_$lambda$0(String it) {
        String string = it;
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    private static final Boolean _get_autoUpdate_$lambda$1(String it) {
        String string = it;
        return string != null ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
    }

    private static final Long _get_ideDaemonPid_$lambda$2(String it) {
        String string = it;
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    private static final GraphicsApi _get_graphicsApi_$lambda$5(String name2) {
        Object v4;
        GraphicsApi it;
        block5: {
            Iterable $this$firstOrNull$iv = GraphicsApi.Companion.getAVAILABLE();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String string;
                it = (GraphicsApi)((Object)element$iv);
                boolean bl = false;
                String string2 = it.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                String string3 = name2;
                if (string3 != null) {
                    String string4 = string3.toLowerCase(Locale.ROOT);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                } else {
                    string = null;
                }
                if (!Intrinsics.areEqual((Object)string2, (Object)string)) continue;
                v4 = element$iv;
                break block5;
            }
            v4 = null;
        }
        GraphicsApi res2 = v4;
        if (name2 != null && res2 == null) {
            System.out.println((Object)("Ignoring invalid --graphics-api value: " + name2));
            System.out.println((Object)"Valid values are:");
            Iterable $this$forEach$iv = GraphicsApi.Companion.getAVAILABLE();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (GraphicsApi)((Object)element$iv);
                boolean bl = false;
                System.out.println((Object)("  " + it.name()));
            }
        }
        return res2;
    }

    private static final String getArgumentValue$lambda$6(String it) {
        return it;
    }
}

