/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rhizomedb;

import com.jetbrains.rhizomedb.APIKt;
import com.jetbrains.rhizomedb.Attribute;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.ChangeScopeKt;
import com.jetbrains.rhizomedb.DBUtilKt;
import com.jetbrains.rhizomedb.Datom;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityKt;
import com.jetbrains.rhizomedb.IndexQuery;
import com.jetbrains.rhizomedb.Instruction;
import com.jetbrains.rhizomedb.InstructionEffect;
import com.jetbrains.rhizomedb.InstructionExpansion;
import com.jetbrains.rhizomedb.Mut;
import com.jetbrains.rhizomedb.Op;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.RetractableEntity;
import com.jetbrains.rhizomedb.Schema;
import fleet.fastutil.ints.IntArrayList;
import fleet.fastutil.ints.IntListExtensionsKt;
import fleet.fastutil.ints.IntOpenHashSet;
import fleet.fastutil.ints.IntSetExtensionsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nInstructions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Instructions.kt\ncom/jetbrains/rhizomedb/RetractEntityInPartition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1869#2,2:168\n1869#2,2:170\n*S KotlinDebug\n*F\n+ 1 Instructions.kt\ncom/jetbrains/rhizomedb/RetractEntityInPartition\n*L\n134#1:168,2\n143#1:170,2\n*E\n"})
public final class RetractEntityInPartition
implements Instruction {
    private final int eid;
    private final long seed;

    public RetractEntityInPartition(int eid2, long seed) {
        this.eid = eid2;
        this.seed = seed;
    }

    public final int getEid() {
        return this.eid;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    @NotNull
    public InstructionExpansion expand(@NotNull DbContext<? extends Q> $this$expand) {
        Intrinsics.checkNotNullParameter($this$expand, (String)"<this>");
        ArrayList<Op.Retract> res2 = new ArrayList<Op.Retract>();
        IntOpenHashSet retractedEntities = new IntOpenHashSet(0, 0.0f, 3, null);
        IntArrayList entitiesToRetract = new IntArrayList();
        entitiesToRetract.add(this.eid);
        while (IntListExtensionsKt.isNotEmpty(entitiesToRetract)) {
            Datom datom;
            int nextEID = entitiesToRetract.removeAt(entitiesToRetract.getSize() - 1);
            if (!retractedEntities.add(nextEID)) continue;
            Iterable $this$forEach$iv = (Iterable)DBUtilKt.queryIndex($this$expand, new IndexQuery.Entity(nextEID));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                datom = (Datom)element$iv;
                boolean bl = false;
                if (Schema.getCascadeDelete-impl(Attribute.getSchema-HLBllEs(datom.getAttr-dkwPBow()))) {
                    Object object = datom.getValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                    int value2 = (Integer)object;
                    if (APIKt.partition(value2) == APIKt.partition(this.eid)) {
                        entitiesToRetract.add(value2);
                    }
                }
                res2.add(new Op.Retract(datom.getEid(), datom.getAttr-dkwPBow(), datom.getValue(), null));
            }
            $this$forEach$iv = (Iterable)DBUtilKt.queryIndex($this$expand, new IndexQuery.RefsTo(nextEID, null, 2, null));
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                datom = (Datom)element$iv;
                boolean bl = false;
                if ((Schema.getCascadeDeleteBy-impl(Attribute.getSchema-HLBllEs(datom.getAttr-dkwPBow())) || Schema.getRequired-impl(Attribute.getSchema-HLBllEs(datom.getAttr-dkwPBow()))) && APIKt.partition(datom.getEid()) == APIKt.partition(this.eid)) {
                    entitiesToRetract.add(datom.getEid());
                }
                res2.add(new Op.Retract(datom.getEid(), datom.getAttr-dkwPBow(), datom.getValue(), null));
            }
        }
        return new InstructionExpansion((List<? extends Op>)res2, IntSetExtensionsKt.mapNotNull(retractedEntities, (Function1)new Function1<Integer, InstructionEffect>(this){
            final /* synthetic */ RetractEntityInPartition this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final InstructionEffect invoke(int it) {
                InstructionEffect instructionEffect;
                Entity entity = EntityKt.entity(it);
                Object object = entity instanceof RetractableEntity ? (RetractableEntity)entity : null;
                if (object != null && (object = object.onRetract()) != null) {
                    Object object2 = object;
                    RetractEntityInPartition retractEntityInPartition = this.this$0;
                    Object cb = object2;
                    boolean bl = false;
                    instructionEffect = new InstructionEffect(retractEntityInPartition, (Function1<? super DbContext<? extends Mut>, Unit>)((Function1)new Function1<DbContext<? extends Mut>, Unit>((RetractableEntity.Callback)cb){
                        final /* synthetic */ RetractableEntity.Callback $cb;
                        {
                            this.$cb = $cb;
                            super(1);
                        }

                        public final void invoke(DbContext<? extends Mut> $this$InstructionEffect) {
                            Intrinsics.checkNotNullParameter($this$InstructionEffect, (String)"$this$InstructionEffect");
                            RetractableEntity.Callback $this$invoke_u24lambda_u240 = this.$cb;
                            boolean bl = false;
                            ChangeScopeKt.withChangeScope($this$InstructionEffect, (Function1)new Function1<ChangeScope, Unit>($this$invoke_u24lambda_u240){
                                final /* synthetic */ RetractableEntity.Callback $this_with;
                                {
                                    this.$this_with = $receiver;
                                    super(1);
                                }

                                public final void invoke(ChangeScope $this$withChangeScope) {
                                    Intrinsics.checkNotNullParameter((Object)$this$withChangeScope, (String)"$this$withChangeScope");
                                    this.$this_with.afterRetract($this$withChangeScope);
                                }
                            });
                        }
                    }));
                } else {
                    instructionEffect = null;
                }
                return instructionEffect;
            }
        }));
    }

    @NotNull
    public String toString() {
        return "RetractEntityInPartition(eid=" + this.eid + ", seed=" + this.seed + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.eid);
        result2 = result2 * 31 + Long.hashCode(this.seed);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RetractEntityInPartition)) {
            return false;
        }
        RetractEntityInPartition retractEntityInPartition = (RetractEntityInPartition)other;
        if (this.eid != retractEntityInPartition.eid) {
            return false;
        }
        return this.seed == retractEntityInPartition.seed;
    }
}

