/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rhizomedb;

import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.InstructionEffect;
import com.jetbrains.rhizomedb.InstructionExpansion;
import com.jetbrains.rhizomedb.Op;
import com.jetbrains.rhizomedb.Q;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Instruction {
    public long getSeed();

    @NotNull
    public InstructionExpansion expand(@NotNull DbContext<? extends Q> var1);

    public static final class Const
    implements Instruction {
        private final long seed;
        @NotNull
        private final List<InstructionEffect> effects;
        @NotNull
        private final List<Op> result;

        public Const(long seed, @NotNull List<InstructionEffect> effects, @NotNull List<? extends Op> result2) {
            Intrinsics.checkNotNullParameter(effects, (String)"effects");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            this.seed = seed;
            this.effects = effects;
            this.result = result2;
        }

        @Override
        public long getSeed() {
            return this.seed;
        }

        @Override
        @NotNull
        public InstructionExpansion expand(@NotNull DbContext<? extends Q> $this$expand) {
            Intrinsics.checkNotNullParameter($this$expand, (String)"<this>");
            return new InstructionExpansion(this.result, this.effects);
        }

        @NotNull
        public String toString() {
            return "Const(seed=" + this.seed + ", effects=" + this.effects + ", result=" + this.result + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.seed);
            result2 = result2 * 31 + ((Object)this.effects).hashCode();
            result2 = result2 * 31 + ((Object)this.result).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Const)) {
                return false;
            }
            Const const_ = (Const)other;
            if (this.seed != const_.seed) {
                return false;
            }
            if (!Intrinsics.areEqual(this.effects, const_.effects)) {
                return false;
            }
            return Intrinsics.areEqual(this.result, const_.result);
        }
    }
}

