/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rhizomedb;

import com.jetbrains.rhizomedb.APIKt;
import com.jetbrains.rhizomedb.Attribute;
import com.jetbrains.rhizomedb.Datom;
import com.jetbrains.rhizomedb.Versioned;
import com.jetbrains.rhizomedb.VersionedEID;
import fleet.fastutil.ints.IntList;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class IndexQuery<T> {
    private IndexQuery() {
    }

    public /* synthetic */ IndexQuery(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class All
    extends IndexQuery<Sequence<? extends Datom>> {
        @NotNull
        private final IntList partitions;

        public All(@NotNull IntList partitions) {
            Intrinsics.checkNotNullParameter((Object)partitions, (String)"partitions");
            super(null);
            this.partitions = partitions;
        }

        public /* synthetic */ All(IntList intList, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                intList = APIKt.getAllParts();
            }
            this(intList);
        }

        @NotNull
        public final IntList getPartitions() {
            return this.partitions;
        }

        @NotNull
        public final All copy(@NotNull IntList partitions) {
            Intrinsics.checkNotNullParameter((Object)partitions, (String)"partitions");
            return new All(partitions);
        }

        @NotNull
        public String toString() {
            return "All(partitions=" + this.partitions + ")";
        }

        public int hashCode() {
            return this.partitions.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof All)) {
                return false;
            }
            All all2 = (All)other;
            return Intrinsics.areEqual((Object)this.partitions, (Object)all2.partitions);
        }

        public All() {
            this(null, 1, null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class Column<T>
    extends IndexQuery<List<? extends Datom>> {
        private final int attribute;
        @NotNull
        private final IntList partitions;

        private Column(int attribute, IntList partitions) {
            Intrinsics.checkNotNullParameter((Object)partitions, (String)"partitions");
            super(null);
            this.attribute = attribute;
            this.partitions = partitions;
        }

        public /* synthetic */ Column(int n, IntList intList, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                intList = APIKt.getAllParts();
            }
            this(n, intList, null);
        }

        public final int getAttribute-dkwPBow() {
            return this.attribute;
        }

        @NotNull
        public final IntList getPartitions() {
            return this.partitions;
        }

        @NotNull
        public final Column<T> copy-7LDbe2E(int attribute, @NotNull IntList partitions) {
            Intrinsics.checkNotNullParameter((Object)partitions, (String)"partitions");
            return new Column<T>(attribute, partitions, null);
        }

        public static /* synthetic */ Column copy-7LDbe2E$default(Column column, int n, IntList intList, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = column.attribute;
            }
            if ((n2 & 2) != 0) {
                intList = column.partitions;
            }
            return column.copy-7LDbe2E(n, intList);
        }

        @NotNull
        public String toString() {
            return "Column(attribute=" + Attribute.toString-impl(this.attribute) + ", partitions=" + this.partitions + ")";
        }

        public int hashCode() {
            int result2 = Attribute.hashCode-impl(this.attribute);
            result2 = result2 * 31 + this.partitions.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Column)) {
                return false;
            }
            Column column = (Column)other;
            if (!Attribute.equals-impl0(this.attribute, column.attribute)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.partitions, (Object)column.partitions);
        }

        public /* synthetic */ Column(int attribute, IntList partitions, DefaultConstructorMarker $constructor_marker) {
            this(attribute, partitions);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class Contains<T>
    extends IndexQuery<Long> {
        private final int eid;
        private final int attribute;
        @NotNull
        private final T value;

        private Contains(int eid2, int attribute, T value2) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            super(null);
            this.eid = eid2;
            this.attribute = attribute;
            this.value = value2;
        }

        public final int getEid() {
            return this.eid;
        }

        public final int getAttribute-dkwPBow() {
            return this.attribute;
        }

        @NotNull
        public final T getValue() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return "Contains(eid=" + this.eid + ", attribute=" + Attribute.toString-impl(this.attribute) + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.eid);
            result2 = result2 * 31 + Attribute.hashCode-impl(this.attribute);
            result2 = result2 * 31 + this.value.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Contains)) {
                return false;
            }
            Contains contains = (Contains)other;
            if (this.eid != contains.eid) {
                return false;
            }
            if (!Attribute.equals-impl0(this.attribute, contains.attribute)) {
                return false;
            }
            return Intrinsics.areEqual(this.value, contains.value);
        }

        public /* synthetic */ Contains(int eid2, int attribute, Object value2, DefaultConstructorMarker $constructor_marker) {
            this(eid2, attribute, value2);
        }
    }

    public static final class Entity
    extends IndexQuery<List<? extends Datom>> {
        private final int eid;

        public Entity(int eid2) {
            super(null);
            this.eid = eid2;
        }

        public final int getEid() {
            return this.eid;
        }

        @NotNull
        public String toString() {
            return "Entity(eid=" + this.eid + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.eid);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entity)) {
                return false;
            }
            Entity entity = (Entity)other;
            return this.eid == entity.eid;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class GetMany<T>
    extends IndexQuery<List<? extends Datom>> {
        private final int eid;
        private final int attribute;

        private GetMany(int eid2, int attribute) {
            super(null);
            this.eid = eid2;
            this.attribute = attribute;
        }

        public final int getEid() {
            return this.eid;
        }

        public final int getAttribute-dkwPBow() {
            return this.attribute;
        }

        @NotNull
        public String toString() {
            return "GetMany(eid=" + this.eid + ", attribute=" + Attribute.toString-impl(this.attribute) + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.eid);
            result2 = result2 * 31 + Attribute.hashCode-impl(this.attribute);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GetMany)) {
                return false;
            }
            GetMany getMany = (GetMany)other;
            if (this.eid != getMany.eid) {
                return false;
            }
            return Attribute.equals-impl0(this.attribute, getMany.attribute);
        }

        public /* synthetic */ GetMany(int eid2, int attribute, DefaultConstructorMarker $constructor_marker) {
            this(eid2, attribute);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class GetOne<T>
    extends IndexQuery<Versioned<T>> {
        private final int eid;
        private final int attribute;
        private final boolean throwIfNoEntity;

        private GetOne(int eid2, int attribute, boolean throwIfNoEntity) {
            super(null);
            this.eid = eid2;
            this.attribute = attribute;
            this.throwIfNoEntity = throwIfNoEntity;
        }

        public /* synthetic */ GetOne(int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                bl = false;
            }
            this(n, n2, bl, null);
        }

        public final int getEid() {
            return this.eid;
        }

        public final int getAttribute-dkwPBow() {
            return this.attribute;
        }

        public final boolean getThrowIfNoEntity() {
            return this.throwIfNoEntity;
        }

        @NotNull
        public String toString() {
            return "GetOne(eid=" + this.eid + ", attribute=" + Attribute.toString-impl(this.attribute) + ", throwIfNoEntity=" + this.throwIfNoEntity + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.eid);
            result2 = result2 * 31 + Attribute.hashCode-impl(this.attribute);
            result2 = result2 * 31 + Boolean.hashCode(this.throwIfNoEntity);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GetOne)) {
                return false;
            }
            GetOne getOne = (GetOne)other;
            if (this.eid != getOne.eid) {
                return false;
            }
            if (!Attribute.equals-impl0(this.attribute, getOne.attribute)) {
                return false;
            }
            return this.throwIfNoEntity == getOne.throwIfNoEntity;
        }

        public /* synthetic */ GetOne(int eid2, int attribute, boolean throwIfNoEntity, DefaultConstructorMarker $constructor_marker) {
            this(eid2, attribute, throwIfNoEntity);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class LookupMany<T>
    extends IndexQuery<List<? extends Datom>> {
        private final int attribute;
        @NotNull
        private final T value;
        @NotNull
        private final IntList partitions;

        private LookupMany(int attribute, T value2, IntList partitions) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)partitions, (String)"partitions");
            super(null);
            this.attribute = attribute;
            this.value = value2;
            this.partitions = partitions;
        }

        public /* synthetic */ LookupMany(int n, Object object, IntList intList, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                intList = APIKt.getAllParts();
            }
            this(n, object, intList, null);
        }

        public final int getAttribute-dkwPBow() {
            return this.attribute;
        }

        @NotNull
        public final T getValue() {
            return this.value;
        }

        @NotNull
        public final IntList getPartitions() {
            return this.partitions;
        }

        @NotNull
        public final LookupMany<T> copy-K3WVd_w(int attribute, @NotNull T value2, @NotNull IntList partitions) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)partitions, (String)"partitions");
            return new LookupMany<T>(attribute, value2, partitions, null);
        }

        public static /* synthetic */ LookupMany copy-K3WVd_w$default(LookupMany lookupMany, int n, Object object, IntList intList, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                n = lookupMany.attribute;
            }
            if ((n2 & 2) != 0) {
                object = lookupMany.value;
            }
            if ((n2 & 4) != 0) {
                intList = lookupMany.partitions;
            }
            return lookupMany.copy-K3WVd_w(n, object, intList);
        }

        @NotNull
        public String toString() {
            return "LookupMany(attribute=" + Attribute.toString-impl(this.attribute) + ", value=" + this.value + ", partitions=" + this.partitions + ")";
        }

        public int hashCode() {
            int result2 = Attribute.hashCode-impl(this.attribute);
            result2 = result2 * 31 + this.value.hashCode();
            result2 = result2 * 31 + this.partitions.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LookupMany)) {
                return false;
            }
            LookupMany lookupMany = (LookupMany)other;
            if (!Attribute.equals-impl0(this.attribute, lookupMany.attribute)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.value, lookupMany.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.partitions, (Object)lookupMany.partitions);
        }

        public /* synthetic */ LookupMany(int attribute, Object value2, IntList partitions, DefaultConstructorMarker $constructor_marker) {
            this(attribute, value2, partitions);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class LookupUnique<T>
    extends IndexQuery<VersionedEID> {
        private final int attribute;
        @NotNull
        private final T value;
        @NotNull
        private final IntList partitions;

        private LookupUnique(int attribute, T value2, IntList partitions) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)partitions, (String)"partitions");
            super(null);
            this.attribute = attribute;
            this.value = value2;
            this.partitions = partitions;
        }

        public /* synthetic */ LookupUnique(int n, Object object, IntList intList, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                intList = APIKt.getAllParts();
            }
            this(n, object, intList, null);
        }

        public final int getAttribute-dkwPBow() {
            return this.attribute;
        }

        @NotNull
        public final T getValue() {
            return this.value;
        }

        @NotNull
        public final IntList getPartitions() {
            return this.partitions;
        }

        @NotNull
        public final LookupUnique<T> copy-K3WVd_w(int attribute, @NotNull T value2, @NotNull IntList partitions) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)partitions, (String)"partitions");
            return new LookupUnique<T>(attribute, value2, partitions, null);
        }

        public static /* synthetic */ LookupUnique copy-K3WVd_w$default(LookupUnique lookupUnique2, int n, Object object, IntList intList, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                n = lookupUnique2.attribute;
            }
            if ((n2 & 2) != 0) {
                object = lookupUnique2.value;
            }
            if ((n2 & 4) != 0) {
                intList = lookupUnique2.partitions;
            }
            return lookupUnique2.copy-K3WVd_w(n, object, intList);
        }

        @NotNull
        public String toString() {
            return "LookupUnique(attribute=" + Attribute.toString-impl(this.attribute) + ", value=" + this.value + ", partitions=" + this.partitions + ")";
        }

        public int hashCode() {
            int result2 = Attribute.hashCode-impl(this.attribute);
            result2 = result2 * 31 + this.value.hashCode();
            result2 = result2 * 31 + this.partitions.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LookupUnique)) {
                return false;
            }
            LookupUnique lookupUnique2 = (LookupUnique)other;
            if (!Attribute.equals-impl0(this.attribute, lookupUnique2.attribute)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.value, lookupUnique2.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.partitions, (Object)lookupUnique2.partitions);
        }

        public /* synthetic */ LookupUnique(int attribute, Object value2, IntList partitions, DefaultConstructorMarker $constructor_marker) {
            this(attribute, value2, partitions);
        }
    }

    public static final class RefsTo
    extends IndexQuery<List<? extends Datom>> {
        private final int eid;
        @NotNull
        private final IntList partitions;

        public RefsTo(int eid2, @NotNull IntList partitions) {
            Intrinsics.checkNotNullParameter((Object)partitions, (String)"partitions");
            super(null);
            this.eid = eid2;
            this.partitions = partitions;
        }

        public /* synthetic */ RefsTo(int n, IntList intList, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                intList = APIKt.getAllParts();
            }
            this(n, intList);
        }

        public final int getEid() {
            return this.eid;
        }

        @NotNull
        public final IntList getPartitions() {
            return this.partitions;
        }

        @NotNull
        public final RefsTo copy(int eid2, @NotNull IntList partitions) {
            Intrinsics.checkNotNullParameter((Object)partitions, (String)"partitions");
            return new RefsTo(eid2, partitions);
        }

        public static /* synthetic */ RefsTo copy$default(RefsTo refsTo, int n, IntList intList, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = refsTo.eid;
            }
            if ((n2 & 2) != 0) {
                intList = refsTo.partitions;
            }
            return refsTo.copy(n, intList);
        }

        @NotNull
        public String toString() {
            return "RefsTo(eid=" + this.eid + ", partitions=" + this.partitions + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.eid);
            result2 = result2 * 31 + this.partitions.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RefsTo)) {
                return false;
            }
            RefsTo refsTo = (RefsTo)other;
            if (this.eid != refsTo.eid) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.partitions, (Object)refsTo.partitions);
        }
    }
}

