/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rhizomedb;

import com.jetbrains.rhizomedb.Instruction;
import com.jetbrains.rhizomedb.InstructionEffect;
import com.jetbrains.rhizomedb.Op;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Expansion {
    @NotNull
    private final List<Op> ops;
    private final long tx;
    @NotNull
    private final Instruction instruction;
    @Nullable
    private final Object sharedInstruction;
    @NotNull
    private final List<InstructionEffect> effects;

    public Expansion(@NotNull List<? extends Op> ops, long tx, @NotNull Instruction instruction, @Nullable Object sharedInstruction, @NotNull List<InstructionEffect> effects) {
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter(effects, (String)"effects");
        this.ops = ops;
        this.tx = tx;
        this.instruction = instruction;
        this.sharedInstruction = sharedInstruction;
        this.effects = effects;
    }

    @NotNull
    public final List<Op> getOps() {
        return this.ops;
    }

    public final long getTx() {
        return this.tx;
    }

    @NotNull
    public final Instruction getInstruction() {
        return this.instruction;
    }

    @Nullable
    public final Object getSharedInstruction() {
        return this.sharedInstruction;
    }

    @NotNull
    public final List<InstructionEffect> getEffects() {
        return this.effects;
    }

    @NotNull
    public final Expansion copy(@NotNull List<? extends Op> ops, long tx, @NotNull Instruction instruction, @Nullable Object sharedInstruction, @NotNull List<InstructionEffect> effects) {
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter(effects, (String)"effects");
        return new Expansion(ops, tx, instruction, sharedInstruction, effects);
    }

    public static /* synthetic */ Expansion copy$default(Expansion expansion2, List list2, long l, Instruction instruction, Object object, List list3, int n, Object object2) {
        if ((n & 1) != 0) {
            list2 = expansion2.ops;
        }
        if ((n & 2) != 0) {
            l = expansion2.tx;
        }
        if ((n & 4) != 0) {
            instruction = expansion2.instruction;
        }
        if ((n & 8) != 0) {
            object = expansion2.sharedInstruction;
        }
        if ((n & 0x10) != 0) {
            list3 = expansion2.effects;
        }
        return expansion2.copy(list2, l, instruction, object, list3);
    }

    @NotNull
    public String toString() {
        return "Expansion(ops=" + this.ops + ", tx=" + this.tx + ", instruction=" + this.instruction + ", sharedInstruction=" + this.sharedInstruction + ", effects=" + this.effects + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.ops).hashCode();
        result2 = result2 * 31 + Long.hashCode(this.tx);
        result2 = result2 * 31 + this.instruction.hashCode();
        result2 = result2 * 31 + (this.sharedInstruction == null ? 0 : this.sharedInstruction.hashCode());
        result2 = result2 * 31 + ((Object)this.effects).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Expansion)) {
            return false;
        }
        Expansion expansion2 = (Expansion)other;
        if (!Intrinsics.areEqual(this.ops, expansion2.ops)) {
            return false;
        }
        if (this.tx != expansion2.tx) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.instruction, (Object)expansion2.instruction)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sharedInstruction, (Object)expansion2.sharedInstruction)) {
            return false;
        }
        return Intrinsics.areEqual(this.effects, expansion2.effects);
    }
}

