/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rhizomedb;

import com.jetbrains.rhizomedb.Datom;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class DeserializationProblem {
    private DeserializationProblem() {
    }

    @NotNull
    public abstract Datom getDatom();

    public /* synthetic */ DeserializationProblem(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class Exception
    extends DeserializationProblem {
        @NotNull
        private final Throwable throwable;
        @NotNull
        private final Datom datom;

        public Exception(@NotNull Throwable throwable, @NotNull Datom datom) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            Intrinsics.checkNotNullParameter((Object)datom, (String)"datom");
            super(null);
            this.throwable = throwable;
            this.datom = datom;
        }

        @NotNull
        public final Throwable getThrowable() {
            return this.throwable;
        }

        @Override
        @NotNull
        public Datom getDatom() {
            return this.datom;
        }

        @NotNull
        public String toString() {
            return "Exception(throwable=" + this.throwable + ", datom=" + this.datom + ")";
        }

        public int hashCode() {
            int result2 = this.throwable.hashCode();
            result2 = result2 * 31 + this.datom.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Exception)) {
                return false;
            }
            Exception exception = (Exception)other;
            if (!Intrinsics.areEqual((Object)this.throwable, (Object)exception.throwable)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.datom, (Object)exception.datom);
        }
    }

    public static final class GotNull
    extends DeserializationProblem {
        @NotNull
        private final Datom datom;

        @Override
        @NotNull
        public Datom getDatom() {
            return this.datom;
        }

        @NotNull
        public String toString() {
            return "GotNull(datom=" + this.datom + ")";
        }

        public int hashCode() {
            return this.datom.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GotNull)) {
                return false;
            }
            GotNull gotNull = (GotNull)other;
            return Intrinsics.areEqual((Object)this.datom, (Object)gotNull.datom);
        }
    }

    public static final class Unexpected
    extends DeserializationProblem {
        @NotNull
        private final Datom datom;

        @Override
        @NotNull
        public Datom getDatom() {
            return this.datom;
        }

        @NotNull
        public String toString() {
            return "Unexpected(datom=" + this.datom + ")";
        }

        public int hashCode() {
            return this.datom.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Unexpected)) {
                return false;
            }
            Unexpected unexpected = (Unexpected)other;
            return Intrinsics.areEqual((Object)this.datom, (Object)unexpected.datom);
        }
    }
}

