/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rhizomedb;

import com.jetbrains.rhizomedb.Attribute;
import com.jetbrains.rhizomedb.DBUtilKt;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityType;
import com.jetbrains.rhizomedb.Instruction;
import com.jetbrains.rhizomedb.InstructionExpansion;
import com.jetbrains.rhizomedb.Op;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.Schema;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nInstructions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Instructions.kt\ncom/jetbrains/rhizomedb/CreateEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1869#2,2:168\n*S KotlinDebug\n*F\n+ 1 Instructions.kt\ncom/jetbrains/rhizomedb/CreateEntity\n*L\n29#1:168,2\n*E\n"})
public final class CreateEntity
implements Instruction {
    private final int eid;
    private final int entityTypeEid;
    @NotNull
    private final List<Pair<Attribute<?>, Object>> attributes;
    private final long seed;

    public CreateEntity(int eid2, int entityTypeEid, @NotNull List<? extends Pair<? extends Attribute<?>, ? extends Object>> attributes, long seed) {
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.eid = eid2;
        this.entityTypeEid = entityTypeEid;
        this.attributes = attributes;
        this.seed = seed;
    }

    public final int getEid() {
        return this.eid;
    }

    public final int getEntityTypeEid() {
        return this.entityTypeEid;
    }

    @NotNull
    public final List<Pair<Attribute<?>, Object>> getAttributes() {
        return this.attributes;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    @NotNull
    public InstructionExpansion expand(@NotNull DbContext<? extends Q> $this$expand) {
        List list2;
        Intrinsics.checkNotNullParameter($this$expand, (String)"<this>");
        List $this$expand_u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$expand_u24lambda_u242.add(new Op.Assert(this.eid, Entity.Companion.getType().getAttr-dkwPBow(), this.entityTypeEid, null));
        if (this.entityTypeEid != EntityType.Companion.getEid() && this.entityTypeEid != EntityAttribute.Companion.getEid() && DBUtilKt.getOne-A6wZMug$default($this$expand, this.eid, Entity.Companion.getEntityObject().getAttr-dkwPBow(), false, 4, null) == null) {
            Entity entity = (Entity)DBUtilKt.getOne-A6wZMug$default($this$expand, this.entityTypeEid, Entity.Companion.getEntityObject().getAttr-dkwPBow(), false, 4, null);
            if (entity != null) {
                Entity et = entity;
                boolean bl2 = false;
                int n = Entity.Companion.getEntityObject().getAttr-dkwPBow();
                Intrinsics.checkNotNull((Object)et, (String)"null cannot be cast to non-null type com.jetbrains.rhizomedb.EntityType<*>");
                $this$expand_u24lambda_u242.add(new Op.Assert(this.eid, n, ((EntityType)et).getReify$fleet_rhizomedb().invoke((Object)this.eid), null));
            }
        }
        Iterable $this$forEach$iv = this.attributes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl3 = false;
            int attr = ((Attribute)pair.component1()).unbox-impl();
            Object value2 = pair.component2();
            if (Schema.isRef-impl(Attribute.getSchema-HLBllEs(attr))) {
                Q q = $this$expand.getImpl();
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Int");
                q.assertEntityExists-FhYKfxU((Integer)value2, null, Attribute.box-impl(attr));
            }
            $this$expand_u24lambda_u242.add(new Op.Assert(this.eid, attr, value2, null));
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        List list3 = null;
        List list4 = CollectionsKt.build((List)list2);
        return new InstructionExpansion(list4, list3, n, defaultConstructorMarker);
    }

    @NotNull
    public String toString() {
        return "CreateEntity(eid=" + this.eid + ", entityTypeEid=" + this.entityTypeEid + ", attributes=" + this.attributes + ", seed=" + this.seed + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.eid);
        result2 = result2 * 31 + Integer.hashCode(this.entityTypeEid);
        result2 = result2 * 31 + ((Object)this.attributes).hashCode();
        result2 = result2 * 31 + Long.hashCode(this.seed);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CreateEntity)) {
            return false;
        }
        CreateEntity createEntity2 = (CreateEntity)other;
        if (this.eid != createEntity2.eid) {
            return false;
        }
        if (this.entityTypeEid != createEntity2.entityTypeEid) {
            return false;
        }
        if (!Intrinsics.areEqual(this.attributes, createEntity2.attributes)) {
            return false;
        }
        return this.seed == createEntity2.seed;
    }
}

