/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.schema;

import com.jetbrains.fus.reporting.schema.FieldValue;
import com.jetbrains.fus.reporting.schema.ListEventField;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StringListEventField
extends ListEventField<String> {
    @Override
    @Nullable
    public FieldValue getValue(@NotNull List<String> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return FieldValue.Companion.ofStringList(value2);
    }

    public static final class ValidatedByAllowedValues
    extends StringListEventField {
        @NotNull
        private final String name;
        @Nullable
        private final String description;
        @NotNull
        private final List<String> allowedValues;

        public ValidatedByAllowedValues(@NotNull String name2, @Nullable String description2, @NotNull List<String> allowedValues) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(allowedValues, (String)"allowedValues");
            this.name = name2;
            this.description = description2;
            this.allowedValues = allowedValues;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.description;
        }

        @NotNull
        public final List<String> getAllowedValues() {
            return this.allowedValues;
        }

        @Override
        @NotNull
        public List<String> getValidationRule() {
            return CollectionsKt.listOf((Object)("{enum:" + CollectionsKt.joinToString$default((Iterable)this.allowedValues, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + '}'));
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final String component2() {
            return this.description;
        }

        @NotNull
        public final List<String> component3() {
            return this.allowedValues;
        }

        @NotNull
        public final ValidatedByAllowedValues copy(@NotNull String name2, @Nullable String description2, @NotNull List<String> allowedValues) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(allowedValues, (String)"allowedValues");
            return new ValidatedByAllowedValues(name2, description2, allowedValues);
        }

        public static /* synthetic */ ValidatedByAllowedValues copy$default(ValidatedByAllowedValues validatedByAllowedValues, String string, String string2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = validatedByAllowedValues.name;
            }
            if ((n & 2) != 0) {
                string2 = validatedByAllowedValues.description;
            }
            if ((n & 4) != 0) {
                list2 = validatedByAllowedValues.allowedValues;
            }
            return validatedByAllowedValues.copy(string, string2, list2);
        }

        @NotNull
        public String toString() {
            return "ValidatedByAllowedValues(name=" + this.name + ", description=" + this.description + ", allowedValues=" + this.allowedValues + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.description == null ? 0 : this.description.hashCode());
            result2 = result2 * 31 + ((Object)this.allowedValues).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValidatedByAllowedValues)) {
                return false;
            }
            ValidatedByAllowedValues validatedByAllowedValues = (ValidatedByAllowedValues)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)validatedByAllowedValues.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)validatedByAllowedValues.description)) {
                return false;
            }
            return Intrinsics.areEqual(this.allowedValues, validatedByAllowedValues.allowedValues);
        }
    }

    public static final class ValidatedByCustomRule
    extends StringListEventField {
        @NotNull
        private final String name;
        @Nullable
        private final String description;
        @NotNull
        private final String customRuleId;

        public ValidatedByCustomRule(@NotNull String name2, @Nullable String description2, @NotNull String customRuleId) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)customRuleId, (String)"customRuleId");
            this.name = name2;
            this.description = description2;
            this.customRuleId = customRuleId;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.description;
        }

        @NotNull
        public final String getCustomRuleId() {
            return this.customRuleId;
        }

        @Override
        @NotNull
        public List<String> getValidationRule() {
            return CollectionsKt.listOf((Object)("{util#" + this.customRuleId + '}'));
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final String component2() {
            return this.description;
        }

        @NotNull
        public final String component3() {
            return this.customRuleId;
        }

        @NotNull
        public final ValidatedByCustomRule copy(@NotNull String name2, @Nullable String description2, @NotNull String customRuleId) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)customRuleId, (String)"customRuleId");
            return new ValidatedByCustomRule(name2, description2, customRuleId);
        }

        public static /* synthetic */ ValidatedByCustomRule copy$default(ValidatedByCustomRule validatedByCustomRule, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = validatedByCustomRule.name;
            }
            if ((n & 2) != 0) {
                string2 = validatedByCustomRule.description;
            }
            if ((n & 4) != 0) {
                string3 = validatedByCustomRule.customRuleId;
            }
            return validatedByCustomRule.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ValidatedByCustomRule(name=" + this.name + ", description=" + this.description + ", customRuleId=" + this.customRuleId + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.description == null ? 0 : this.description.hashCode());
            result2 = result2 * 31 + this.customRuleId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValidatedByCustomRule)) {
                return false;
            }
            ValidatedByCustomRule validatedByCustomRule = (ValidatedByCustomRule)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)validatedByCustomRule.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)validatedByCustomRule.description)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.customRuleId, (Object)validatedByCustomRule.customRuleId);
        }
    }

    public static final class ValidatedByEnum
    extends StringListEventField {
        @NotNull
        private final String name;
        @Nullable
        private final String description;
        @NotNull
        private final String enumRef;

        public ValidatedByEnum(@NotNull String name2, @Nullable String description2, @NotNull String enumRef) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)enumRef, (String)"enumRef");
            this.name = name2;
            this.description = description2;
            this.enumRef = enumRef;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.description;
        }

        @NotNull
        public final String getEnumRef() {
            return this.enumRef;
        }

        @Override
        @NotNull
        public List<String> getValidationRule() {
            return CollectionsKt.listOf((Object)("{enum#" + this.enumRef + '}'));
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final String component2() {
            return this.description;
        }

        @NotNull
        public final String component3() {
            return this.enumRef;
        }

        @NotNull
        public final ValidatedByEnum copy(@NotNull String name2, @Nullable String description2, @NotNull String enumRef) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)enumRef, (String)"enumRef");
            return new ValidatedByEnum(name2, description2, enumRef);
        }

        public static /* synthetic */ ValidatedByEnum copy$default(ValidatedByEnum validatedByEnum, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = validatedByEnum.name;
            }
            if ((n & 2) != 0) {
                string2 = validatedByEnum.description;
            }
            if ((n & 4) != 0) {
                string3 = validatedByEnum.enumRef;
            }
            return validatedByEnum.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ValidatedByEnum(name=" + this.name + ", description=" + this.description + ", enumRef=" + this.enumRef + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.description == null ? 0 : this.description.hashCode());
            result2 = result2 * 31 + this.enumRef.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValidatedByEnum)) {
                return false;
            }
            ValidatedByEnum validatedByEnum = (ValidatedByEnum)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)validatedByEnum.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)validatedByEnum.description)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.enumRef, (Object)validatedByEnum.enumRef);
        }
    }

    public static final class ValidatedByInlineRegexp
    extends StringListEventField {
        @NotNull
        private final String name;
        @Nullable
        private final String description;
        @NotNull
        private final String regexp;

        public ValidatedByInlineRegexp(@NotNull String name2, @Nullable String description2, @NotNull String regexp) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
            this.name = name2;
            this.description = description2;
            this.regexp = regexp;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.description;
        }

        @NotNull
        public final String getRegexp() {
            return this.regexp;
        }

        @Override
        @NotNull
        public List<String> getValidationRule() {
            return CollectionsKt.listOf((Object)("{regexp:" + this.regexp + '}'));
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final String component2() {
            return this.description;
        }

        @NotNull
        public final String component3() {
            return this.regexp;
        }

        @NotNull
        public final ValidatedByInlineRegexp copy(@NotNull String name2, @Nullable String description2, @NotNull String regexp) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
            return new ValidatedByInlineRegexp(name2, description2, regexp);
        }

        public static /* synthetic */ ValidatedByInlineRegexp copy$default(ValidatedByInlineRegexp validatedByInlineRegexp, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = validatedByInlineRegexp.name;
            }
            if ((n & 2) != 0) {
                string2 = validatedByInlineRegexp.description;
            }
            if ((n & 4) != 0) {
                string3 = validatedByInlineRegexp.regexp;
            }
            return validatedByInlineRegexp.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ValidatedByInlineRegexp(name=" + this.name + ", description=" + this.description + ", regexp=" + this.regexp + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.description == null ? 0 : this.description.hashCode());
            result2 = result2 * 31 + this.regexp.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValidatedByInlineRegexp)) {
                return false;
            }
            ValidatedByInlineRegexp validatedByInlineRegexp = (ValidatedByInlineRegexp)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)validatedByInlineRegexp.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)validatedByInlineRegexp.description)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.regexp, (Object)validatedByInlineRegexp.regexp);
        }
    }

    public static final class ValidatedByRegexp
    extends StringListEventField {
        @NotNull
        private final String name;
        @Nullable
        private final String description;
        @NotNull
        private final String regexpRef;

        public ValidatedByRegexp(@NotNull String name2, @Nullable String description2, @NotNull String regexpRef) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)regexpRef, (String)"regexpRef");
            this.name = name2;
            this.description = description2;
            this.regexpRef = regexpRef;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.description;
        }

        @NotNull
        public final String getRegexpRef() {
            return this.regexpRef;
        }

        @Override
        @NotNull
        public List<String> getValidationRule() {
            return CollectionsKt.listOf((Object)("{regexp#" + this.regexpRef + '}'));
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final String component2() {
            return this.description;
        }

        @NotNull
        public final String component3() {
            return this.regexpRef;
        }

        @NotNull
        public final ValidatedByRegexp copy(@NotNull String name2, @Nullable String description2, @NotNull String regexpRef) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)regexpRef, (String)"regexpRef");
            return new ValidatedByRegexp(name2, description2, regexpRef);
        }

        public static /* synthetic */ ValidatedByRegexp copy$default(ValidatedByRegexp validatedByRegexp, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = validatedByRegexp.name;
            }
            if ((n & 2) != 0) {
                string2 = validatedByRegexp.description;
            }
            if ((n & 4) != 0) {
                string3 = validatedByRegexp.regexpRef;
            }
            return validatedByRegexp.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ValidatedByRegexp(name=" + this.name + ", description=" + this.description + ", regexpRef=" + this.regexpRef + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.description == null ? 0 : this.description.hashCode());
            result2 = result2 * 31 + this.regexpRef.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValidatedByRegexp)) {
                return false;
            }
            ValidatedByRegexp validatedByRegexp = (ValidatedByRegexp)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)validatedByRegexp.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)validatedByRegexp.description)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.regexpRef, (Object)validatedByRegexp.regexpRef);
        }
    }
}

