/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.schema;

import com.jetbrains.fus.reporting.schema.FieldValue;
import com.jetbrains.fus.reporting.schema.ListEventField;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LongListEventField
extends ListEventField<Long> {
    @NotNull
    private final String name;
    @Nullable
    private final String description;

    public LongListEventField(@NotNull String name2, @Nullable String description2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.name = name2;
        this.description = description2;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<String> getValidationRule() {
        return CollectionsKt.listOf((Object)"{regexp#integer}");
    }

    @Override
    @NotNull
    public FieldValue getValue(@NotNull List<Long> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return FieldValue.Companion.ofLongList(value2);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @Nullable
    public final String component2() {
        return this.description;
    }

    @NotNull
    public final LongListEventField copy(@NotNull String name2, @Nullable String description2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return new LongListEventField(name2, description2);
    }

    public static /* synthetic */ LongListEventField copy$default(LongListEventField longListEventField, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = longListEventField.name;
        }
        if ((n & 2) != 0) {
            string2 = longListEventField.description;
        }
        return longListEventField.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "LongListEventField(name=" + this.name + ", description=" + this.description + ')';
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + (this.description == null ? 0 : this.description.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LongListEventField)) {
            return false;
        }
        LongListEventField longListEventField = (LongListEventField)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)longListEventField.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.description, (Object)longListEventField.description);
    }
}

