/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.lion3;

import com.jetbrains.fus.reporting.lion3.FeatureUsageLogWriter;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import com.jetbrains.fus.reporting.model.lion3.LogEventAction;
import com.jetbrains.fus.reporting.model.lion3.LogEventGroup;
import com.jetbrains.fus.reporting.schema.EventId;
import com.jetbrains.fus.reporting.schema.EventId1;
import com.jetbrains.fus.reporting.schema.EventId2;
import com.jetbrains.fus.reporting.schema.EventId3;
import com.jetbrains.fus.reporting.schema.EventLogGroup;
import com.jetbrains.fus.reporting.schema.FieldListDescription;
import com.jetbrains.fus.reporting.schema.VarargEventId;
import java.util.Map;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public class FeatureUsageLogger {
    private final int recorderVersion;
    @NotNull
    private final String session;
    @NotNull
    private final String build;
    private final int bucket;
    @NotNull
    private final FeatureUsageLogWriter writer;

    public FeatureUsageLogger(int recorderVersion, @NotNull String session2, @NotNull String build2, int bucket, @NotNull FeatureUsageLogWriter writer2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        this.recorderVersion = recorderVersion;
        this.session = session2;
        this.build = build2;
        this.bucket = bucket;
        this.writer = writer2;
    }

    public final void logBaseline(@NotNull EventLogGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.writer.writeEvent(this.createLogEvent(group, group.getType() == EventLogGroup.Type.STATE ? "invoked" : "registered", MapsKt.emptyMap()));
    }

    public final void log(@NotNull EventId event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.writer.writeEvent(this.createLogEvent(event.getGroup(), event.getEventId(), MapsKt.emptyMap()));
    }

    public final <T> void log(@NotNull EventId1<T> event, T value2) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        this.writer.writeEvent(this.createLogEvent(event.getGroup(), event.getEventId(), event.buildEventData(value2)));
    }

    public final <T1, T2> void log(@NotNull EventId2<T1, T2> event, T1 value1, T2 value2) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        this.writer.writeEvent(this.createLogEvent(event.getGroup(), event.getEventId(), event.buildEventData(value1, value2)));
    }

    public final <T1, T2, T3> void log(@NotNull EventId3<T1, T2, T3> event, T1 value1, T2 value2, T3 value3) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        this.writer.writeEvent(this.createLogEvent(event.getGroup(), event.getEventId(), event.buildEventData(value1, value2, value3)));
    }

    public final <D extends FieldListDescription> void logVararg(@NotNull VarargEventId<D> event, @NotNull Function1<? super D, Unit> filler) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Intrinsics.checkNotNullParameter(filler, (String)"filler");
        this.writer.writeEvent(this.createLogEvent(event.getGroup(), event.getEventId(), event.buildEventData(filler)));
    }

    private final LogEvent createLogEvent(EventLogGroup group, String eventId, Map<String, ? extends Object> data2) {
        boolean isState = group.getType() == EventLogGroup.Type.STATE;
        return new LogEvent(this.session, this.build, String.valueOf(this.bucket), System.currentTimeMillis(), new LogEventGroup(group.getId(), String.valueOf(group.getVersion())), String.valueOf(this.recorderVersion), new LogEventAction(eventId, isState, MapsKt.toMutableMap(data2), 0, 8, null));
    }
}

