/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.dom;

import com.intellij.util.xml.dom.XmlElement$;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nXmlElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlElement.kt\ncom/intellij/util/xml/dom/XmlElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,31:1\n1788#2,4:32\n295#2,2:36\n*S KotlinDebug\n*F\n+ 1 XmlElement.kt\ncom/intellij/util/xml/dom/XmlElement\n*L\n19#1:32,4\n25#1:36,2\n*E\n"})
public final class XmlElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final String name;
    @JvmField
    @NotNull
    public final Map<String, String> attributes;
    @JvmField
    @NotNull
    public final List<XmlElement> children;
    @JvmField
    @Nullable
    public final String content;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public XmlElement(@NotNull String name2, @NotNull Map<String, String> attributes, @NotNull List<XmlElement> children, @Nullable String content2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.name = name2;
        this.attributes = attributes;
        this.children = children;
        this.content = content2;
    }

    public /* synthetic */ XmlElement(String string, Map map2, List list2, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Map<String, String> map3 = Collections.emptyMap();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"emptyMap(...)");
            map2 = map3;
        }
        if ((n & 4) != 0) {
            List<XmlElement> list3 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"emptyList(...)");
            list2 = list3;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(string, map2, list2, string2);
    }

    public final int count(@NotNull String name2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Iterable $this$count$iv = this.children;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                XmlElement it = (XmlElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name, (Object)name2) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    @Nullable
    public final String getAttributeValue(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.attributes.get(name2);
    }

    @Nullable
    public final String getAttributeValue(@NotNull String name2, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String string = this.attributes.get(name2);
        if (string == null) {
            string = defaultValue;
        }
        return string;
    }

    @Nullable
    public final XmlElement getChild(@NotNull String name2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Iterable $this$firstOrNull$iv = this.children;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                XmlElement it = (XmlElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name, (Object)name2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final Sequence<XmlElement> children(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.children), arg_0 -> XmlElement.children$lambda$2(name2, arg_0));
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Map<String, String> component2() {
        return this.attributes;
    }

    @NotNull
    public final List<XmlElement> component3() {
        return this.children;
    }

    @Nullable
    public final String component4() {
        return this.content;
    }

    @NotNull
    public final XmlElement copy(@NotNull String name2, @NotNull Map<String, String> attributes, @NotNull List<XmlElement> children, @Nullable String content2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        return new XmlElement(name2, attributes, children, content2);
    }

    public static /* synthetic */ XmlElement copy$default(XmlElement xmlElement, String string, Map map2, List list2, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = xmlElement.name;
        }
        if ((n & 2) != 0) {
            map2 = xmlElement.attributes;
        }
        if ((n & 4) != 0) {
            list2 = xmlElement.children;
        }
        if ((n & 8) != 0) {
            string2 = xmlElement.content;
        }
        return xmlElement.copy(string, map2, list2, string2);
    }

    @NotNull
    public String toString() {
        return "XmlElement(name=" + this.name + ", attributes=" + this.attributes + ", children=" + this.children + ", content=" + this.content + ')';
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + ((Object)this.attributes).hashCode();
        result2 = result2 * 31 + ((Object)this.children).hashCode();
        result2 = result2 * 31 + (this.content == null ? 0 : this.content.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof XmlElement)) {
            return false;
        }
        XmlElement xmlElement = (XmlElement)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)xmlElement.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.attributes, xmlElement.attributes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.children, xmlElement.children)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.content, (Object)xmlElement.content);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$intellij_platform_util_xmlDom(XmlElement self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        boolean bl;
        boolean bl2;
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output2.encodeStringElement(serialDesc, 0, self.name);
        if (output2.shouldEncodeElementDefault(serialDesc, 1)) {
            bl2 = true;
        } else {
            Map<String, String> map2 = self.attributes;
            Map map3 = Collections.emptyMap();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"emptyMap(...)");
            bl2 = !Intrinsics.areEqual(map2, map3);
        }
        if (bl2) {
            output2.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)lazyArray[1].getValue(), self.attributes);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 2)) {
            bl = true;
        } else {
            List<XmlElement> list2 = self.children;
            List list3 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"emptyList(...)");
            bl = !Intrinsics.areEqual(list2, list3);
        }
        if (bl) {
            output2.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)lazyArray[2].getValue(), self.children);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 3) ? true : self.content != null) {
            output2.encodeNullableSerializableElement(serialDesc, 3, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.content);
        }
    }

    public /* synthetic */ XmlElement(int seen0, String name2, Map attributes, List children, String content2, SerializationConstructorMarker serializationConstructorMarker) {
        if (1 != (1 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.name = name2;
        if ((seen0 & 2) == 0) {
            Map map2 = Collections.emptyMap();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"emptyMap(...)");
            this.attributes = map2;
        } else {
            this.attributes = attributes;
        }
        if ((seen0 & 4) == 0) {
            List list2 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"emptyList(...)");
            this.children = list2;
        } else {
            this.children = children;
        }
        this.content = (seen0 & 8) == 0 ? null : content2;
    }

    private static final boolean children$lambda$2(String $name, XmlElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.name, (Object)$name);
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)$serializer.INSTANCE)), null};
        $childSerializers = lazyArray;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<XmlElement> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

