/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.dom;

import com.fasterxml.aalto.in.ByteSourceBootstrapper;
import com.fasterxml.aalto.in.CharSourceBootstrapper;
import com.fasterxml.aalto.in.InputBootstrapper;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.stax.StreamReaderImpl;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JvmName(name="StaxFactory")
public final class StaxFactory {
    @NotNull
    private static final ReaderConfig config = StaxFactory.createConfig(false);
    @NotNull
    private static final ReaderConfig configWithCoalescing = StaxFactory.createConfig(true);

    private static final ReaderConfig createConfig(boolean coalesce) {
        ReaderConfig config = new ReaderConfig();
        config.doAutoCloseInput(true);
        config.setProperty("javax.xml.stream.supportDTD", (Object)false);
        config.setProperty("javax.xml.stream.isReplacingEntityReferences", (Object)false);
        config.setProperty("org.codehaus.stax2.internNames", (Object)false);
        config.setProperty("org.codehaus.stax2.internNsUris", (Object)false);
        config.doPreserveLocation(false);
        config.setProperty("org.codehaus.stax2.closeInputSource", (Object)true);
        config.setXmlEncoding("UTF-8");
        config.doCoalesceText(coalesce);
        config.doParseLazily(true);
        return config;
    }

    @JvmOverloads
    @NotNull
    public static final XMLStreamReader2 createXmlStreamReader(@NotNull InputStream input, @Nullable String locationSource) throws XMLStreamException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        StreamReaderImpl streamReaderImpl = StreamReaderImpl.construct((InputBootstrapper)((InputBootstrapper)ByteSourceBootstrapper.construct((ReaderConfig)configWithCoalescing.createNonShared(null, locationSource, "UTF-8"), (InputStream)input)));
        Intrinsics.checkNotNullExpressionValue((Object)streamReaderImpl, (String)"construct(...)");
        return (XMLStreamReader2)streamReaderImpl;
    }

    public static /* synthetic */ XMLStreamReader2 createXmlStreamReader$default(InputStream inputStream, String string, int n, Object object) throws XMLStreamException {
        if ((n & 2) != 0) {
            string = null;
        }
        return StaxFactory.createXmlStreamReader(inputStream, string);
    }

    @NotNull
    public static final XMLStreamReader2 createXmlStreamReader(@NotNull byte[] bytes2) throws XMLStreamException {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        StreamReaderImpl streamReaderImpl = StreamReaderImpl.construct((InputBootstrapper)((InputBootstrapper)ByteSourceBootstrapper.construct((ReaderConfig)configWithCoalescing.createNonShared(null, null, "UTF-8"), (byte[])bytes2, (int)0, (int)bytes2.length)));
        Intrinsics.checkNotNullExpressionValue((Object)streamReaderImpl, (String)"construct(...)");
        return (XMLStreamReader2)streamReaderImpl;
    }

    @ApiStatus.Internal
    @NotNull
    public static final XMLStreamReader2 createXmlStreamReader(@NotNull byte[] bytes2, int start2, int size) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        StreamReaderImpl streamReaderImpl = StreamReaderImpl.construct((InputBootstrapper)((InputBootstrapper)ByteSourceBootstrapper.construct((ReaderConfig)configWithCoalescing.createNonShared(null, null, "UTF-8"), (byte[])bytes2, (int)start2, (int)size)));
        Intrinsics.checkNotNullExpressionValue((Object)streamReaderImpl, (String)"construct(...)");
        return (XMLStreamReader2)streamReaderImpl;
    }

    @NotNull
    public static final XMLStreamReader2 createNonCoalescingXmlStreamReader(@NotNull InputStream input, @Nullable String locationSource) throws XMLStreamException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        StreamReaderImpl streamReaderImpl = StreamReaderImpl.construct((InputBootstrapper)((InputBootstrapper)ByteSourceBootstrapper.construct((ReaderConfig)config.createNonShared(null, locationSource, "UTF-8"), (InputStream)input)));
        Intrinsics.checkNotNullExpressionValue((Object)streamReaderImpl, (String)"construct(...)");
        return (XMLStreamReader2)streamReaderImpl;
    }

    @NotNull
    public static final XMLStreamReader2 createNonCoalescingXmlStreamReader(@NotNull byte[] input, @Nullable String locationSource) throws XMLStreamException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        StreamReaderImpl streamReaderImpl = StreamReaderImpl.construct((InputBootstrapper)((InputBootstrapper)ByteSourceBootstrapper.construct((ReaderConfig)config.createNonShared(null, locationSource, "UTF-8"), (byte[])input, (int)0, (int)input.length)));
        Intrinsics.checkNotNullExpressionValue((Object)streamReaderImpl, (String)"construct(...)");
        return (XMLStreamReader2)streamReaderImpl;
    }

    @NotNull
    public static final XMLStreamReader2 createXmlStreamReader(@NotNull Reader reader2) throws XMLStreamException {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        StreamReaderImpl streamReaderImpl = StreamReaderImpl.construct((InputBootstrapper)((InputBootstrapper)CharSourceBootstrapper.construct((ReaderConfig)configWithCoalescing.createNonShared(null, null, "UTF-8"), (Reader)reader2)));
        Intrinsics.checkNotNullExpressionValue((Object)streamReaderImpl, (String)"construct(...)");
        return (XMLStreamReader2)streamReaderImpl;
    }

    @NotNull
    public static final XMLStreamReader2 createXmlStreamReader(@NotNull char[] chars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        StreamReaderImpl streamReaderImpl = StreamReaderImpl.construct((InputBootstrapper)((InputBootstrapper)CharSourceBootstrapper.construct((ReaderConfig)configWithCoalescing.createNonShared(null, null, "UTF-8"), (char[])chars, (int)0, (int)chars.length)));
        Intrinsics.checkNotNullExpressionValue((Object)streamReaderImpl, (String)"construct(...)");
        return (XMLStreamReader2)streamReaderImpl;
    }

    @JvmOverloads
    @NotNull
    public static final XMLStreamReader2 createXmlStreamReader(@NotNull InputStream input) throws XMLStreamException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return StaxFactory.createXmlStreamReader$default(input, null, 2, null);
    }
}

