/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class MergingCharSequence
implements CharSequence {
    @NotNull
    private final CharSequence s1;
    @NotNull
    private final CharSequence s2;

    public MergingCharSequence(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        this.s1 = s1;
        this.s2 = s2;
    }

    public int getLength() {
        return this.s1.length() + this.s2.length();
    }

    public char get(int index) {
        if (index < this.s1.length()) {
            return this.s1.charAt(index);
        }
        return this.s2.charAt(index - this.s1.length());
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        return startIndex == 0 && endIndex == this.length() ? (CharSequence)this : (startIndex < this.s1.length() && endIndex < this.s1.length() ? this.s1.subSequence(startIndex, endIndex) : (startIndex >= this.s1.length() && endIndex >= this.s1.length() ? this.s2.subSequence(startIndex - this.s1.length(), endIndex - this.s1.length()) : (CharSequence)new MergingCharSequence(this.s1.subSequence(startIndex, this.s1.length()), this.s2.subSequence(0, endIndex - this.s1.length()))));
    }

    @Override
    @NotNull
    public String toString() {
        return "" + this.s1 + this.s2;
    }
}

