/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CharArrayExternalizable;
import com.intellij.util.text.CharArrayUtilKmpKt;
import com.intellij.util.text.CharSequenceBackedByArray;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nCharArrayUtilKmp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharArrayUtilKmp.kt\ncom/intellij/util/text/CharArrayUtilKmp\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,268:1\n1761#2,3:269\n1740#2,3:272\n1740#2,3:275\n*S KotlinDebug\n*F\n+ 1 CharArrayUtilKmp.kt\ncom/intellij/util/text/CharArrayUtilKmp\n*L\n28#1:269,3\n244#1:272,3\n251#1:275,3\n*E\n"})
public final class CharArrayUtilKmp {
    @NotNull
    public static final CharArrayUtilKmp INSTANCE = new CharArrayUtilKmp();

    private CharArrayUtilKmp() {
    }

    @JvmStatic
    @Nullable
    public static final char[] fromSequenceWithoutCopying(@Nullable CharSequence seq) {
        if (seq instanceof CharSequenceBackedByArray) {
            return ((CharSequenceBackedByArray)seq).getChars();
        }
        return CharArrayUtilKmpKt.fromSequenceWithoutCopyingPlatformSpecific(seq);
    }

    @JvmStatic
    @NotNull
    public static final char[] fromSequence(@NotNull CharSequence $this$fromSequence, int start2, int end) {
        Intrinsics.checkNotNullParameter((Object)$this$fromSequence, (String)"<this>");
        char[] result2 = new char[end - start2];
        CharArrayUtilKmp.getChars($this$fromSequence, result2, start2, 0, end - start2);
        return result2;
    }

    @JvmStatic
    @JvmOverloads
    public static final void getChars(@NotNull CharSequence $this$getChars, @NotNull char[] dst, int srcOffset, int dstOffset, int len) {
        Intrinsics.checkNotNullParameter((Object)$this$getChars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if ($this$getChars instanceof CharArrayExternalizable) {
            ((CharArrayExternalizable)$this$getChars).getChars(srcOffset, srcOffset + len, dst, dstOffset);
            return;
        }
        if (len >= 10) {
            if ($this$getChars instanceof String) {
                String string = (String)$this$getChars;
                int n = srcOffset + len;
                string.getChars(srcOffset, n, dst, dstOffset);
                return;
            }
            if ($this$getChars instanceof CharSequenceBackedByArray) {
                CharSequence charSequence = $this$getChars.subSequence(srcOffset, srcOffset + len);
                Intrinsics.checkNotNull((Object)charSequence, (String)"null cannot be cast to non-null type com.intellij.util.text.CharSequenceBackedByArray");
                ((CharSequenceBackedByArray)charSequence).getChars(dst, dstOffset);
                return;
            }
            if ($this$getChars instanceof StringBuilder) {
                StringBuilder stringBuilder = (StringBuilder)$this$getChars;
                int n = srcOffset + len;
                stringBuilder.getChars(srcOffset, n, dst, dstOffset);
                return;
            }
            if (CharArrayUtilKmpKt.getCharsPlatformSpecific($this$getChars, srcOffset, dst, dstOffset, len)) {
                return;
            }
        }
        int i2 = 0;
        int max = srcOffset + len;
        for (int j = srcOffset; j < max && i2 < dst.length; ++i2, ++j) {
            dst[i2 + dstOffset] = $this$getChars.charAt(j);
        }
    }

    @JvmStatic
    public static final boolean regionMatches(@NotNull char[] $this$regionMatches, int start2, int end, @NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter((Object)$this$regionMatches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        int len = s.length();
        if (start2 + len > end) {
            return false;
        }
        if (start2 < 0) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if ($this$regionMatches[start2 + i2] == s.charAt(i2)) continue;
            return false;
        }
        return true;
    }
}

