/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringsKmp;
import com.intellij.util.text.CharArrayUtilKmp;
import com.intellij.util.text.CharSequenceBackedByArray;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharArrayCharSequence
implements CharSequenceWithStringHash,
CharSequenceBackedByArray {
    @JvmField
    @NotNull
    protected final char[] myChars;
    @JvmField
    protected final int myStart;
    @JvmField
    protected final int myEnd;
    private transient int hash;

    public CharArrayCharSequence(@NotNull char[] myChars, int myStart, int myEnd) {
        Intrinsics.checkNotNullParameter((Object)myChars, (String)"myChars");
        this.myChars = myChars;
        this.myStart = myStart;
        this.myEnd = myEnd;
        if (this.myStart < 0 || this.myEnd > this.myChars.length || this.myStart > this.myEnd) {
            throw new IndexOutOfBoundsException("chars.length:" + this.myChars.length + ", start:" + this.myStart + ", end:" + this.myEnd);
        }
    }

    public CharArrayCharSequence(char ... chars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        this(chars, 0, chars.length);
    }

    public int getLength() {
        return this.myEnd - this.myStart;
    }

    public char get(int index) {
        return this.myChars[index + this.myStart];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start2, int end) {
        return start2 == 0 && end == this.length() ? (CharSequence)this : (CharSequence)new CharArrayCharSequence(this.myChars, this.myStart + start2, this.myStart + end);
    }

    @Override
    @NotNull
    public String toString() {
        return StringsKt.concatToString((char[])this.myChars, (int)this.myStart, (int)this.myEnd);
    }

    @Override
    @NotNull
    public char[] getChars() {
        if (this.myStart == 0) {
            return this.myChars;
        }
        char[] chars = new char[this.length()];
        this.getChars(chars, 0);
        return chars;
    }

    @Override
    public void getChars(@NotNull char[] dst, int dstOffset) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        ArraysKt.copyInto((char[])this.myChars, (char[])dst, (int)dstOffset, (int)this.myStart, (int)this.myEnd);
    }

    public boolean equals(@Nullable Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null || this.getClass() != anObject.getClass() || this.length() != ((CharSequence)anObject).length()) {
            return false;
        }
        return CharArrayUtilKmp.regionMatches(this.myChars, this.myStart, this.myEnd, (CharSequence)anObject);
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = StringsKmp.stringHashCode(this.myChars, this.myStart, this.myEnd);
        }
        return h;
    }
}

