/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExceptionUtil {
    @ApiStatus.Internal
    @NotNull
    public static <T> Stream<T> causeAndSuppressed(@NotNull Throwable error2, @NotNull Class<T> klass) {
        if (error2 == null) {
            ExceptionUtil.$$$reportNull$$$0(5);
        }
        if (klass == null) {
            ExceptionUtil.$$$reportNull$$$0(6);
        }
        LinkedHashSet<Throwable> allThrowables = new LinkedHashSet<Throwable>();
        ArrayDeque<Throwable> deque = new ArrayDeque<Throwable>();
        deque.add(error2);
        while (!deque.isEmpty()) {
            Throwable t2 = (Throwable)deque.removeFirst();
            if (!allThrowables.add(t2)) continue;
            for (Throwable cause = t2.getCause(); cause != null; cause = cause.getCause()) {
                deque.addLast(cause);
            }
            for (Throwable s : t2.getSuppressed()) {
                deque.addLast(s);
            }
        }
        Stream<Object> stream = allThrowables.stream().filter(klass::isInstance).map(klass::cast);
        if (stream == null) {
            ExceptionUtil.$$$reportNull$$$0(7);
        }
        return stream;
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable t2) {
        if (t2 == null) {
            ExceptionUtil.$$$reportNull$$$0(11);
        }
        StringWriter writer2 = new StringWriter();
        t2.printStackTrace(new PrintWriter(writer2));
        String string = writer2.getBuffer().toString();
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public static String getMessage(@NotNull Throwable e) {
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(20);
        }
        String result2 = e.getMessage();
        String exceptionPattern = "Exception: ";
        String errorPattern = "Error: ";
        while (e.getCause() != null && (result2 == null || result2.contains(exceptionPattern) || result2.contains(errorPattern))) {
            e = e.getCause();
            result2 = e.getMessage();
        }
        if (result2 != null) {
            result2 = ExceptionUtil.extractMessage(result2, exceptionPattern);
            result2 = ExceptionUtil.extractMessage(result2, errorPattern);
        }
        return result2;
    }

    @NotNull
    private static String extractMessage(@NotNull String result2, @NotNull String errorPattern) {
        if (result2 == null) {
            ExceptionUtil.$$$reportNull$$$0(21);
        }
        if (errorPattern == null) {
            ExceptionUtil.$$$reportNull$$$0(22);
        }
        if (result2.lastIndexOf(errorPattern) >= 0) {
            result2 = result2.substring(result2.lastIndexOf(errorPattern) + errorPattern.length());
        }
        String string = result2;
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ExceptionUtil";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeTo";
                break;
            }
            case 11: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameSkipPattern";
                break;
            }
            case 16: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorPattern";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMessage";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exampleClass";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exampleSupplier";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "potentiallyFailingTasks";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionsCombiner";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToUnwrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ExceptionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootCause";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findCauseAndSuppressed";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "causeAndSuppressed";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "makeStackTraceRelative";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserStackTrace";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMessage";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonEmptyMessage";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootCause";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 35: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findCauseAndSuppressed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "causeAndSuppressed";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "makeStackTraceRelative";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUserStackTrace";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "extractMessage";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptyMessage";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "runAndCatch";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "runAllAndRethrowAllExceptions";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "unwrapException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

