/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.netty.util;

import com.intellij.station.comms.common.netty.util.SimpleChannelInboundHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.CompletableFuture;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class SingleMessageFutureChannelInboundHandler<T>
extends SimpleChannelInboundHandlerAdapter<T>
implements AutoCloseable {
    @NotNull
    private final CompletableFuture<T> future;

    public SingleMessageFutureChannelInboundHandler(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        super(clazz, false);
        this.future = new CompletableFuture();
    }

    @NotNull
    public final CompletableFuture<T> getFuture() {
        return this.future;
    }

    @Override
    protected void messageReceived(@NotNull ChannelHandlerContext context2, T message2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        context2.pipeline().remove(this);
        this.future.complete(message2);
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        ctx.pipeline().remove(this);
        this.future.completeExceptionally(cause);
    }

    @Override
    public void close() {
        this.future.thenAccept(p0 -> ReferenceCountUtil.release(p0));
    }
}

