/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.netty.util;

import io.netty.util.concurrent.FastThreadLocalThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NettyThreadFactory
implements ThreadFactory {
    @NotNull
    private final String namePrefix;
    @NotNull
    private final AtomicInteger innerCounter;

    public NettyThreadFactory(@NotNull String namePrefix, @NotNull AtomicInteger outerCounter) {
        Intrinsics.checkNotNullParameter((Object)namePrefix, (String)"namePrefix");
        Intrinsics.checkNotNullParameter((Object)outerCounter, (String)"outerCounter");
        this.namePrefix = namePrefix + " " + outerCounter.incrementAndGet() + "-";
        this.innerCounter = new AtomicInteger();
    }

    @Override
    @Nullable
    public Thread newThread(@NotNull Runnable r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return new FastThreadLocalThread(r, this.namePrefix + this.innerCounter.incrementAndGet());
    }
}

