/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.netty.server;

import com.intellij.station.comms.common.ServicesServerHostApplication;
import com.intellij.station.comms.common.netty.server.RootHandler;
import com.intellij.station.comms.common.netty.util.ExtensionsKt;
import com.intellij.station.comms.common.netty.util.NettyThreadFactory;
import com.intellij.station.comms.common.utils.Logging;
import com.intellij.station.comms.common.utils.StationConstants;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioDomainSocketChannel;
import io.netty.channel.socket.nio.NioServerDomainSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.spi.SelectorProvider;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.KotlinNothingValueException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SourceDebugExtension(value={"SMAP\nNettyServicesServerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyServicesServerBase.kt\ncom/intellij/station/comms/common/netty/server/NettyServicesServerBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logging.kt\ncom/intellij/station/comms/common/utils/Logging\n*L\n1#1,150:1\n1#2:151\n7#3:152\n*S KotlinDebug\n*F\n+ 1 NettyServicesServerBase.kt\ncom/intellij/station/comms/common/netty/server/NettyServicesServerBase\n*L\n36#1:152\n*E\n"})
public final class NettyServicesServerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final ServicesServerHostApplication hostApplication;
    @NotNull
    private final MutableStateFlow<Boolean> runningStateFlow;
    @NotNull
    private final MutableSharedFlow<Unit> serverAttemptFlow;
    @NotNull
    private final StateFlow<Boolean> isRunning;
    @NotNull
    private final MultiThreadIoEventLoopGroup eventLoop;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final AttributeKey<ChannelHandler> DEFAULT_HANDLER;
    @NotNull
    private static final AtomicInteger serversCounter;

    /*
     * WARNING - void declaration
     */
    public NettyServicesServerBase(@NotNull CoroutineScope scope2, @NotNull ServicesServerHostApplication hostApplication) {
        void it;
        MutableSharedFlow mutableSharedFlow;
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)hostApplication, (String)"hostApplication");
        this.scope = scope2;
        this.hostApplication = hostApplication;
        this.runningStateFlow = StateFlowKt.MutableStateFlow((Object)false);
        MutableSharedFlow mutableSharedFlow2 = mutableSharedFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, null, (int)6, null);
        NettyServicesServerBase nettyServicesServerBase = this;
        boolean bl = false;
        it.tryEmit((Object)Unit.INSTANCE);
        nettyServicesServerBase.serverAttemptFlow = mutableSharedFlow;
        this.isRunning = (StateFlow)this.runningStateFlow;
        this.eventLoop = new MultiThreadIoEventLoopGroup(3, (ThreadFactory)new NettyThreadFactory("Netty Station Server", serversCounter), NioIoHandler.newFactory(SelectorProvider.provider()));
        UnixDomainSocketAddress endpoint = this.hostApplication.getBindAddress();
        UnixDomainSocketAddress linkAddress = this.hostApplication.getAdditionalLinkAddress();
        Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwx------");
        logger.info("Starting services server on " + endpoint.getPath());
        Files.deleteIfExists(endpoint.getPath());
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ NettyServicesServerBase this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = DelayKt.awaitCancellation((Continuation)((Continuation)this));
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        Object object2;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            throw new KotlinNothingValueException();
                        }
                        catch (Throwable throwable) {
                            this.this$0.eventLoop.shutdownGracefully().await();
                            throw throwable;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, endpoint, permissions, linkAddress, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ NettyServicesServerBase this$0;
            final /* synthetic */ UnixDomainSocketAddress $endpoint;
            final /* synthetic */ Set<PosixFilePermission> $permissions;
            final /* synthetic */ UnixDomainSocketAddress $linkAddress;
            {
                this.this$0 = $receiver;
                this.$endpoint = $endpoint;
                this.$permissions = $permissions;
                this.$linkAddress = $linkAddress;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$launch;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.serverAttemptFlow), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, this.$endpoint, this.$permissions, (CoroutineScope)$this$launch, this.$linkAddress, null){
                            Object L$0;
                            Object L$1;
                            int label;
                            final /* synthetic */ NettyServicesServerBase this$0;
                            final /* synthetic */ UnixDomainSocketAddress $endpoint;
                            final /* synthetic */ Set<PosixFilePermission> $permissions;
                            final /* synthetic */ CoroutineScope $$this$launch;
                            final /* synthetic */ UnixDomainSocketAddress $linkAddress;
                            {
                                this.this$0 = $receiver;
                                this.$endpoint = $endpoint;
                                this.$permissions = $permissions;
                                this.$$this$launch = $$this$launch;
                                this.$linkAddress = $linkAddress;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(NettyServicesServerBase.access$getEventLoop$p(this.this$0)).channel(NioServerDomainSocketChannel.class)).handler(new LoggingHandler(NettyServicesServerBase.class, LogLevel.INFO))).childHandler(new ChannelInitializer<NioDomainSocketChannel>(this.this$0){
                                            final /* synthetic */ NettyServicesServerBase this$0;
                                            {
                                                this.this$0 = $receiver;
                                            }

                                            protected void initChannel(NioDomainSocketChannel ch) {
                                                Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                                                ChannelPipeline pipeline = ch.pipeline();
                                                ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new HttpServerCodec()};
                                                pipeline.addLast(channelHandlerArray);
                                                channelHandlerArray = new ChannelHandler[]{new HttpObjectAggregator(0xA00000)};
                                                pipeline.addLast(channelHandlerArray);
                                                RootHandler defaultHandler = new RootHandler(NettyServicesServerBase.access$getScope$p(this.this$0), NettyServicesServerBase.access$getHostApplication$p(this.this$0));
                                                ChannelHandler[] channelHandlerArray2 = new ChannelHandler[]{defaultHandler};
                                                pipeline.addLast(channelHandlerArray2);
                                                pipeline.channel().attr(NettyServicesServerBase.Companion.getDEFAULT_HANDLER()).set(defaultHandler);
                                            }
                                        });
                                        channel = null;
                                        v0 = bootstrap.bind(this.$endpoint);
                                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"bind(...)");
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)bootstrap);
                                        this.label = 1;
                                        v1 = ExtensionsKt.awaitSuspend(v0, (Continuation<? super Channel>)((Continuation)this));
                                        ** if (v1 != var9_2) goto lbl16
lbl15:
                                        // 1 sources

                                        return var9_2;
lbl16:
                                        // 1 sources

                                        ** GOTO lbl24
                                    }
                                    case 1: {
                                        channel = null;
                                        bootstrap = (ServerBootstrap)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl24:
                                        // 2 sources

                                        channel = (Channel)v1;
                                        if (StationConstants.INSTANCE.isLinux()) {
                                            try {
                                                Files.setPosixFilePermissions(this.$endpoint.getPath(), this.$permissions);
                                            }
                                            catch (UnsupportedOperationException ex) {
                                                NettyServicesServerBase.access$getLogger$cp().debug("POSIX permissions are not supported", (Throwable)ex);
                                            }
                                            catch (Exception ex) {
                                                CoroutineScopeKt.ensureActive((CoroutineScope)this.$$this$launch);
                                                NettyServicesServerBase.access$getLogger$cp().error("Unable to set station socket permissions:", (Throwable)ex);
                                            }
                                        }
                                        NettyServicesServerBase.access$getLogger$cp().info("Services server started");
                                        NettyServicesServerBase.access$getRunningStateFlow$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)true));
                                        channel.closeFuture().addListener((GenericFutureListener<Future>)LambdaMetafactory.metafactory(null, null, null, (Lio/netty/util/concurrent/Future;)V, invokeSuspend$lambda$0(com.intellij.station.comms.common.netty.server.NettyServicesServerBase io.netty.util.concurrent.Future ), (Lio/netty/util/concurrent/Future;)V)((NettyServicesServerBase)this.this$0));
                                        if (this.$linkAddress != null) {
                                            try {
                                                Files.deleteIfExists(this.$linkAddress.getPath());
                                                Files.createSymbolicLink(this.$linkAddress.getPath(), this.$endpoint.getPath(), new FileAttribute[0]);
                                            }
                                            catch (Exception ex) {
                                                NettyServicesServerBase.access$getLogger$cp().warn("Unable to create link " + this.$linkAddress.getPath() + " -> " + this.$endpoint.getPath(), (Throwable)ex);
                                            }
                                        }
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)bootstrap);
                                        this.L$1 = channel;
                                        this.label = 2;
                                        v2 = DelayKt.awaitCancellation((Continuation)((Continuation)this));
                                        ** if (v2 != var9_2) goto lbl57
lbl56:
                                        // 1 sources

                                        return var9_2;
lbl57:
                                        // 1 sources

                                        ** GOTO lbl65
                                    }
                                    case 2: {
                                        channel = (Channel)this.L$1;
                                        bootstrap = (ServerBootstrap)this.L$0;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v2 = $result;
lbl65:
                                            // 2 sources

                                            throw new KotlinNothingValueException();
                                        }
                                        catch (Throwable var4_10) {
                                            NettyServicesServerBase.access$getLogger$cp().info("Shutting down services server");
                                            v3 = channel;
                                            if (v3 != null) {
                                                v3.close();
                                            }
                                            Files.deleteIfExists(this.$endpoint.getPath());
                                            v4 = this.$linkAddress;
                                            if (v4 != null) {
                                                it = v4;
                                                $i$a$-let-NettyServicesServerBase$2$1$2 = false;
                                                Boxing.boxBoolean((boolean)Files.deleteIfExists(it.getPath()));
                                            }
                                            throw var4_10;
                                        }
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final void invokeSuspend$lambda$0(NettyServicesServerBase this$0, Future it) {
                                logger.info("Services server shut down");
                                this$0.runningStateFlow.setValue((Object)false);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, endpoint, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ NettyServicesServerBase this$0;
            final /* synthetic */ UnixDomainSocketAddress $endpoint;
            {
                this.this$0 = $receiver;
                this.$endpoint = $endpoint;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$launch;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.runningStateFlow), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>((CoroutineScope)$this$launch, this.$endpoint, this.this$0, null){
                            Object L$0;
                            int label;
                            /* synthetic */ boolean Z$0;
                            final /* synthetic */ CoroutineScope $$this$launch;
                            final /* synthetic */ UnixDomainSocketAddress $endpoint;
                            final /* synthetic */ NettyServicesServerBase this$0;
                            {
                                this.$$this$launch = $$this$launch;
                                this.$endpoint = $endpoint;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                block10: {
                                    var2_2 = this.Z$0;
                                    var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            if (it == false) {
                                                return Unit.INSTANCE;
                                            }
lbl8:
                                            // 6 sources

                                            while (CoroutineScopeKt.isActive((CoroutineScope)this.$$this$launch)) {
                                                this.L$0 = null;
                                                this.Z$0 = it;
                                                this.label = 1;
                                                v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                                                if (v0 == var4_3) {
                                                    return var4_3;
                                                }
                                                ** GOTO lbl21
                                            }
                                            break block10;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl21:
                                            // 2 sources

                                            try {
                                                v1 = this.$endpoint.getPath();
                                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getPath(...)");
                                                NettyServicesServerBase.Companion.bumpModificationTime(v1);
                                                ** GOTO lbl8
                                            }
                                            catch (IOException ex) {
                                                if (!(ex instanceof NoSuchFileException) && !(ex instanceof FileNotFoundException)) break;
                                                NettyServicesServerBase.access$getLogger$cp().warn("Station server socket file at " + this.$endpoint.getPath() + " not found, will restart server");
                                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)ex);
                                                this.Z$0 = it;
                                                this.label = 2;
                                                v2 = NettyServicesServerBase.access$getServerAttemptFlow$p(this.this$0).emit((Object)Unit.INSTANCE, (Continuation)this);
                                                if (v2 != var4_3) ** GOTO lbl8
                                                return var4_3;
                                            }
                                        }
                                        case 2: {
                                            ex = (IOException)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v2 = $result;
                                            ** GOTO lbl8
                                        }
                                    }
                                    NettyServicesServerBase.access$getLogger$cp().error("Unexpected IO error watching station server socket file at " + this.$endpoint.getPath(), (Throwable)ex);
                                    ** GOTO lbl8
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.Z$0 = (Boolean)value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(NettyServicesServerBase $this) {
        return $this.scope;
    }

    public static final /* synthetic */ ServicesServerHostApplication access$getHostApplication$p(NettyServicesServerBase $this) {
        return $this.hostApplication;
    }

    static {
        Logging logging = Logging.INSTANCE;
        Companion $this$myLogger$iv = Companion;
        boolean $i$f$myLogger = false;
        Logger logger = LoggerFactory.getLogger(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        NettyServicesServerBase.logger = logger;
        AttributeKey attributeKey = AttributeKey.valueOf("default.channel.handler");
        Intrinsics.checkNotNullExpressionValue(attributeKey, (String)"valueOf(...)");
        DEFAULT_HANDLER = attributeKey;
        serversCounter = new AtomicInteger();
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeKey<ChannelHandler> getDEFAULT_HANDLER() {
            return DEFAULT_HANDLER;
        }

        @VisibleForTesting
        public final void bumpModificationTime(@NotNull Path path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            path2.toFile().setLastModified(System.currentTimeMillis());
            if (!Files.exists(path2, new LinkOption[0])) {
                throw new NoSuchFileException(((Object)path2).toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

